/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class QueuedContextStruct
implements Serializable {
    private StepContext context;
    private List<LockableResourcesStruct> lockableResourcesStruct;
    private String resourceDescription;
    private String variableName;
    private long queuedAt = 0L;
    public transient List<String> candidates = null;
    private static final Logger LOGGER = Logger.getLogger(QueuedContextStruct.class.getName());
    private static final long serialVersionUID = 1L;

    @Restricted(value={NoExternalUse.class})
    public QueuedContextStruct(StepContext context, List<LockableResourcesStruct> lockableResourcesStruct, String resourceDescription, String variableName) {
        this.context = context;
        this.lockableResourcesStruct = lockableResourcesStruct;
        this.resourceDescription = resourceDescription;
        this.variableName = variableName;
        this.queuedAt = new Date().getTime();
    }

    @Restricted(value={NoExternalUse.class})
    public StepContext getContext() {
        return this.context;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public Run<?, ?> getBuild() {
        try {
            if (this.getContext() == null) {
                return null;
            }
            return (Run)this.getContext().get(Run.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot get the build object from the context to proceed with lock. The build probably does not exists (deleted?)", e);
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isValid() {
        Run<?, ?> run = this.getBuild();
        if (run == null || !run.isBuilding()) {
            LOGGER.warning("The queue " + this + " will be removed, because the build does not exists");
            return false;
        }
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public List<LockableResourcesStruct> getResources() {
        return this.lockableResourcesStruct;
    }

    @Restricted(value={NoExternalUse.class})
    public String getResourceDescription() {
        return this.resourceDescription;
    }

    @Restricted(value={NoExternalUse.class})
    public String getVariableName() {
        return this.variableName;
    }

    @Restricted(value={NoExternalUse.class})
    public long getAddTime() {
        return this.queuedAt;
    }

    @Restricted(value={NoExternalUse.class})
    public String toString() {
        return "build: " + this.getBuild() + " resources: " + this.getResourceDescription() + " added at: " + this.getAddTime();
    }

    @Restricted(value={NoExternalUse.class})
    public PrintStream getLogger() {
        PrintStream logger = null;
        try {
            TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
            if (taskListener != null) {
                logger = taskListener.getLogger();
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.FINE, "Could not get logger for next context: " + e, e);
        }
        return logger;
    }
}

