/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Run;
import hudson.model.Saveable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkins.plugins.lockableresources.ExcludeFromJacocoGeneratedReport;
import org.jenkins.plugins.lockableresources.LockStepExecution;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourceProperty;
import org.jenkins.plugins.lockableresources.Messages;
import org.jenkins.plugins.lockableresources.ResourceSelectStrategy;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.QueuedContextStruct;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class LockableResourcesManager
extends GlobalConfiguration {
    public static final transient Object syncResources = new Object();
    private List<LockableResource> resources;
    private transient Cache<Long, List<LockableResource>> cachedCandidates = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Logger LOGGER = Logger.getLogger(LockableResourcesManager.class.getName());
    private List<QueuedContextStruct> queuedContexts = new ArrayList<QueuedContextStruct>();
    private transient int lastCheckedQueueIndex = -1;
    private int enableSave = -1;
    private static final int enabledBlockedCount = SystemProperties.getInteger((String)"org.jenkins.plugins.lockableresources.PRINT_BLOCKED_RESOURCE", (Integer)2);
    private static final int enabledCausesCount = SystemProperties.getInteger((String)"org.jenkins.plugins.lockableresources.PRINT_QUEUE_INFO", (Integer)2);

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="Common Jenkins pattern to call method that can be overridden")
    public LockableResourcesManager() {
        this.resources = new ArrayList<LockableResource>();
        this.load();
    }

    public List<LockableResource> getResources() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public List<LockableResource> getReadOnlyResources() {
        Object object = syncResources;
        synchronized (object) {
            return new ArrayList<LockableResource>(Collections.unmodifiableCollection(this.resources));
        }
    }

    public List<LockableResource> getDeclaredResources() {
        ArrayList<LockableResource> declaredResources = new ArrayList<LockableResource>();
        for (LockableResource r : this.getReadOnlyResources()) {
            if (r.isEphemeral() || r.isNodeResource()) continue;
            declaredResources.add(r);
        }
        return declaredResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DataBoundSetter
    public void setDeclaredResources(List<LockableResource> declaredResources) {
        Object object = syncResources;
        synchronized (object) {
            HashMap<String, LockableResource> lockedResources = new HashMap<String, LockableResource>();
            for (LockableResource r : this.resources) {
                if (!r.isLocked()) continue;
                lockedResources.put(r.getName(), r);
            }
            ArrayList<LockableResource> mergedResources = new ArrayList<LockableResource>();
            HashSet<String> addedLocks = new HashSet<String>();
            for (LockableResource r : declaredResources) {
                if (!addedLocks.add(r.getName())) continue;
                LockableResource locked = (LockableResource)lockedResources.remove(r.getName());
                if (locked != null) {
                    locked.setDescription(r.getDescription());
                    locked.setLabels(r.getLabels());
                    locked.setEphemeral(false);
                    locked.setNote(r.getNote());
                    mergedResources.add(locked);
                    continue;
                }
                mergedResources.add(r);
            }
            for (LockableResource r : lockedResources.values()) {
                r.setDescription("");
                r.setLabels("");
                r.setNote("");
                r.setEphemeral(true);
                mergedResources.add(r);
            }
            this.resources = mergedResources;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public List<LockableResource> getResourcesFromProject(String fullName) {
        ArrayList<LockableResource> matching = new ArrayList<LockableResource>();
        for (LockableResource r : this.getReadOnlyResources()) {
            String rName = r.getQueueItemProject();
            if (rName == null || !rName.equals(fullName)) continue;
            matching.add(r);
        }
        return matching;
    }

    @Restricted(value={NoExternalUse.class})
    public List<LockableResource> getResourcesFromBuild(Run<?, ?> build) {
        ArrayList<LockableResource> matching = new ArrayList<LockableResource>();
        for (LockableResource r : this.getReadOnlyResources()) {
            Run<?, ?> rBuild = r.getBuild();
            if (rBuild == null || rBuild != build) continue;
            matching.add(r);
        }
        return matching;
    }

    @Restricted(value={NoExternalUse.class})
    public Boolean isValidLabel(@Nullable String label) {
        if (label == null || label.isEmpty()) {
            return false;
        }
        for (LockableResource r : this.getReadOnlyResources()) {
            if (r == null || !r.isValidLabel(label)) continue;
            return true;
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public Set<String> getAllLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (LockableResource r : this.getReadOnlyResources()) {
            List<String> toAdd;
            if (r == null || (toAdd = r.getLabelsAsList()).isEmpty()) continue;
            labels.addAll(toAdd);
        }
        return labels;
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    @ExcludeFromJacocoGeneratedReport
    @NonNull
    public int getFreeResourceAmount(String label) {
        int free = 0;
        if ((label = Util.fixEmpty((String)label)) == null) {
            return free;
        }
        for (LockableResource r : this.getResourcesWithLabel(label)) {
            if (r == null || !r.isFree()) continue;
            ++free;
        }
        return free;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @ExcludeFromJacocoGeneratedReport
    public List<LockableResource> getResourcesWithLabel(String label, Map<String, Object> params) {
        return this.getResourcesWithLabel(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public List<LockableResource> getResourcesWithLabel(String label) {
        Object object = syncResources;
        synchronized (object) {
            return LockableResourcesManager._getResourcesWithLabel(label, this.getResources());
        }
    }

    @NonNull
    private static List<LockableResource> _getResourcesWithLabel(String label, List<LockableResource> resources) {
        ArrayList<LockableResource> found = new ArrayList<LockableResource>();
        if ((label = Util.fixEmpty((String)label)) == null) {
            return found;
        }
        for (LockableResource r : resources) {
            if (r == null || !r.isValidLabel(label)) continue;
            found.add(r);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public List<LockableResource> getResourcesMatchingScript(@NonNull SecureGroovyScript script, @CheckForNull Map<String, Object> params) throws ExecutionException {
        ArrayList<LockableResource> found = new ArrayList<LockableResource>();
        Object object = syncResources;
        synchronized (object) {
            for (LockableResource r : this.resources) {
                if (!r.scriptMatches(script, params)) continue;
                found.add(r);
            }
        }
        return found;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public LockableResource fromName(@CheckForNull String resourceName) {
        if ((resourceName = Util.fixEmpty((String)resourceName)) != null) {
            for (LockableResource r : this.getReadOnlyResources()) {
                if (!resourceName.equals(r.getName())) continue;
                return r;
            }
        } else {
            LOGGER.warning("Internal failure, fromName is empty or null:" + this.getStack());
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public List<LockableResource> fromNames(List<String> names) {
        return this.fromNames(names, false);
    }

    @Restricted(value={NoExternalUse.class})
    public List<LockableResource> fromNames(List<String> names, boolean createResource) {
        ArrayList<LockableResource> list = new ArrayList<LockableResource>();
        for (String name : names) {
            LockableResource r;
            if (createResource) {
                this.createResource(name);
            }
            if ((r = this.fromName(name)) == null) continue;
            list.add(r);
        }
        return list;
    }

    private String getStack() {
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement st : Thread.currentThread().getStackTrace()) {
            buf.append("\n").append(st);
        }
        return buf.toString();
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public boolean resourceExist(@CheckForNull String resourceName) {
        return this.fromName(resourceName) != null;
    }

    public boolean queue(List<LockableResource> resources, long queueItemId, String queueProjectName) {
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isQueued(queueItemId) && !r.isLocked()) continue;
            return false;
        }
        for (LockableResource r : resources) {
            r.setQueued(queueItemId, queueProjectName);
        }
        return true;
    }

    @Deprecated
    @ExcludeFromJacocoGeneratedReport
    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public List<LockableResource> queue(LockableResourcesStruct requiredResources, long queueItemId, String queueItemProject, int number, Map<String, Object> params, Logger log) {
        try {
            return this.tryQueue(requiredResources, queueItemId, queueItemProject, number, params, log);
        }
        catch (ExecutionException ex) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                String itemName = queueItemProject + " (id=" + queueItemId + ")";
                LOGGER.log(Level.WARNING, "Failed to queue item " + itemName, ex.getCause() != null ? ex.getCause() : ex);
            }
            return null;
        }
    }

    public boolean uncacheIfFreeing(LockableResource candidate, boolean unlocking, boolean unreserving) {
        if (candidate.isLocked() && !unlocking) {
            return false;
        }
        if ((candidate.isReserved() || candidate.isStolen()) && !unreserving) {
            return false;
        }
        if (this.cachedCandidates.size() == 0L) {
            return true;
        }
        ConcurrentMap cachedCandidatesMap = this.cachedCandidates.asMap();
        for (Map.Entry entry : cachedCandidatesMap.entrySet()) {
            Long queueItemId = (Long)entry.getKey();
            List candidates = (List)entry.getValue();
            if (candidates == null || candidates.size() != 0 && !candidates.contains(candidate)) continue;
            this.cachedCandidates.invalidate((Object)queueItemId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public List<LockableResource> tryQueue(LockableResourcesStruct requiredResources, long queueItemId, String queueItemProject, int number, Map<String, Object> params, Logger log) throws ExecutionException {
        ArrayList<LockableResource> selected = new ArrayList<LockableResource>();
        Object object = syncResources;
        synchronized (object) {
            int required_amount;
            if (!this.checkCurrentResourcesStatus(selected, queueItemProject, queueItemId, log)) {
                log.log(Level.FINEST, "{0} has another build waiting resources. Waiting for it to proceed first.", new Object[]{queueItemProject});
                return null;
            }
            SecureGroovyScript systemGroovyScript = requiredResources.getResourceMatchScript();
            boolean candidatesByScript = systemGroovyScript != null;
            List<LockableResource> candidates = requiredResources.required;
            if (candidatesByScript || requiredResources.label != null && !requiredResources.label.isEmpty()) {
                candidates = (List<LockableResource>)this.cachedCandidates.getIfPresent((Object)queueItemId);
                if (candidates != null) {
                    candidates.retainAll(this.resources);
                } else {
                    candidates = systemGroovyScript == null ? this.getResourcesWithLabel(requiredResources.label) : this.getResourcesMatchingScript(systemGroovyScript, params);
                    this.cachedCandidates.put((Object)queueItemId, candidates);
                }
            }
            for (LockableResource rs : candidates) {
                if (number != 0 && selected.size() >= number) break;
                if (rs.isReserved() || rs.isLocked() || rs.isQueued()) continue;
                selected.add(rs);
            }
            if (candidatesByScript && candidates.isEmpty()) {
                required_amount = 0;
            } else {
                int n = required_amount = number == 0 ? candidates.size() : number;
            }
            if (selected.size() != required_amount) {
                log.log(Level.FINEST, "{0} found {1} resource(s) to queue.Waiting for correct amount: {2}.", new Object[]{queueItemProject, selected.size(), required_amount});
                for (LockableResource x : this.resources) {
                    if (x.getQueueItemProject() == null || !x.getQueueItemProject().equals(queueItemProject)) continue;
                    x.unqueue();
                }
                return null;
            }
            for (LockableResource rsc : selected) {
                rsc.setQueued(queueItemId, queueItemProject);
            }
        }
        return selected;
    }

    private boolean checkCurrentResourcesStatus(List<LockableResource> selected, String project, long taskId, Logger log) {
        for (LockableResource r : this.resources) {
            String rProject = r.getQueueItemProject();
            if (rProject == null || !rProject.equals(project)) continue;
            if (r.isQueuedByTask(taskId)) {
                selected.add(r);
                continue;
            }
            log.log(Level.FINEST, "{0} has another build that already queued resource {1}. Continue queueing.", new Object[]{project, r});
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean lock(List<LockableResource> resources, Run<?, ?> build, @Nullable StepContext context) {
        return this.lock(resources, build);
    }

    @Deprecated
    public boolean lock(List<LockableResource> resources, Run<?, ?> build, @Nullable StepContext context, @Nullable String logmessage, String variable, boolean inversePrecedence) {
        return this.lock(resources, build);
    }

    public boolean lock(List<LockableResource> resources, Run<?, ?> build) {
        LOGGER.fine("lock it: " + resources + " for build " + build);
        if (build == null) {
            LOGGER.warning("lock() will fails, because the build does not exits. " + resources);
            return false;
        }
        String cause = this.getCauses(resources);
        if (!cause.isEmpty()) {
            LOGGER.warning("lock() for build " + build + " will fails, because " + cause);
            return false;
        }
        for (LockableResource r : resources) {
            r.unqueue();
            r.setBuild(build);
        }
        this.save();
        return true;
    }

    private void freeResources(List<LockableResource> unlockResources, @Nullable Run<?, ?> build) {
        LOGGER.fine("free it: " + unlockResources);
        for (LockableResource resource : unlockResources) {
            if (build != null && build != resource.getBuild()) continue;
            resource.unqueue();
            resource.setBuild(null);
            this.uncacheIfFreeing(resource, true, false);
            if (!resource.isEphemeral()) continue;
            LOGGER.fine("Remove ephemeral resource: " + resource);
            this.resources.remove(resource);
        }
    }

    public void unlock(List<LockableResource> resourcesToUnLock, @Nullable Run<?, ?> build) {
        this.unlock(resourcesToUnLock, build, false);
    }

    public void unlock(@Nullable List<LockableResource> resourcesToUnLock, @Nullable Run<?, ?> build, boolean inversePrecedence) {
        List<String> resourceNamesToUnLock = LockableResourcesManager.getResourcesNames(resourcesToUnLock);
        this.unlockNames(resourceNamesToUnLock, build, inversePrecedence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="not sure which exceptions might be catch.")
    public void unlockNames(@Nullable List<String> resourceNamesToUnLock, @Nullable Run<?, ?> build, boolean inversePrecedence) {
        if (resourceNamesToUnLock == null || resourceNamesToUnLock.isEmpty()) {
            return;
        }
        Object object = syncResources;
        synchronized (object) {
            this.freeResources(this.fromNames(resourceNamesToUnLock), build);
            this.lastCheckedQueueIndex = -1;
            block3: while (resourceNamesToUnLock.size() > 0 && this.proceedNextContext(inversePrecedence)) {
                String resourceName;
                LockableResource r;
                Iterator<String> iterator = resourceNamesToUnLock.iterator();
                while (iterator.hasNext() && (r = this.fromName(resourceName = iterator.next())) != null) {
                    if (r.isFree()) continue;
                    resourceNamesToUnLock.remove(resourceName);
                    continue block3;
                }
            }
            this.save();
        }
    }

    private boolean proceedNextContext(boolean inversePrecedence) {
        LOGGER.finest("inversePrecedence: " + inversePrecedence);
        QueuedContextStruct nextContext = this.getNextQueuedContext(inversePrecedence);
        LOGGER.finest("nextContext: " + nextContext);
        if (nextContext == null) {
            LOGGER.fine("No context is queued which can be started once these resources are free'd.");
            return false;
        }
        LOGGER.finest("nextContext candidates: " + nextContext.candidates);
        List<LockableResource> requiredResourceForNextContext = this.fromNames(nextContext.candidates, true);
        LOGGER.finest("nextContext real candidates: " + requiredResourceForNextContext);
        Run<?, ?> build = nextContext.getBuild();
        if (build == null) {
            LOGGER.warning("Skip this context, as the build cannot be retrieved");
            return true;
        }
        boolean locked = this.lock(requiredResourceForNextContext, build);
        if (!locked) {
            LOGGER.warning("Can not lock resources: " + requiredResourceForNextContext);
            return false;
        }
        LinkedHashMap<String, List<LockableResourceProperty>> resourcesToLock = new LinkedHashMap<String, List<LockableResourceProperty>>();
        for (LockableResource requiredResource : requiredResourceForNextContext) {
            resourcesToLock.put(requiredResource.getName(), requiredResource.getProperties());
        }
        this.unqueueContext(nextContext.getContext());
        LockStepExecution.proceed(resourcesToLock, nextContext.getContext(), nextContext.getResourceDescription(), nextContext.getVariableName(), inversePrecedence);
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public static List<String> getResourcesNames(List<LockableResource> resources) {
        ArrayList<String> resourceNames = new ArrayList<String>();
        if (resources != null) {
            for (LockableResource resource : resources) {
                resourceNames.add(resource.getName());
            }
        }
        return resourceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public List<String> getAllResourcesNames() {
        Object object = syncResources;
        synchronized (object) {
            return LockableResourcesManager.getResourcesNames(this.resources);
        }
    }

    @CheckForNull
    private QueuedContextStruct getNextQueuedContext(boolean inversePrecedence) {
        LOGGER.fine("current queue size: " + this.queuedContexts.size());
        LOGGER.finest("current queue: " + this.queuedContexts);
        ArrayList<QueuedContextStruct> orphan = new ArrayList<QueuedContextStruct>();
        QueuedContextStruct nextEntry = null;
        if (inversePrecedence) {
            this.lastCheckedQueueIndex = this.lastCheckedQueueIndex == -1 ? this.queuedContexts.size() - 1 : ++this.lastCheckedQueueIndex;
            while (this.lastCheckedQueueIndex >= 0 && nextEntry == null) {
                QueuedContextStruct entry = this.queuedContexts.get(this.lastCheckedQueueIndex);
                if (!entry.isValid()) {
                    orphan.add(entry);
                } else {
                    LOGGER.finest("inversePrecedence - index: " + this.lastCheckedQueueIndex + " " + entry);
                    nextEntry = this.getNextQueuedContextEntry(entry);
                }
                --this.lastCheckedQueueIndex;
            }
        } else {
            this.lastCheckedQueueIndex = this.lastCheckedQueueIndex == -1 ? 0 : --this.lastCheckedQueueIndex;
            while (this.lastCheckedQueueIndex < this.queuedContexts.size() && nextEntry == null) {
                QueuedContextStruct entry = this.queuedContexts.get(this.lastCheckedQueueIndex);
                if (!entry.isValid()) {
                    orphan.add(entry);
                } else {
                    LOGGER.finest("oldest win - index: " + this.lastCheckedQueueIndex + " " + entry);
                    nextEntry = this.getNextQueuedContextEntry(entry);
                }
                ++this.lastCheckedQueueIndex;
            }
        }
        if (!orphan.isEmpty()) {
            this.queuedContexts.removeAll(orphan);
            this.lastCheckedQueueIndex = -1;
        }
        if (nextEntry == null) {
            this.lastCheckedQueueIndex = -1;
        }
        return nextEntry;
    }

    QueuedContextStruct getNextQueuedContextEntry(QueuedContextStruct entry) {
        List<LockableResource> candidates = this.getAvailableResources(entry.getResources());
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        entry.candidates = LockableResourcesManager.getResourcesNames(candidates);
        LOGGER.fine("take this: " + entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public List<QueuedContextStruct> getCurrentQueuedContext() {
        Object object = syncResources;
        synchronized (object) {
            return Collections.unmodifiableList(this.queuedContexts);
        }
    }

    public boolean createResource(@CheckForNull String name) {
        name = Util.fixEmptyAndTrim((String)name);
        LockableResource resource = new LockableResource(name);
        resource.setEphemeral(true);
        return this.addResource(resource, true);
    }

    public boolean createResourceWithLabel(@CheckForNull String name, @CheckForNull String label) {
        name = Util.fixEmptyAndTrim((String)name);
        label = Util.fixEmptyAndTrim((String)label);
        LockableResource resource = new LockableResource(name);
        resource.setLabels(label);
        return this.addResource(resource, true);
    }

    public boolean createResourceWithLabelAndProperties(@CheckForNull String name, @CheckForNull String label, Map<String, String> properties) {
        if (properties == null) {
            return false;
        }
        name = Util.fixEmptyAndTrim((String)name);
        label = Util.fixEmptyAndTrim((String)label);
        LockableResource resource = new LockableResource(name);
        resource.setLabels(label);
        resource.setProperties(properties.entrySet().stream().map(e -> {
            LockableResourceProperty p = new LockableResourceProperty();
            p.setName((String)e.getKey());
            p.setValue((String)e.getValue());
            return p;
        }).collect(Collectors.toList()));
        return this.addResource(resource, true);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean addResource(@Nullable LockableResource resource) {
        return this.addResource(resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public boolean addResource(@Nullable LockableResource resource, boolean doSave) {
        if (resource == null || resource.getName() == null || resource.getName().isEmpty()) {
            LOGGER.warning("Internal failure: We will add wrong resource: '" + resource + "' " + this.getStack());
            return false;
        }
        Object object = syncResources;
        synchronized (object) {
            if (this.resourceExist(resource.getName())) {
                LOGGER.finest("We will add existing resource: " + resource + this.getStack());
                return false;
            }
            this.resources.add(resource);
            LOGGER.fine("Resource added : " + resource);
            if (doSave) {
                this.save();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserve(List<LockableResource> resources, String userName) {
        Object object = syncResources;
        synchronized (object) {
            for (LockableResource r : resources) {
                if (r.isFree()) continue;
                return false;
            }
            for (LockableResource r : resources) {
                r.reserve(userName);
            }
            this.save();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean steal(List<LockableResource> resources, String userName) {
        Object object = syncResources;
        synchronized (object) {
            for (LockableResource r : resources) {
                r.setReservedBy(userName);
                r.setStolen();
            }
            this.unlock(resources, null, false);
            this.save();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reassign(List<LockableResource> resources, String userName) {
        Object object = syncResources;
        synchronized (object) {
            for (LockableResource r : resources) {
                if (!r.isFree()) {
                    r.unReserve();
                }
                r.setReservedBy(userName);
            }
            this.save();
        }
    }

    private void unreserveResources(@NonNull List<LockableResource> resources) {
        for (LockableResource l : resources) {
            this.uncacheIfFreeing(l, false, true);
            l.unReserve();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="not sure which exceptions might be catch.")
    public void unreserve(List<LockableResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        Object object = syncResources;
        synchronized (object) {
            LOGGER.fine("unreserve " + resources);
            this.unreserveResources(resources);
            this.proceedNextContext(false);
            this.save();
        }
    }

    @NonNull
    public String getDisplayName() {
        return Messages.LockableResourcesManager_displayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(List<LockableResource> resources) {
        Object object = syncResources;
        synchronized (object) {
            for (LockableResource r : resources) {
                this.uncacheIfFreeing(r, true, true);
                r.reset();
            }
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(List<LockableResource> resources) {
        Object object = syncResources;
        synchronized (object) {
            this.unlock(resources, null);
            this.unreserve(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configure(StaplerRequest req, JSONObject json) {
        Object object = syncResources;
        synchronized (object) {
            ArrayList<LockableResource> oldDeclaredResources = new ArrayList<LockableResource>(this.getDeclaredResources());
            try (BulkChange bc = new BulkChange((Saveable)this);){
                this.resources.removeIf(resource -> !resource.isLocked());
                req.bindJSON((Object)this, json);
                bc.commit();
            }
            catch (IOException exception) {
                LOGGER.log(Level.WARNING, "Exception occurred while committing bulkchange operation.", exception);
                return false;
            }
            boolean updated = false;
            for (LockableResource oldDeclaredResource : oldDeclaredResources) {
                LockableResource updatedResource = this.fromName(oldDeclaredResource.getName());
                if (updatedResource == null) continue;
                updatedResource.copyUnconfigurableProperties(oldDeclaredResource);
                updated = true;
            }
            if (updated) {
                this.save();
            }
        }
        return true;
    }

    public List<LockableResource> getAvailableResources(List<LockableResourcesStruct> requiredResourcesList) {
        return this.getAvailableResources(requiredResourcesList, null, null);
    }

    public List<LockableResource> getAvailableResources(List<LockableResourcesStruct> requiredResourcesList, @Nullable PrintStream logger, @Nullable ResourceSelectStrategy selectStrategy) {
        LOGGER.finest("getAvailableResources, " + requiredResourcesList);
        ArrayList<LockableResource> candidates = new ArrayList<LockableResource>();
        for (LockableResourcesStruct requiredResources : requiredResourcesList) {
            boolean isPreReserved;
            List<Object> available = new ArrayList();
            if (!StringUtils.isBlank((String)requiredResources.label)) {
                int requiredAmount = 0;
                if (requiredResources.requiredNumber != null) {
                    try {
                        requiredAmount = Integer.parseInt(requiredResources.requiredNumber);
                    }
                    catch (NumberFormatException e) {
                        requiredAmount = 0;
                    }
                }
                available = this.getFreeResourcesWithLabel(requiredResources.label, requiredAmount, selectStrategy, logger, candidates);
            } else if (requiredResources.required != null) {
                available = this.fromNames(LockableResourcesManager.getResourcesNames(requiredResources.required), true);
                if (!this.areAllAvailable(available)) {
                    available = null;
                }
            } else {
                LOGGER.warning("getAvailableResources, Not implemented: " + requiredResources);
            }
            if (available == null || available.isEmpty()) {
                LOGGER.finest("No available resources found " + requiredResourcesList);
                return null;
            }
            boolean bl = isPreReserved = !Collections.disjoint(candidates, available);
            if (isPreReserved) {
                LockableResourcesManager.printLogs("Extra filter tries to allocate pre-reserved resources.", logger, Level.WARNING);
                available.removeAll(candidates);
            }
            candidates.addAll(available);
        }
        return candidates;
    }

    private boolean areAllAvailable(List<LockableResource> resources) {
        for (LockableResource resource : resources) {
            if (resource.isFree()) continue;
            return false;
        }
        return true;
    }

    public static void printLogs(String msg, Level level, Logger L, @Nullable PrintStream logger) {
        L.log(level, msg);
        if (logger != null) {
            if (level == Level.WARNING || level == Level.SEVERE) {
                logger.println(level.getLocalizedName() + ": " + msg);
            } else {
                logger.println(msg);
            }
        }
    }

    private static void printLogs(String msg, @Nullable PrintStream logger, Level level) {
        LockableResourcesManager.printLogs(msg, level, LOGGER, logger);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    private List<LockableResource> getFreeResourcesWithLabel(@NonNull String label, long amount, @Nullable ResourceSelectStrategy selectStrategy, @Nullable PrintStream logger, List<LockableResource> alreadySelected) {
        ArrayList<LockableResource> found = new ArrayList<LockableResource>();
        List<LockableResource> candidates = LockableResourcesManager._getResourcesWithLabel(label, alreadySelected);
        candidates.addAll(this.getResourcesWithLabel(label));
        if (amount <= 0L) {
            amount = candidates.size();
        }
        if ((long)candidates.size() < amount) {
            LockableResourcesManager.printLogs("Found " + found.size() + " possible resource(s). Waiting for correct amount: " + amount + ".This may remain stuck, until you create enough resources", logger, Level.WARNING);
            return null;
        }
        if (selectStrategy != null && selectStrategy.equals((Object)ResourceSelectStrategy.RANDOM)) {
            Collections.shuffle(candidates);
        }
        for (LockableResource r : candidates) {
            if (!r.isReserved() && !r.isLocked()) {
                found.add(r);
            }
            if (amount <= 0L || (long)found.size() < amount) continue;
            return found;
        }
        String msg = "Found " + found.size() + " available resource(s). Waiting for correct amount: " + amount + ".";
        if (enabledBlockedCount != 0) {
            msg = msg + "\nBlocking causes: " + this.getCauses(candidates);
        }
        LockableResourcesManager.printLogs(msg, logger, Level.FINE);
        return null;
    }

    private String getCauses(List<LockableResource> resources) {
        StringBuilder buf = new StringBuilder();
        int currentSize = 0;
        for (LockableResource resource : resources) {
            String cause = resource.getLockCauseDetail();
            if (cause == null) continue;
            if (enabledBlockedCount > 0 && ++currentSize == enabledBlockedCount) {
                buf.append("\n  ...");
                break;
            }
            buf.append("\n  ").append(cause);
            String queueCause = this.getQueueCause(resource);
            if (queueCause.isEmpty()) continue;
            buf.append(queueCause);
        }
        return buf.toString();
    }

    private String getQueueCause(LockableResource resource) {
        HashMap usage = new HashMap();
        for (QueuedContextStruct entry : this.queuedContexts) {
            Run<?, ?> build = entry.getBuild();
            if (build == null) {
                LOGGER.warning("Why we don`t have the build? " + entry);
                continue;
            }
            int count = 0;
            if (usage.containsKey(build)) {
                count = (Integer)usage.get(build);
            }
            for (LockableResourcesStruct _struct : entry.getResources()) {
                if (!_struct.isResourceRequired(resource)) continue;
                LOGGER.fine("found " + resource + " " + count);
                ++count;
                break;
            }
            usage.put(build, count);
        }
        StringBuilder buf = new StringBuilder();
        int currentSize = 0;
        for (Map.Entry entry : usage.entrySet()) {
            Run build = (Run)entry.getKey();
            int count = (Integer)entry.getValue();
            if (build == null || count <= 0) continue;
            buf.append("\n    Queued ").append(count).append(" time(s) by build ").append(build.getFullDisplayName()).append(" ").append(ModelHyperlinkNote.encodeTo((Run)build));
            if (++currentSize < enabledCausesCount) continue;
            buf.append("\n    ...");
            break;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueContext(StepContext context, List<LockableResourcesStruct> requiredResources, String resourceDescription, String variableName) {
        Object object = syncResources;
        synchronized (object) {
            for (QueuedContextStruct entry : this.queuedContexts) {
                if (entry.getContext() != context) continue;
                LOGGER.warning("queueContext, duplicated, " + requiredResources);
                return;
            }
            this.queuedContexts.add(new QueuedContextStruct(context, requiredResources, resourceDescription, variableName));
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unqueueContext(StepContext context) {
        Object object = syncResources;
        synchronized (object) {
            ListIterator<QueuedContextStruct> iter = this.queuedContexts.listIterator();
            while (iter.hasNext()) {
                if (((QueuedContextStruct)iter.next()).getContext() != context) continue;
                iter.remove();
                this.save();
                return true;
            }
        }
        return false;
    }

    public static LockableResourcesManager get() {
        return (LockableResourcesManager)Jenkins.get().getDescriptorOrDie(LockableResourcesManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.enableSave == -1) {
            int n = this.enableSave = SystemProperties.getBoolean((String)"org.jenkins.plugins.lockableresources.DISABLE_SAVE") ? 0 : 1;
        }
        if (this.enableSave == 0) {
            return;
        }
        Object object = syncResources;
        synchronized (object) {
            if (BulkChange.contains((Saveable)this)) {
                return;
            }
            try {
                this.getConfigFile().write((Object)this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public LockableResource getFirst() {
        return this.getResources().get(0);
    }
}

