/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Node;
import hudson.slaves.ComputerListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;

@Extension
public class NodesMirror
extends ComputerListener {
    private static final Logger LOG = Logger.getLogger(NodesMirror.class.getName());

    private static boolean isNodeMirrorEnabled() {
        return SystemProperties.getBoolean((String)"org.jenkins.plugins.lockableresources.ENABLE_NODE_MIRROR");
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void createNodeResources() {
        LOG.log(Level.FINE, "lockable-resources-plugin configure node resources");
        NodesMirror.mirrorNodes();
    }

    public final void onConfigurationChange() {
        NodesMirror.mirrorNodes();
    }

    private static void mirrorNodes() {
        if (!NodesMirror.isNodeMirrorEnabled()) {
            return;
        }
        NodesMirror.deleteExistingNodes();
        for (Node n : Jenkins.get().getNodes()) {
            NodesMirror.mirrorNode(n);
        }
    }

    private static void deleteExistingNodes() {
        LockableResourcesManager lrm = LockableResourcesManager.get();
        Iterator<LockableResource> resourceIterator = lrm.getResources().iterator();
        while (resourceIterator.hasNext()) {
            LockableResource resource = resourceIterator.next();
            if (!resource.isNodeResource()) continue;
            if (resource.isFree()) {
                resourceIterator.remove();
                continue;
            }
            LOG.log(Level.FINE, "lockable-resources-plugin skip node deletion of: " + resource.getName() + ". Reason: Currently locked");
        }
    }

    private static void mirrorNode(Node node) {
        boolean exist;
        if (node == null) {
            return;
        }
        LockableResourcesManager lrm = LockableResourcesManager.get();
        LockableResource nodeResource = lrm.fromName(node.getNodeName());
        boolean bl = exist = nodeResource != null;
        if (!exist) {
            nodeResource = new LockableResource(node.getNodeName());
        }
        nodeResource.setLabels(node.getAssignedLabels().stream().map(Object::toString).collect(Collectors.joining(" ")));
        nodeResource.setNodeResource(true);
        nodeResource.setEphemeral(false);
        nodeResource.setDescription(node.getNodeDescription());
        LOG.log(Level.FINE, "lockable-resources-plugin add node-resource: " + nodeResource.getName());
        if (!exist) {
            lrm.getResources().add(nodeResource);
        }
    }
}

