/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.User;
import hudson.tasks.Mailer;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkins.plugins.lockableresources.ExcludeFromJacocoGeneratedReport;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.Messages;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class LockableResource
extends AbstractDescribableImpl<LockableResource>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(LockableResource.class.getName());
    public static final int NOT_QUEUED = 0;
    private static final int QUEUE_TIMEOUT = 60;
    public static final String GROOVY_LABEL_MARKER = "groovy:";
    private final String name;
    private String description = "";
    @Deprecated
    private transient String labels = null;
    private List<String> labelsAsList = new ArrayList<String>();
    private String reservedBy = null;
    private Date reservedTimestamp = null;
    private String note = "";
    private boolean stolen = false;
    private boolean ephemeral;
    private long queueItemId = 0L;
    private String queueItemProject = null;
    private transient Run<?, ?> build = null;
    private String buildExternalizableId = null;
    private long queuingStarted = 0L;
    private static final long serialVersionUID = 1L;
    @Deprecated
    private List<StepContext> queuedContexts = new ArrayList<StepContext>();

    @Deprecated
    @ExcludeFromJacocoGeneratedReport
    public LockableResource(String name, String description, String labels, String reservedBy, String note) {
        this.name = name;
        this.setDescription(description);
        this.setLabels(labels);
        this.setReservedBy(reservedBy);
        this.setNote(note);
    }

    @DataBoundConstructor
    public LockableResource(String name) {
        this.name = Util.fixNull((String)name);
    }

    protected Object readResolve() {
        if (this.queuedContexts == null) {
            this.queuedContexts = new ArrayList<StepContext>();
        }
        this.repairLabels();
        return this;
    }

    private void repairLabels() {
        if (this.labels == null) {
            return;
        }
        LOGGER.fine("Repair labels for resource " + this);
        this.setLabels(this.labels);
        this.labels = null;
    }

    @Deprecated
    @ExcludeFromJacocoGeneratedReport
    public List<StepContext> getQueuedContexts() {
        return this.queuedContexts;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = Util.fixNull((String)description);
    }

    @Exported
    public String getNote() {
        return this.note;
    }

    @DataBoundSetter
    public void setNote(String note) {
        this.note = Util.fixNull((String)note);
    }

    @DataBoundSetter
    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    @Exported
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    @Deprecated
    @Exported
    public String getLabels() {
        if (this.labelsAsList == null) {
            return "";
        }
        return String.join((CharSequence)" ", this.labelsAsList);
    }

    @DataBoundSetter
    public void setLabels(String labels) {
        this.labelsAsList = new ArrayList<String>();
        for (String label : labels.split("\\s+")) {
            if (label == null || label.isEmpty()) continue;
            this.labelsAsList.add(label);
        }
    }

    @Exported
    public List<String> getLabelsAsList() {
        return this.labelsAsList;
    }

    @Exported
    public boolean hasLabel(String labelToFind) {
        return this.labelsContain(labelToFind);
    }

    public boolean isValidLabel(String candidate, Map<String, Object> params) {
        return this.labelsContain(candidate);
    }

    private boolean labelsContain(String candidate) {
        return this.getLabelsAsList().contains(candidate);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean scriptMatches(@NonNull SecureGroovyScript script, @CheckForNull Map<String, Object> params) throws ExecutionException {
        Binding binding = new Binding(params);
        binding.setVariable("resourceName", (Object)this.name);
        binding.setVariable("resourceDescription", (Object)this.description);
        binding.setVariable("resourceLabels", this.getLabelsAsList());
        binding.setVariable("resourceNote", (Object)this.note);
        try {
            Object result = script.evaluate(Jenkins.get().getPluginManager().uberClassLoader, binding, null);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Checked resource " + this.name + " for " + script.getScript() + " with " + binding + " -> " + result);
            }
            return (Boolean)result;
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot get boolean result out of groovy expression. See system log for more info", e);
        }
    }

    @Exported
    public Date getReservedTimestamp() {
        return this.reservedTimestamp == null ? null : new Date(this.reservedTimestamp.getTime());
    }

    @DataBoundSetter
    public void setReservedTimestamp(Date reservedTimestamp) {
        this.reservedTimestamp = reservedTimestamp == null ? null : new Date(reservedTimestamp.getTime());
    }

    @Exported
    public String getReservedBy() {
        return this.reservedBy;
    }

    @Exported
    public boolean isReserved() {
        return this.reservedBy != null;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static String getUserName() {
        User current = User.current();
        if (current != null) {
            return current.getFullName();
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isReservedByCurrentUser() {
        return this.reservedBy != null && StringUtils.equals((CharSequence)LockableResource.getUserName(), (CharSequence)this.reservedBy);
    }

    @Exported
    public String getReservedByEmail() {
        if (this.isReserved()) {
            Mailer.UserProperty email = null;
            User user = Jenkins.get().getUser(this.reservedBy);
            if (user != null) {
                email = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
            }
            if (email != null) {
                return email.getAddress();
            }
        }
        return null;
    }

    public boolean isQueued() {
        this.validateQueuingTimeout();
        return this.queueItemId != 0L;
    }

    public boolean isQueued(long taskId) {
        this.validateQueuingTimeout();
        return this.queueItemId != 0L && this.queueItemId != taskId;
    }

    public boolean isQueuedByTask(long taskId) {
        this.validateQueuingTimeout();
        return this.queueItemId == taskId;
    }

    public void unqueue() {
        this.queueItemId = 0L;
        this.queueItemProject = null;
        this.queuingStarted = 0L;
    }

    @Exported
    public boolean isLocked() {
        return this.getBuild() != null;
    }

    @CheckForNull
    public String getLockCause() {
        String timestamp;
        DateFormat format = SimpleDateFormat.getDateTimeInstance(2, 3);
        String string = timestamp = this.reservedTimestamp == null ? "<unknown>" : format.format(this.reservedTimestamp);
        if (this.isReserved()) {
            return String.format("[%s] is reserved by %s at %s", this.name, this.reservedBy, timestamp);
        }
        if (this.isLocked()) {
            return String.format("[%s] is locked by %s at %s", this.name, this.buildExternalizableId, timestamp);
        }
        return null;
    }

    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public Run<?, ?> getBuild() {
        if (this.build == null && this.buildExternalizableId != null) {
            this.build = Run.fromExternalizableId((String)this.buildExternalizableId);
        }
        return this.build;
    }

    @Exported
    public String getBuildName() {
        if (this.getBuild() != null) {
            return this.getBuild().getFullDisplayName();
        }
        return null;
    }

    public void setBuild(Run<?, ?> lockedBy) {
        this.build = lockedBy;
        if (lockedBy != null) {
            this.buildExternalizableId = lockedBy.getExternalizableId();
            this.setReservedTimestamp(new Date());
        } else {
            this.buildExternalizableId = null;
            this.setReservedTimestamp(null);
        }
    }

    public Queue.Task getTask() {
        Queue.Item item = Queue.getInstance().getItem(this.queueItemId);
        if (item != null) {
            return item.task;
        }
        return null;
    }

    public long getQueueItemId() {
        this.validateQueuingTimeout();
        return this.queueItemId;
    }

    public String getQueueItemProject() {
        this.validateQueuingTimeout();
        return this.queueItemProject;
    }

    public void setQueued(long queueItemId) {
        this.queueItemId = queueItemId;
        this.queuingStarted = System.currentTimeMillis() / 1000L;
    }

    public void setQueued(long queueItemId, String queueProjectName) {
        this.setQueued(queueItemId);
        this.queueItemProject = queueProjectName;
    }

    private void validateQueuingTimeout() {
        long now;
        if (this.queuingStarted > 0L && (now = System.currentTimeMillis() / 1000L) - this.queuingStarted > 60L) {
            this.unqueue();
        }
    }

    @DataBoundSetter
    public void setReservedBy(String userName) {
        this.reservedBy = Util.fixEmptyAndTrim((String)userName);
    }

    public void setStolen() {
        this.stolen = true;
    }

    @Exported
    public boolean isStolen() {
        return this.stolen;
    }

    public void reserve(String userName) {
        this.setReservedBy(userName);
        this.setReservedTimestamp(new Date());
    }

    public void unReserve() {
        this.setReservedBy(null);
        this.setReservedTimestamp(null);
        this.stolen = false;
    }

    public void reset() {
        this.unReserve();
        this.unqueue();
        this.setBuild(null);
    }

    public void copyUnconfigurableProperties(LockableResource sourceResource) {
        if (sourceResource != null) {
            this.setReservedTimestamp(sourceResource.getReservedTimestamp());
            this.setNote(sourceResource.getNote());
        }
    }

    public void recycle() {
        try {
            ArrayList<LockableResource> resources = new ArrayList<LockableResource>();
            resources.add(this);
            LockableResourcesManager.get().recycle(resources);
        }
        catch (Exception e) {
            this.reset();
        }
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockableResource other = (LockableResource)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<LockableResource> {
        @NonNull
        public String getDisplayName() {
            return Messages.LockableResource_displayName();
        }
    }
}

