/**
 * <!-- START SNIPPET ajaxValidation -->
 *
 * Common code to interface with the WebWork's ajax validation. The following
 * method is expected to be implemented by client to handle validation error
 * suited to their needs
 *
 * eg.
 * <pre>
 *     var validationClientInstance = new ValidationClient(...);
 *  
 *  / * 
 *    *  @param inputElement - the form object that triggered the validate call
 *	   *  @param errors - a javascript object representing the action errors and field errors
 *	   *                             client should overwrite this handler to display the new error messages
 *    * /
 *     validationClientInstance.onErrors = function(inputElement, errors) { 
 *        .....
 *     }
 * </pre>    
 *
 */
function ValidationClient(servletUrl) {

	this.servletUrl = servletUrl;

	this.validate = function(input, namespace, actionName) {
		var vc = this;
		var form = input.form;
		var params = new Object();
	    for (var i = 0; i < form.elements.length; i++) {
	        var e = form.elements[i];
            if (e.name != null && e.name != '') {
                params[e.name] = e.value;
            }
        }
            validator.doPost(namespace, actionName, params, {
                callback: function(action) {
                            if (action) {
                                vc.onErrors(input, action);
                            }
                          },
                timeout: 10000,
                errorHandler: function(message) {
                    alert('Error '+message);
                }
           });
    }
    
	return this;
}

/*
 * <!-- END SNIPPET ajaxValidation -->
 */
