/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.pico;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.dispatcher.FilterDispatcher;
import com.opensymphony.webwork.pico.PicoObjectFactory;
import com.opensymphony.xwork.ObjectFactory;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.nanocontainer.nanowar.ServletRequestContainerLauncher;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.gems.adapters.ThreadLocalReference;

public class PicoFilterDispatcher
extends FilterDispatcher {
    private ObjectReference objectReference;

    public void init(FilterConfig config) throws ServletException {
        this.objectReference = new ThreadLocalReference();
        ObjectFactory.setObjectFactory((ObjectFactory)new PicoObjectFactory(this.objectReference));
        super.init(this.filterConfig);
    }

    protected Object beforeActionInvocation(HttpServletRequest request, ServletContext servletContext) {
        this.objectReference.set((Object)request);
        ServletRequestContainerLauncher containerLauncher = new ServletRequestContainerLauncher(servletContext, request);
        try {
            containerLauncher.startContainer();
        }
        catch (ServletException e) {
            throw new WebWorkException("Could not start pico container", e);
        }
        return containerLauncher;
    }

    protected void afterActionInvocation(HttpServletRequest request, Object o, Object o1) {
        ServletRequestContainerLauncher containerLauncher = (ServletRequestContainerLauncher)o;
        containerLauncher.killContainer();
        this.objectReference.set(null);
    }
}

