/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.components.Param;
import com.opensymphony.webwork.util.MakeIterator;
import com.opensymphony.webwork.util.MergeIteratorFilter;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MergeIterator
extends Component
implements Param.UnnamedParametric {
    private static final Log _log = LogFactory.getLog((Class)MergeIterator.class);
    private MergeIteratorFilter mergeIteratorFilter = null;
    private List _parameters;

    public MergeIterator(OgnlValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        this.mergeIteratorFilter = new MergeIteratorFilter();
        this._parameters = new ArrayList();
        return super.start(writer);
    }

    public boolean end(Writer writer, String body) {
        Iterator parametersIterator = this._parameters.iterator();
        while (parametersIterator.hasNext()) {
            Object iteratorEntryObj = parametersIterator.next();
            if (!MakeIterator.isIterable(iteratorEntryObj)) {
                _log.warn((Object)("param with value resolved as " + iteratorEntryObj + " cannot be make as iterator, it will be ignored and hence will not appear in the merged iterator"));
                continue;
            }
            this.mergeIteratorFilter.setSource(MakeIterator.convert(iteratorEntryObj));
        }
        this.mergeIteratorFilter.execute();
        if (this.getId() != null && this.getId().length() > 0) {
            this.getStack().getContext().put(this.getId(), this.mergeIteratorFilter);
        }
        this.mergeIteratorFilter = null;
        return super.end(writer, body);
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void addParameter(Object value) {
        this._parameters.add(value);
    }
}

