/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Main {
    public static void main(String[] args) {
        String name;
        if (args.length == 0) {
            System.out.println("Usage:");
            System.out.println("  java -jar webwork.jar [command] (optional command args)");
            System.out.println("");
            System.out.println("Where [command] is one of the following:");
            System.out.println("  quickstart");
            System.out.println("  quickstart:xxx");
            System.out.println("  sitegraph");
            System.out.println("  sitegraph:xxx");
            System.out.println("");
            System.out.println("Execute the commands for additional usage instructions.");
            System.out.println("Note: the *:xxx commands are just shortcuts for ");
            System.out.println("      running the command on a webapp in the webapps dir.");
            System.out.println("      For example, 'quickstart:sandbox' will start QuickStart");
            System.out.println("      automatically for the webapp 'sandbox'.");
            return;
        }
        String version = System.getProperty("java.version");
        boolean jdk14 = version.indexOf("1.4") != -1;
        boolean jdk13 = version.indexOf("1.3") != -1;
        boolean jdk12 = version.indexOf("1.2") != -1;
        boolean jdk11 = version.indexOf("1.1") != -1;
        boolean jdkOk = !jdk14 && !jdk13 && !jdk12 && !jdk11;
        String javaHome = System.getProperty("java.home");
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            String prop;
            Main.findJars(new File("lib"), urls);
            File wd = new File(".");
            File[] jars = wd.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") && name.indexOf("-src.") == -1;
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                File jar = jars[i];
                urls.add(jar.toURL());
            }
            urls.add(new File(System.getProperty("webwork.classes", "build/java")).toURL());
            urls.add(new File(System.getProperty("xwork.classes", "../xwork/build/java/")).toURL());
            File tools = new File(javaHome, "lib/tools.jar");
            if (!tools.exists()) {
                tools = new File(javaHome, "../lib/tools.jar");
            }
            if (!tools.exists()) {
                tools = new File(javaHome, "../Classes/classes.jar");
            }
            if (!tools.exists()) {
                tools = new File(javaHome, "../Classes/classes.jar");
            }
            if (!tools.exists() && (prop = System.getProperty("tools")) != null) {
                tools = new File(prop);
            }
            if (!tools.exists()) {
                System.out.println("Error: Could not find tools.jar! Please do one of the following: ");
                System.out.println("");
                System.out.println("        - Use the JDK's JVM (ie: c:\\jdk1.5.0\\bin\\java)");
                System.out.println("        - Specify JAVA_HOME to point to your JDK 1.5 home");
                System.out.println("        - Specify a direct path to tools.jar via, as shown below:");
                System.out.println("");
                System.out.println("       java -Dtools=/path/to/tools.jar -jar webwork-launcher.jar ...");
                return;
            }
            urls.add(tools.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.out.println("Could not find URLs -- see stack trace.");
        }
        String command = args[0];
        String[] programArgs = new String[args.length - 1];
        System.arraycopy(args, 1, programArgs, 0, programArgs.length);
        if (command.startsWith("quickstart:")) {
            command = "quickstart";
            name = Main.checkWebAppArgs(args);
            programArgs = new String[]{"/" + name, "webapps/" + name + "/src/webapp", "webapps/" + name + "/src/java"};
        }
        if ("quickstart".equals(command)) {
            if (!jdkOk) {
                System.out.println("Sorry, but QuickStart only runs on Java 1.5.");
                System.out.println("You are running: " + version);
                System.out.println("Please try again with Java 1.5 or greater, or deploy");
                System.out.println("  as a normal J2EE webapp to use Java 1.4.");
                return;
            }
            Main.launch("com.opensymphony.webwork.quickstart.QuickStart", programArgs, urls);
            return;
        }
        if (command.startsWith("sitegraph:")) {
            command = "sitegraph";
            name = Main.checkWebAppArgs(args);
            programArgs = new String[]{"-config", "webapps/" + name + "/src/webapp/WEB-INF/classes", "-views", "webapps/" + name + "/src/webapp", "-output", "."};
        }
        if ("sitegraph".equals(command)) {
            Main.launch("com.opensymphony.webwork.sitegraph.SiteGraph", programArgs, urls);
        }
    }

    private static String checkWebAppArgs(String[] args) {
        int colon = args[0].indexOf(58);
        String name = null;
        try {
            name = args[0].substring(colon + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null || name.equals("")) {
            System.out.println("Error: you must specify the webapp you wish");
            System.out.println("       to deploy. The webapp name must be the");
            System.out.println("       name of the directory found in webapps/.");
            System.out.println("");
            System.out.println("Example: java -jar webwork.jar quickstart:sandbox");
            System.exit(1);
        }
        return name;
    }

    private static void launch(String program, String[] programArgs, List urls) {
        Collections.reverse(urls);
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        MainClassLoader cl = new MainClassLoader(urlArray);
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Class<?> clazz = cl.loadClass(program);
            Method main = clazz.getDeclaredMethod("main", String;.class);
            main.invoke(null, new Object[]{programArgs});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void findJars(File file, ArrayList urls) throws MalformedURLException {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                Main.findJars(f, urls);
                continue;
            }
            if (!f.getName().endsWith(".jar") || !Main.isValid(f.getName())) continue;
            urls.add(f.toURL());
        }
    }

    private static boolean isValid(String name) {
        return !"dom.jar".equals(name);
    }

    public static class MainClassLoader
    extends URLClassLoader {
        public MainClassLoader(URL[] urls) {
            super(urls);
        }

        public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("org.xml.") || name.startsWith("org.w3c.") || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("com.sun.")) {
                return super.loadClass(name, resolve);
            }
            ClassLoader parent = this.getParent();
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (Throwable t) {
                    c = parent.loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }
}

