/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.client;

import com.opensymphony.webwork.dispatcher.client.ClientException;
import java.util.Date;
import java.util.Properties;

public class ProgressNotification {
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_SENDING = 2;
    public static final int STATUS_PROCESSING = 3;
    public static final int STATUS_RECEIVING = 4;
    public static final int STATUS_RECEIVED = 5;
    public static final int STATUS_RETRY_DELAY = 6;
    public static final int STATUS_NONE = 10;
    public static final int SECURITY_NONE = 1;
    public static final int SECURITY_ENCRYPTED = 2;
    public static final int SECURITY_IDENTIFIED = 3;
    private Date execution;
    private Properties factoryInformation = new Properties();
    private Properties securityInformation = new Properties();
    private String id;
    private int inputReceived;
    private int inputSize;
    private int outputSize;
    private int outputTransmitted;
    private int security;
    private int status;

    public ProgressNotification(String id) throws ClientException {
        if (id == null) {
            throw new ClientException("ID invalid");
        }
        this.id = id;
        this.execution = new Date();
        this.setStatus(10);
        this.setSecurity(1);
    }

    public Date getExecution() {
        return this.execution;
    }

    public void setFactoryInformation(Properties factoryInformation) throws ClientException {
        if (factoryInformation == null) {
            throw new ClientException("Invalid factory information");
        }
        this.factoryInformation = factoryInformation;
    }

    public Properties getFactoryInformation() {
        return this.factoryInformation;
    }

    public String getId() {
        return this.id;
    }

    public void setInputReceived(int inputReceived) {
        this.inputReceived = inputReceived > this.inputSize ? this.inputSize : inputReceived;
    }

    public int getInputReceived() {
        return this.inputReceived;
    }

    public void setInputSize(int inputSize) {
        this.inputSize = inputSize;
        this.inputReceived = 0;
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public void setOutputSize(int outputSize) {
        this.outputTransmitted = 0;
        this.outputSize = outputSize;
    }

    public int getOutputSize() {
        return this.outputSize;
    }

    public void setOutputTransmitted(int outputTransmitted) {
        this.outputTransmitted = outputTransmitted > this.outputSize ? this.outputSize : outputTransmitted;
    }

    public int getOutputTransmitted() {
        return this.outputTransmitted;
    }

    public void setSecurity(int security) throws ClientException {
        if (security != 1 && security != 2 && security != 3) {
            throw new ClientException("Invalid security");
        }
        this.security = security;
    }

    public int getSecurity() {
        return this.security;
    }

    public void setSecurityInformation(Properties securityInformation) throws ClientException {
        if (securityInformation == null) {
            throw new ClientException("Invalid security information");
        }
        this.securityInformation = securityInformation;
    }

    public Properties getSecurityInformation() {
        return this.securityInformation;
    }

    public void setStatus(int status) throws ClientException {
        if (status != 2 && status != 1 && status != 5 && status != 3 && status != 4 && status != 6 && status != 10) {
            throw new ClientException("Invalid status");
        }
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }
}

