/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RequestMap
extends AbstractMap
implements Serializable {
    Set entries;
    private HttpServletRequest request;

    public RequestMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        Enumeration keys = this.request.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.request.removeAttribute(key);
        }
    }

    @Override
    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new HashSet();
            Enumeration enumeration = this.request.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                final String key = enumeration.nextElement().toString();
                final Object value = this.request.getAttribute(key);
                this.entries.add(new Map.Entry(){

                    @Override
                    public boolean equals(Object obj) {
                        Map.Entry entry = (Map.Entry)obj;
                        return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    @Override
                    public int hashCode() {
                        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey() {
                        return key;
                    }

                    public Object getValue() {
                        return value;
                    }

                    public Object setValue(Object obj) {
                        RequestMap.this.request.setAttribute(key.toString(), obj);
                        return value;
                    }
                });
            }
        }
        return this.entries;
    }

    @Override
    public Object get(Object key) {
        return this.request.getAttribute(key.toString());
    }

    @Override
    public Object put(Object key, Object value) {
        this.entries = null;
        this.request.setAttribute(key.toString(), value);
        return this.get(key);
    }

    @Override
    public Object remove(Object key) {
        this.entries = null;
        Object value = this.get(key);
        this.request.removeAttribute(key.toString());
        return value;
    }
}

