/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import one.microstream.X;
import one.microstream.storage.restadapter.exceptions.StorageRestAdapterException;
import one.microstream.storage.restadapter.types.EmbeddedStorageRestAdapter;
import one.microstream.storage.restadapter.types.ObjectDescription;
import one.microstream.storage.restadapter.types.StorageRestAdapterObject;
import one.microstream.storage.restadapter.types.StorageRestAdapterRoot;
import one.microstream.storage.restadapter.types.StorageRestAdapterStorageInfo;
import one.microstream.storage.restadapter.types.StorageRestAdapterTypeDictionary;
import one.microstream.storage.restadapter.types.StorageViewDataConverter;
import one.microstream.storage.restadapter.types.StorageViewDataConverterRegistry;
import one.microstream.storage.restadapter.types.ViewerObjectDescription;
import one.microstream.storage.restadapter.types.ViewerObjectDescriptionCreator;
import one.microstream.storage.restadapter.types.ViewerRootDescription;
import one.microstream.storage.restadapter.types.ViewerStorageFileStatistics;
import one.microstream.storage.types.StorageManager;

public interface StorageRestAdapter
extends StorageRestAdapterTypeDictionary,
StorageRestAdapterObject,
StorageRestAdapterRoot,
StorageRestAdapterStorageInfo,
StorageViewDataConverterRegistry {
    public static StorageRestAdapter New(StorageManager storage) {
        return new Default(StorageViewDataConverterRegistry.New(), EmbeddedStorageRestAdapter.New(storage));
    }

    public static StorageRestAdapter New(StorageViewDataConverterRegistry converterRegistry, EmbeddedStorageRestAdapter embeddedStorageRestAdapter) {
        return new Default((StorageViewDataConverterRegistry)X.notNull((Object)converterRegistry), (EmbeddedStorageRestAdapter)X.notNull((Object)embeddedStorageRestAdapter));
    }

    public static class Default
    implements StorageRestAdapter {
        private final StorageViewDataConverterRegistry converterRegistry;
        private final EmbeddedStorageRestAdapter embeddedStorageRestAdapter;
        private long defaultValueLength = Long.MAX_VALUE;

        Default(StorageViewDataConverterRegistry converterRegistry, EmbeddedStorageRestAdapter embeddedStorageRestAdapter) {
            this.converterRegistry = converterRegistry;
            this.embeddedStorageRestAdapter = embeddedStorageRestAdapter;
        }

        @Override
        public ViewerObjectDescription getObject(long objectId, long fixedOffset, long fixedLength, long variableOffset, long variableLength, long valueLength, boolean resolveReferences) {
            if (fixedOffset < 0L) {
                throw new StorageRestAdapterException("invalid parameter fixedOffset");
            }
            if (fixedLength < 0L) {
                throw new StorageRestAdapterException("invalid parameter fixedLength");
            }
            if (variableOffset < 0L) {
                throw new StorageRestAdapterException("invalid parameter variableOffset");
            }
            if (variableLength < 0L) {
                throw new StorageRestAdapterException("invalid parameter variableLength");
            }
            if (valueLength < 0L) {
                throw new StorageRestAdapterException("invalid parameter valueLength");
            }
            ObjectDescription description = this.embeddedStorageRestAdapter.getStorageObject(objectId);
            if (resolveReferences) {
                description.resolveReferences(fixedOffset, fixedLength, variableOffset, variableLength, this.embeddedStorageRestAdapter);
            }
            return new ViewerObjectDescriptionCreator(description, fixedOffset, fixedLength, variableOffset, variableLength, valueLength).create();
        }

        @Override
        public ViewerRootDescription getUserRoot() {
            return this.embeddedStorageRestAdapter.getRoot();
        }

        @Override
        public String getTypeDictionary() {
            return this.embeddedStorageRestAdapter.getTypeDictionary();
        }

        @Override
        public long getDefaultValueLength() {
            return this.defaultValueLength;
        }

        @Override
        public void setDefaultValueLength(long defaultValueLength) {
            this.defaultValueLength = defaultValueLength;
        }

        @Override
        public ViewerStorageFileStatistics getStorageFilesStatistics() {
            return ViewerStorageFileStatistics.New(this.embeddedStorageRestAdapter.getFileStatistics());
        }

        @Override
        public StorageViewDataConverter getConverter(String format) {
            return this.converterRegistry.getConverter(format);
        }

        @Override
        public boolean addConverter(StorageViewDataConverter converter, String format) {
            return this.converterRegistry.addConverter(converter, format);
        }
    }
}

