/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import java.nio.ByteOrder;
import java.util.function.Consumer;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryChannelCountProvider;
import one.microstream.persistence.binary.types.BinaryLoader;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceContextDispatcher;
import one.microstream.persistence.types.PersistenceLoader;
import one.microstream.persistence.types.PersistenceLocalObjectIdRegistry;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.persistence.types.PersistenceObjectIdRequestor;
import one.microstream.persistence.types.PersistenceObjectRegistry;
import one.microstream.persistence.types.PersistenceRegisterer;
import one.microstream.persistence.types.PersistenceRetrieving;
import one.microstream.persistence.types.PersistenceSource;
import one.microstream.persistence.types.PersistenceStorer;
import one.microstream.persistence.types.PersistenceTarget;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerLookup;
import one.microstream.persistence.types.Persister;
import one.microstream.storage.restadapter.types.ObjectDescription;
import one.microstream.storage.restadapter.types.ViewerBinaryTypeHandlerManager;
import one.microstream.storage.restadapter.types.ViewerObjectRegistryDisabled;
import one.microstream.storage.types.StorageManager;

public interface ViewerBinaryPersistenceManager
extends PersistenceManager<Binary> {
    public ObjectDescription getStorageObject(long var1);

    public ObjectDescription getStorageConstant(long var1);

    public static ViewerBinaryPersistenceManager New(StorageManager storage) {
        PersistenceManager persistenceManager = storage.persistenceManager();
        ViewerObjectRegistryDisabled objectRegistry = new ViewerObjectRegistryDisabled();
        PersistenceObjectRegistry constantRegistry = Persistence.registerJavaConstants((PersistenceObjectRegistry)PersistenceObjectRegistry.New());
        BinaryLoader.CreatorChannelHashing loaderCreator = new BinaryLoader.CreatorChannelHashing((BinaryChannelCountProvider)storage.configuration().channelCountProvider(), persistenceManager.isByteOrderMismatch());
        PersistenceContextDispatcher.PassThrough contextDispatcher = PersistenceContextDispatcher.PassThrough();
        ViewerBinaryTypeHandlerManager typeHandlerManager = new ViewerBinaryTypeHandlerManager((PersistenceManager<Binary>)persistenceManager);
        return new Default((PersistenceManager<Binary>)persistenceManager, objectRegistry, (PersistenceLoader.Creator<Binary>)loaderCreator, (PersistenceContextDispatcher<Binary>)contextDispatcher, typeHandlerManager, constantRegistry);
    }

    public static class Default
    implements ViewerBinaryPersistenceManager {
        private final PersistenceManager<Binary> persistenceManager;
        private final PersistenceObjectRegistry objectRegistry;
        private final PersistenceLoader.Creator<Binary> loaderCreator;
        private final PersistenceContextDispatcher<Binary> contextDispatcher;
        private final ViewerBinaryTypeHandlerManager typeHandlerManager;
        private final PersistenceObjectRegistry constantRegistry;

        public Default(PersistenceManager<Binary> persistenceManager, PersistenceObjectRegistry objectRegistry, PersistenceLoader.Creator<Binary> loaderCreator, PersistenceContextDispatcher<Binary> contextDispatcher, ViewerBinaryTypeHandlerManager typeHandlerManager, PersistenceObjectRegistry constantRegistry) {
            this.persistenceManager = persistenceManager;
            this.objectRegistry = objectRegistry;
            this.loaderCreator = loaderCreator;
            this.contextDispatcher = contextDispatcher;
            this.typeHandlerManager = typeHandlerManager;
            this.constantRegistry = constantRegistry;
        }

        public final long ensureObjectId(Object object) {
            return this.persistenceManager.ensureObjectId(object);
        }

        public final <T> long ensureObjectId(T object, PersistenceObjectIdRequestor<Binary> objectIdRequestor, PersistenceTypeHandler<Binary, T> optionalHandler) {
            return this.persistenceManager.ensureObjectId(object, objectIdRequestor, optionalHandler);
        }

        public final <T> long ensureObjectIdGuaranteedRegister(T object, PersistenceObjectIdRequestor<Binary> objectIdRequestor, PersistenceTypeHandler<Binary, T> optionalHandler) {
            return this.persistenceManager.ensureObjectIdGuaranteedRegister(object, objectIdRequestor, optionalHandler);
        }

        public void consolidate() {
            this.persistenceManager.consolidate();
        }

        public long lookupObjectId(Object object) {
            return this.persistenceManager.lookupObjectId(object);
        }

        public Object lookupObject(long objectId) {
            return this.persistenceManager.lookupObject(objectId);
        }

        public Object get() {
            return this.persistenceManager.get();
        }

        public Object getObject(long objectId) {
            return this.persistenceManager.getObject(objectId);
        }

        public <C extends Consumer<Object>> C collect(C collector, long ... objectIds) {
            return (C)this.persistenceManager.collect(collector, objectIds);
        }

        public long store(Object instance) {
            return this.persistenceManager.store(instance);
        }

        public long[] storeAll(Object ... instances) {
            return this.persistenceManager.storeAll(instances);
        }

        public void storeAll(Iterable<?> instances) {
            this.persistenceManager.storeAll(instances);
        }

        public PersistenceRegisterer createRegisterer() {
            return this.persistenceManager.createRegisterer();
        }

        public PersistenceLoader createLoader() {
            return this.persistenceManager.createLoader();
        }

        public PersistenceStorer createLazyStorer() {
            return this.persistenceManager.createLazyStorer();
        }

        public PersistenceStorer createStorer() {
            return this.persistenceManager.createStorer();
        }

        public PersistenceStorer createEagerStorer() {
            return this.persistenceManager.createEagerStorer();
        }

        public PersistenceStorer createStorer(PersistenceStorer.Creator<Binary> storerCreator) {
            return this.persistenceManager.createStorer(storerCreator);
        }

        public void updateMetadata(PersistenceTypeDictionary typeDictionary, long highestTypeId, long highestObjectId) {
            this.persistenceManager.updateMetadata(typeDictionary, highestTypeId, highestObjectId);
        }

        public PersistenceObjectRegistry objectRegistry() {
            return this.persistenceManager.objectRegistry();
        }

        public PersistenceTypeDictionary typeDictionary() {
            return this.persistenceManager.typeDictionary();
        }

        public long currentObjectId() {
            return this.persistenceManager.currentObjectId();
        }

        public PersistenceManager<Binary> updateCurrentObjectId(long currentObjectId) {
            return this.persistenceManager.updateCurrentObjectId(currentObjectId);
        }

        public PersistenceSource<Binary> source() {
            return this.persistenceManager.source();
        }

        public PersistenceTarget<Binary> target() {
            return this.persistenceManager.target();
        }

        public void close() {
            this.persistenceManager.close();
        }

        public ByteOrder getTargetByteOrder() {
            return this.persistenceManager.getTargetByteOrder();
        }

        public boolean registerLocalRegistry(PersistenceLocalObjectIdRegistry<Binary> localRegistry) {
            return this.persistenceManager.registerLocalRegistry(localRegistry);
        }

        public void mergeEntries(PersistenceLocalObjectIdRegistry<Binary> localRegistry) {
            this.persistenceManager.mergeEntries(localRegistry);
        }

        @Override
        public ObjectDescription getStorageObject(long objectId) {
            return (ObjectDescription)this.createViewerLoader().getObject(objectId);
        }

        private PersistenceRetrieving createViewerLoader() {
            this.objectRegistry.clear();
            return this.loaderCreator.createLoader(this.contextDispatcher.dispatchTypeHandlerLookup((PersistenceTypeHandlerLookup)this.typeHandlerManager), this.contextDispatcher.dispatchObjectRegistry(this.objectRegistry), (Persister)this, this.persistenceManager);
        }

        @Override
        public ObjectDescription getStorageConstant(long objectId) {
            Object object = this.constantRegistry.lookupObject(objectId);
            PersistenceTypeDefinition type = this.typeDictionary().lookupTypeByName(object.getClass().getTypeName());
            ObjectDescription objectDescription = new ObjectDescription();
            objectDescription.setPersistenceTypeDefinition(type);
            objectDescription.setObjectId(objectId);
            objectDescription.setPrimitiveInstance(object);
            objectDescription.setLength(1L);
            return objectDescription;
        }
    }
}

