/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import one.microstream.storage.restadapter.types.ObjectDescription;
import one.microstream.storage.restadapter.types.ObjectReferenceWrapper;
import one.microstream.storage.restadapter.types.ViewerObjectDescription;

public class ViewerObjectDescriptionCreator {
    private final ObjectDescription description;
    private final int fixedOffset;
    private final int fixedLength;
    private final int variableOffset;
    private final int variableLength;
    private final int valueLength;
    private ViewerObjectDescription objDesc;

    public ViewerObjectDescriptionCreator(ObjectDescription description, long fixedOffset, long fixedLength, long variableOffset, long variableLength, long valueLength) {
        this.description = description;
        this.fixedOffset = (int)Math.min(Integer.MAX_VALUE, fixedOffset);
        this.fixedLength = (int)Math.min(Integer.MAX_VALUE, fixedLength);
        this.variableOffset = (int)Math.min(Integer.MAX_VALUE, variableOffset);
        this.variableLength = (int)Math.min(Integer.MAX_VALUE, variableLength);
        this.valueLength = (int)Math.min(Integer.MAX_VALUE, valueLength);
    }

    public ViewerObjectDescription create() {
        this.objDesc = new ViewerObjectDescription();
        this.setObjectHeader();
        this.gatherMemberValues();
        this.setReferences();
        return this.objDesc;
    }

    private void gatherMemberValues() {
        if (this.description.hasPrimitiveObjectInstance()) {
            ViewerObjectDescriptionCreator.setPrimitiveValue(this.description, this.objDesc, this.valueLength);
        } else {
            Object[] members = this.description.getValues();
            ArrayList<Object> data = new ArrayList<Object>();
            this.appendFixedSizeValues(members, data);
            this.appendVariableSizeValues(members, data);
            this.objDesc.setData(data.toArray());
        }
    }

    private void appendFixedSizeValues(Object[] members, List<Object> data) {
        int upperLimit = ViewerObjectDescriptionCreator.getClampedArrayIndex(this.description.getLength(), this.fixedOffset, this.fixedLength);
        int i = this.fixedOffset;
        while (i < upperLimit) {
            Object member = members[i];
            if (member instanceof ObjectReferenceWrapper) {
                data.add(Long.toString(((ObjectReferenceWrapper)member).getObjectId()));
            } else {
                data.add(ViewerObjectDescriptionCreator.limitsPrimitiveType(member.toString(), this.valueLength));
            }
            ++i;
        }
    }

    private void appendVariableSizeValues(Object[] members, List<Object> data) {
        if (this.description.getVariableLength() != null) {
            int i = 0;
            while (i < this.description.getVariableLength().length) {
                Object member = members[(int)((long)i + this.description.getLength())];
                if (member.getClass().isArray()) {
                    data.add(this.variableLengthValues((Object[])member));
                }
                ++i;
            }
        }
    }

    private Object[] variableLengthValues(Object[] values) {
        int upperLimit = ViewerObjectDescriptionCreator.getClampedArrayIndex(values.length, this.variableOffset, this.variableLength);
        return this.traverseValues(values, this.variableOffset, upperLimit);
    }

    private Object[] traverseValues(Object[] values, int startIndex, int endIndex) {
        ArrayList<Object> data = new ArrayList<Object>();
        int i = startIndex;
        while (i < endIndex) {
            Object value = values[i];
            if (value instanceof ObjectReferenceWrapper) {
                data.add(Long.toString(((ObjectReferenceWrapper)value).getObjectId()));
            } else if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                data.add(this.traverseValues(array, 0, array.length));
            } else {
                data.add(ViewerObjectDescriptionCreator.limitsPrimitiveType(value.toString(), this.valueLength));
            }
            ++i;
        }
        return data.toArray();
    }

    private void setObjectHeader() {
        this.objDesc.setObjectId(Long.toString(this.description.getObjectId()));
        this.objDesc.setTypeId(Long.toString(this.description.getPersistenceTypeDefinition().typeId()));
        this.objDesc.setLength(Long.toString(this.description.getLength()));
        if (this.description.getVariableLength() != null) {
            this.objDesc.setVariableLength((String[])Arrays.stream(this.description.getVariableLength()).map(l -> l.toString()).toArray(String[]::new));
        }
    }

    private void setReferences() {
        ObjectDescription[] references = this.description.getReferences();
        if (references != null) {
            ArrayList<ViewerObjectDescription> referencesList = new ArrayList<ViewerObjectDescription>(references.length);
            ObjectDescription[] objectDescriptionArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectDescription desc = objectDescriptionArray[n2];
                if (desc != null) {
                    ViewerObjectDescriptionCreator descriptionCreator = new ViewerObjectDescriptionCreator(desc, this.fixedOffset, this.fixedLength, this.variableOffset, this.variableLength, this.valueLength);
                    referencesList.add(descriptionCreator.create());
                } else {
                    referencesList.add(null);
                }
                ++n2;
            }
            this.objDesc.setReferences(referencesList.toArray(new ViewerObjectDescription[0]));
        }
    }

    private static void setPrimitiveValue(ObjectDescription description, ViewerObjectDescription objDesc, long valueLength) {
        String stringValue = description.getPrimitiveInstance().toString();
        String subString = ViewerObjectDescriptionCreator.limitsPrimitiveType(stringValue, valueLength);
        objDesc.setData(new String[]{subString});
        objDesc.setLength("1");
        objDesc.setVariableLength(new String[]{"0"});
        objDesc.setSimplified(true);
    }

    private static int getClampedArrayIndex(long arrayLength, long startIndex, long count) {
        long realLength = Math.max(Math.min(arrayLength - startIndex, count), 0L);
        return (int)Math.min(startIndex + realLength, Integer.MAX_VALUE);
    }

    private static String limitsPrimitiveType(String data, long valueLength) {
        int endIndex = ViewerObjectDescriptionCreator.getClampedArrayIndex(data.length(), 0L, valueLength);
        return data.substring(0, endIndex);
    }
}

