/*
 * Decompiled with CFR 0.152.
 */
package no.api.freemarker.java8.time;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import no.api.freemarker.java8.time.AbstractAdapter;
import no.api.freemarker.java8.time.AbstractChecker;
import no.api.freemarker.java8.time.AbstractFormatter;
import no.api.freemarker.java8.time.DateTimeTools;

public class LocalTimeAdapter
extends AbstractAdapter<LocalTime>
implements AdapterTemplateModel,
TemplateScalarModel,
TemplateHashModel {
    public LocalTimeAdapter(LocalTime obj) {
        super(obj);
    }

    public TemplateModel get(String s) throws TemplateModelException {
        if ("format".equals(s)) {
            return new LocalTimeFormatter((LocalTime)this.getObject());
        }
        if ("isEqual".equals(s) || "isAfter".equals(s) || "isBefore".equals(s)) {
            return new LocalTimeChecker((LocalTime)this.getObject(), s);
        }
        throw new TemplateModelException("Unknown method call: " + s);
    }

    public class LocalTimeChecker
    extends AbstractChecker<LocalTime>
    implements TemplateMethodModelEx {
        private String method;

        public LocalTimeChecker(LocalTime obj, String method) {
            super(obj);
            this.method = method;
        }

        public Object exec(List list) throws TemplateModelException {
            LocalTimeAdapter adapter = (LocalTimeAdapter)((Object)list.get(0));
            switch (this.method) {
                case "isEqual": {
                    return ((LocalTime)this.getObject()).equals(adapter.getObject());
                }
                case "isAfter": {
                    return ((LocalTime)this.getObject()).isAfter((LocalTime)adapter.getObject());
                }
                case "isBefore": {
                    return ((LocalTime)this.getObject()).isBefore((LocalTime)adapter.getObject());
                }
            }
            throw new TemplateModelException("method not implemented");
        }
    }

    public class LocalTimeFormatter
    extends AbstractFormatter<LocalTime>
    implements TemplateMethodModelEx {
        public LocalTimeFormatter(LocalTime obj) {
            super(obj);
        }

        public Object exec(List list) throws TemplateModelException {
            return ((LocalTime)this.getObject()).format(DateTimeTools.createDateTimeFormatter(list, 0, DateTimeFormatter.ISO_LOCAL_TIME));
        }
    }
}

