/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti.emitters;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.dionsegijn.konfetti.Confetti;
import nl.dionsegijn.konfetti.emitters.Emitter;
import nl.dionsegijn.konfetti.emitters.RenderSystem;
import nl.dionsegijn.konfetti.models.ConfettiConfig;
import nl.dionsegijn.konfetti.models.Shape;
import nl.dionsegijn.konfetti.models.Size;
import nl.dionsegijn.konfetti.models.Vector;
import nl.dionsegijn.konfetti.modules.LocationModule;
import nl.dionsegijn.konfetti.modules.VelocityModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\fH\u0002J\u0006\u0010*\u001a\u00020\u0019J\u0016\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnl/dionsegijn/konfetti/emitters/RenderSystem;", "", "location", "Lnl/dionsegijn/konfetti/modules/LocationModule;", "velocity", "Lnl/dionsegijn/konfetti/modules/VelocityModule;", "gravity", "Lnl/dionsegijn/konfetti/models/Vector;", "sizes", "", "Lnl/dionsegijn/konfetti/models/Size;", "shapes", "Lnl/dionsegijn/konfetti/models/Shape;", "colors", "", "config", "Lnl/dionsegijn/konfetti/models/ConfettiConfig;", "emitter", "Lnl/dionsegijn/konfetti/emitters/Emitter;", "createdAt", "", "(Lnl/dionsegijn/konfetti/modules/LocationModule;Lnl/dionsegijn/konfetti/modules/VelocityModule;Lnl/dionsegijn/konfetti/models/Vector;[Lnl/dionsegijn/konfetti/models/Size;[Lnl/dionsegijn/konfetti/models/Shape;[ILnl/dionsegijn/konfetti/models/ConfettiConfig;Lnl/dionsegijn/konfetti/emitters/Emitter;J)V", "getCreatedAt", "()J", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "particles", "", "Lnl/dionsegijn/konfetti/Confetti;", "random", "Ljava/util/Random;", "[Lnl/dionsegijn/konfetti/models/Shape;", "[Lnl/dionsegijn/konfetti/models/Size;", "addConfetti", "", "getActiveParticles", "", "getRandomShape", "isDoneEmitting", "render", "canvas", "Landroid/graphics/Canvas;", "deltaTime", "", "konfetti_release"})
public final class RenderSystem {
    private boolean enabled;
    private final Random random;
    private final List<Confetti> particles;
    private final LocationModule location;
    private final VelocityModule velocity;
    private final Vector gravity;
    private final Size[] sizes;
    private final Shape[] shapes;
    private final int[] colors;
    private final ConfettiConfig config;
    private final Emitter emitter;
    private final long createdAt;

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private final void addConfetti() {
        float f = this.velocity.getRotationSpeedMultiplier();
        boolean bl = this.config.getAccelerate();
        float f2 = this.velocity.getMaxAcceleration();
        boolean bl2 = this.config.getRotate();
        Vector vector = this.velocity.getVelocity();
        Vector vector2 = null;
        boolean bl3 = this.config.getFadeOut();
        long l = this.config.getTimeToLive();
        int n = this.colors[this.random.nextInt(this.colors.length)];
        Shape shape = this.getRandomShape();
        Size size = this.sizes[this.random.nextInt(this.sizes.length)];
        this.particles.add(new Confetti(new Vector(this.location.getX(), this.location.getY()), n, size, shape, l, bl3, vector2, vector, bl2, bl, f2, f, 64, null));
    }

    /*
     * WARNING - void declaration
     */
    private final Shape getRandomShape() {
        Shape shape;
        Shape shape2 = this.shapes[this.random.nextInt(this.shapes.length)];
        if (shape2 instanceof Shape.DrawableShape) {
            Drawable.ConstantState constantState = ((Shape.DrawableShape)shape2).getDrawable().getConstantState();
            if (constantState == null || (constantState = constantState.newDrawable()) == null || (constantState = constantState.mutate()) == null) {
                constantState = ((Shape.DrawableShape)shape2).getDrawable();
            }
            Intrinsics.checkNotNullExpressionValue((Object)constantState, (String)"shape.drawable.constantS\u2026utate() ?: shape.drawable");
            Drawable.ConstantState mutatedState = constantState;
            shape = Shape.DrawableShape.copy$default((Shape.DrawableShape)shape2, (Drawable)mutatedState, false, 2, null);
        } else {
            void var1_1;
            shape = var1_1;
        }
        return shape;
    }

    /*
     * WARNING - void declaration
     */
    public final void render(@NotNull Canvas canvas, float deltaTime) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.enabled) {
            this.emitter.createConfetti(deltaTime);
        }
        int n = this.particles.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            Confetti particle = this.particles.get((int)i);
            particle.applyForce(this.gravity);
            particle.render(canvas, deltaTime);
            --i;
        }
        CollectionsKt.removeAll(this.particles, (Function1)render.1.INSTANCE);
    }

    public final int getActiveParticles() {
        return this.particles.size();
    }

    public final boolean isDoneEmitting() {
        return this.emitter.isFinished() && this.particles.size() == 0 || !this.enabled && this.particles.size() == 0;
    }

    public final long getCreatedAt() {
        return this.createdAt;
    }

    public RenderSystem(@NotNull LocationModule location, @NotNull VelocityModule velocity, @NotNull Vector gravity, @NotNull Size[] sizes, @NotNull Shape[] shapes, @NotNull int[] colors, @NotNull ConfettiConfig config, @NotNull Emitter emitter, long createdAt) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        Intrinsics.checkNotNullParameter((Object)gravity, (String)"gravity");
        Intrinsics.checkNotNullParameter((Object)sizes, (String)"sizes");
        Intrinsics.checkNotNullParameter((Object)shapes, (String)"shapes");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        this.location = location;
        this.velocity = velocity;
        this.gravity = gravity;
        this.sizes = sizes;
        this.shapes = shapes;
        this.colors = colors;
        this.config = config;
        this.emitter = emitter;
        this.createdAt = createdAt;
        this.enabled = true;
        this.random = new Random();
        boolean bl = false;
        this.particles = new ArrayList();
        this.emitter.setAddConfettiFunc((Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((RenderSystem)this.receiver).addConfetti();
            }
        }));
    }

    public /* synthetic */ RenderSystem(LocationModule locationModule, VelocityModule velocityModule, Vector vector, Size[] sizeArray, Shape[] shapeArray, int[] nArray, ConfettiConfig confettiConfig, Emitter emitter, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            l = System.currentTimeMillis();
        }
        this(locationModule, velocityModule, vector, sizeArray, shapeArray, nArray, confettiConfig, emitter, l);
    }
}

