/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import nl.dionsegijn.konfetti.KonfettiView;
import nl.dionsegijn.konfetti.emitters.BurstEmitter;
import nl.dionsegijn.konfetti.emitters.Emitter;
import nl.dionsegijn.konfetti.emitters.RenderSystem;
import nl.dionsegijn.konfetti.emitters.StreamEmitter;
import nl.dionsegijn.konfetti.models.ConfettiConfig;
import nl.dionsegijn.konfetti.models.Shape;
import nl.dionsegijn.konfetti.models.Size;
import nl.dionsegijn.konfetti.models.Vector;
import nl.dionsegijn.konfetti.modules.LocationModule;
import nl.dionsegijn.konfetti.modules.VelocityModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u001e\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u00020\u00002\n\u0010\u0005\u001a\u00020\u0006\"\u00020\u001fJ\u0014\u0010 \u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u001f0!J\u001f\u0010\"\u001a\u00020\u00002\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010#J\u001f\u0010$\u001a\u00020\u00002\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0016\"\u00020\u001a\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001fJ\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020(2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020+J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020/J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\u0016\u00104\u001a\u00020\u00002\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u000206J\u000e\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020+J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020=J\u0016\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020=2\u0006\u0010<\u001a\u00020=J3\u0010@\u001a\u00020\u00002\u0006\u0010B\u001a\u00020=2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010=2\u0006\u0010D\u001a\u00020=2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010=\u00a2\u0006\u0002\u0010FJ\u000e\u0010G\u001a\u00020\u00002\u0006\u00101\u001a\u00020+J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020=J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020=J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020=J\u0016\u0010L\u001a\u00020\u00002\u0006\u0010N\u001a\u00020=2\u0006\u0010O\u001a\u00020=J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020/J\b\u0010R\u001a\u00020(H\u0002J\u0010\u0010S\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010T\u001a\u00020(J\u0018\u0010U\u001a\u00020(2\u0006\u0010V\u001a\u00020\u001f2\u0006\u0010W\u001a\u00020\u001fH\u0007J\u0018\u0010U\u001a\u00020(2\u0006\u0010V\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020/H\u0007J\u0016\u0010Y\u001a\u00020(2\u0006\u0010V\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020/J\u0016\u0010Z\u001a\u00020(2\u0006\u0010V\u001a\u00020\u001f2\u0006\u0010W\u001a\u00020\u001fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lnl/dionsegijn/konfetti/ParticleSystem;", "", "konfettiView", "Lnl/dionsegijn/konfetti/KonfettiView;", "(Lnl/dionsegijn/konfetti/KonfettiView;)V", "colors", "", "confettiConfig", "Lnl/dionsegijn/konfetti/models/ConfettiConfig;", "gravity", "Lnl/dionsegijn/konfetti/models/Vector;", "location", "Lnl/dionsegijn/konfetti/modules/LocationModule;", "random", "Ljava/util/Random;", "renderSystem", "Lnl/dionsegijn/konfetti/emitters/RenderSystem;", "getRenderSystem$konfetti_release", "()Lnl/dionsegijn/konfetti/emitters/RenderSystem;", "setRenderSystem$konfetti_release", "(Lnl/dionsegijn/konfetti/emitters/RenderSystem;)V", "shapes", "", "Lnl/dionsegijn/konfetti/models/Shape;", "[Lnl/dionsegijn/konfetti/models/Shape;", "sizes", "Lnl/dionsegijn/konfetti/models/Size;", "[Lnl/dionsegijn/konfetti/models/Size;", "velocity", "Lnl/dionsegijn/konfetti/modules/VelocityModule;", "activeParticles", "", "addColors", "", "addShapes", "([Lnl/dionsegijn/konfetti/models/Shape;)Lnl/dionsegijn/konfetti/ParticleSystem;", "addSizes", "possibleSizes", "([Lnl/dionsegijn/konfetti/models/Size;)Lnl/dionsegijn/konfetti/ParticleSystem;", "burst", "", "amount", "doneEmitting", "", "emitter", "Lnl/dionsegijn/konfetti/emitters/Emitter;", "getDelay", "", "setAccelerationEnabled", "enabled", "setDelay", "delay", "setDirection", "degrees", "", "minDegrees", "maxDegrees", "setFadeOutEnabled", "fade", "setGravity", "y", "", "setMaxAcceleration", "maxAcceleration", "setPosition", "x", "minX", "maxX", "minY", "maxY", "(FLjava/lang/Float;FLjava/lang/Float;)Lnl/dionsegijn/konfetti/ParticleSystem;", "setRotationEnabled", "setRotationSpeedMultiplier", "multiplier", "setRotationSpeedVariance", "variance", "setSpeed", "speed", "minSpeed", "maxSpeed", "setTimeToLive", "timeInMs", "start", "startRenderSystem", "stop", "stream", "particlesPerSecond", "maxParticles", "emittingTime", "streamFor", "streamMaxParticles", "konfetti_release"})
public final class ParticleSystem {
    private final Random random;
    private LocationModule location;
    private VelocityModule velocity;
    private int[] colors;
    private Size[] sizes;
    private Shape[] shapes;
    private ConfettiConfig confettiConfig;
    private Vector gravity;
    public RenderSystem renderSystem;
    private final KonfettiView konfettiView;

    public final long getDelay() {
        return this.confettiConfig.getDelay();
    }

    @NotNull
    public final RenderSystem getRenderSystem$konfetti_release() {
        RenderSystem renderSystem = this.renderSystem;
        if (renderSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderSystem");
        }
        return renderSystem;
    }

    public final void setRenderSystem$konfetti_release(@NotNull RenderSystem renderSystem) {
        Intrinsics.checkNotNullParameter((Object)renderSystem, (String)"<set-?>");
        this.renderSystem = renderSystem;
    }

    @NotNull
    public final ParticleSystem setPosition(float x, float y) {
        this.location.setX(x);
        this.location.setY(y);
        return this;
    }

    @NotNull
    public final ParticleSystem setPosition(float minX, @Nullable Float maxX, float minY, @Nullable Float maxY) {
        this.location.betweenX(minX, maxX);
        this.location.betweenY(minY, maxY);
        return this;
    }

    public static /* synthetic */ ParticleSystem setPosition$default(ParticleSystem particleSystem, float f, Float f2, float f3, Float f4, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = null;
        }
        if ((n & 8) != 0) {
            f4 = null;
        }
        return particleSystem.setPosition(f, f2, f3, f4);
    }

    @NotNull
    public final ParticleSystem addColors(int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.colors = colors;
        return this;
    }

    @NotNull
    public final ParticleSystem addColors(@NotNull List<Integer> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.colors = CollectionsKt.toIntArray((Collection)colors);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ParticleSystem addSizes(Size ... possibleSizes) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)possibleSizes, (String)"possibleSizes");
        Size[] sizeArray = possibleSizes;
        ParticleSystem particleSystem = this;
        boolean $i$f$filterIsInstance = false;
        void var4_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Size)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Size[] sizeArray2 = thisCollection$iv.toArray(new Size[0]);
        if (sizeArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        particleSystem.sizes = sizeArray2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ParticleSystem addShapes(Shape ... shapes) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)shapes, (String)"shapes");
        Shape[] shapeArray = shapes;
        ParticleSystem particleSystem = this;
        boolean $i$f$filterIsInstance = false;
        void var4_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Shape)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Shape[] shapeArray2 = thisCollection$iv.toArray(new Shape[0]);
        if (shapeArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        particleSystem.shapes = shapeArray2;
        return this;
    }

    @NotNull
    public final ParticleSystem setDirection(double degrees) {
        this.velocity.setMinAngle(Math.toRadians(degrees));
        return this;
    }

    @NotNull
    public final ParticleSystem setDirection(double minDegrees, double maxDegrees) {
        this.velocity.setMinAngle(Math.toRadians(minDegrees));
        this.velocity.setMaxAngle(Math.toRadians(maxDegrees));
        return this;
    }

    @NotNull
    public final ParticleSystem setSpeed(float speed) {
        this.velocity.setMinSpeed(speed);
        return this;
    }

    @NotNull
    public final ParticleSystem setSpeed(float minSpeed, float maxSpeed) {
        this.velocity.setMinSpeed(minSpeed);
        this.velocity.setMaxSpeed(Float.valueOf(maxSpeed));
        return this;
    }

    @NotNull
    public final ParticleSystem setMaxAcceleration(float maxAcceleration) {
        this.velocity.setMaxAcceleration(maxAcceleration / (float)10);
        return this;
    }

    @NotNull
    public final ParticleSystem setGravity(float y) {
        this.gravity.setY(RangesKt.coerceAtLeast((float)y, (float)0.01f));
        return this;
    }

    @NotNull
    public final ParticleSystem setRotationEnabled(boolean enabled) {
        this.confettiConfig.setRotate(enabled);
        return this;
    }

    @NotNull
    public final ParticleSystem setRotationSpeedMultiplier(float multiplier) {
        boolean bl = multiplier >= 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "multiplier (" + multiplier + ") must be greater or equal to 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.velocity.setBaseRotationMultiplier(multiplier);
        return this;
    }

    @NotNull
    public final ParticleSystem setRotationSpeedVariance(float variance) {
        float f = variance;
        boolean bl = f >= 0.0f && f <= 1.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "variance (" + variance + ") must be in the range 0..1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.velocity.setRotationVariance(variance);
        return this;
    }

    @NotNull
    public final ParticleSystem setAccelerationEnabled(boolean enabled) {
        this.confettiConfig.setAccelerate(enabled);
        return this;
    }

    @NotNull
    public final ParticleSystem setFadeOutEnabled(boolean fade) {
        this.confettiConfig.setFadeOut(fade);
        return this;
    }

    @NotNull
    public final ParticleSystem setDelay(long delay) {
        this.confettiConfig.setDelay(delay);
        return this;
    }

    @NotNull
    public final ParticleSystem setTimeToLive(long timeInMs) {
        this.confettiConfig.setTimeToLive(timeInMs);
        return this;
    }

    public final void burst(int amount) {
        this.startRenderSystem(new BurstEmitter().build(amount));
    }

    @Deprecated(message="Deprecated in favor of better function names", replaceWith=@ReplaceWith(imports={"nl.dionsegijn.konfetti.ParticleSystem.streamFor"}, expression="streamFor(particlesPerSecond, emittingTime)"))
    public final void stream(int particlesPerSecond, long emittingTime) {
        StreamEmitter stream = StreamEmitter.build$default(new StreamEmitter(), particlesPerSecond, emittingTime, 0, 4, null);
        this.startRenderSystem(stream);
    }

    public final void streamFor(int particlesPerSecond, long emittingTime) {
        StreamEmitter stream = StreamEmitter.build$default(new StreamEmitter(), particlesPerSecond, emittingTime, 0, 4, null);
        this.startRenderSystem(stream);
    }

    @Deprecated(message="Deprecated in favor of better function names", replaceWith=@ReplaceWith(imports={"nl.dionsegijn.konfetti.ParticleSystem.streamMaxParticles"}, expression="streamMaxParticles(particlesPerSecond, maxParticles)"))
    public final void stream(int particlesPerSecond, int maxParticles) {
        StreamEmitter stream = StreamEmitter.build$default(new StreamEmitter(), particlesPerSecond, 0L, maxParticles, 2, null);
        this.startRenderSystem(stream);
    }

    public final void streamMaxParticles(int particlesPerSecond, int maxParticles) {
        StreamEmitter stream = StreamEmitter.build$default(new StreamEmitter(), particlesPerSecond, 0L, maxParticles, 2, null);
        this.startRenderSystem(stream);
    }

    public final void emitter(@NotNull Emitter emitter) {
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        this.startRenderSystem(emitter);
    }

    private final void startRenderSystem(Emitter emitter) {
        this.renderSystem = new RenderSystem(this.location, this.velocity, this.gravity, this.sizes, this.shapes, this.colors, this.confettiConfig, emitter, 0L, 256, null);
        this.start();
    }

    public final boolean doneEmitting() {
        RenderSystem renderSystem = this.renderSystem;
        if (renderSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderSystem");
        }
        return renderSystem.isDoneEmitting();
    }

    private final void start() {
        this.konfettiView.start(this);
    }

    public final void stop() {
        this.konfettiView.stop(this);
    }

    public final int activeParticles() {
        RenderSystem renderSystem = this.renderSystem;
        if (renderSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderSystem");
        }
        return renderSystem.getActiveParticles();
    }

    public ParticleSystem(@NotNull KonfettiView konfettiView) {
        Intrinsics.checkNotNullParameter((Object)((Object)konfettiView), (String)"konfettiView");
        this.konfettiView = konfettiView;
        this.random = new Random();
        this.location = new LocationModule(this.random);
        this.velocity = new VelocityModule(this.random);
        this.colors = new int[]{-65536};
        this.sizes = new Size[]{new Size(16, 0.0f, 2, null)};
        this.shapes = new Shape[]{Shape.Square.INSTANCE};
        this.confettiConfig = new ConfettiConfig(false, 0L, false, false, 0L, 31, null);
        this.gravity = new Vector(0.0f, 0.01f);
    }
}

