/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.dionsegijn.konfetti.ParticleSystem;
import nl.dionsegijn.konfetti.listeners.OnParticleSystemUpdateListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001#B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0016\u001a\u00020\u0013J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0006\u0010\u001e\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0013J\u0006\u0010\"\u001a\u00020\u001bR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnl/dionsegijn/konfetti/KonfettiView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "onParticleSystemUpdateListener", "Lnl/dionsegijn/konfetti/listeners/OnParticleSystemUpdateListener;", "getOnParticleSystemUpdateListener", "()Lnl/dionsegijn/konfetti/listeners/OnParticleSystemUpdateListener;", "setOnParticleSystemUpdateListener", "(Lnl/dionsegijn/konfetti/listeners/OnParticleSystemUpdateListener;)V", "systems", "", "Lnl/dionsegijn/konfetti/ParticleSystem;", "timer", "Lnl/dionsegijn/konfetti/KonfettiView$TimerIntegration;", "build", "getActiveSystems", "isActive", "", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "reset", "start", "particleSystem", "stop", "stopGracefully", "TimerIntegration", "konfetti_release"})
public class KonfettiView
extends View {
    private final List<ParticleSystem> systems;
    private TimerIntegration timer;
    @Nullable
    private OnParticleSystemUpdateListener onParticleSystemUpdateListener;

    @Nullable
    public final OnParticleSystemUpdateListener getOnParticleSystemUpdateListener() {
        return this.onParticleSystemUpdateListener;
    }

    public final void setOnParticleSystemUpdateListener(@Nullable OnParticleSystemUpdateListener onParticleSystemUpdateListener) {
        this.onParticleSystemUpdateListener = onParticleSystemUpdateListener;
    }

    @NotNull
    public final List<ParticleSystem> getActiveSystems() {
        return this.systems;
    }

    public final boolean isActive() {
        Collection collection = this.systems;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public final ParticleSystem build() {
        return new ParticleSystem(this);
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        float deltaTime = this.timer.getDeltaTime();
        int n = this.systems.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            ParticleSystem particleSystem = this.systems.get((int)i);
            long totalTimeRunning = this.timer.getTotalTimeRunning(particleSystem.getRenderSystem$konfetti_release().getCreatedAt());
            if (totalTimeRunning >= particleSystem.getDelay()) {
                particleSystem.getRenderSystem$konfetti_release().render(canvas, deltaTime);
            }
            if (particleSystem.doneEmitting()) {
                this.systems.remove((int)i);
                OnParticleSystemUpdateListener onParticleSystemUpdateListener = this.onParticleSystemUpdateListener;
                if (onParticleSystemUpdateListener != null) {
                    onParticleSystemUpdateListener.onParticleSystemEnded(this, particleSystem, this.systems.size());
                }
            }
            --i;
        }
        if (this.systems.size() != 0) {
            this.invalidate();
        } else {
            this.timer.reset();
        }
    }

    public final void start(@NotNull ParticleSystem particleSystem) {
        Intrinsics.checkNotNullParameter((Object)particleSystem, (String)"particleSystem");
        this.systems.add(particleSystem);
        OnParticleSystemUpdateListener onParticleSystemUpdateListener = this.onParticleSystemUpdateListener;
        if (onParticleSystemUpdateListener != null) {
            onParticleSystemUpdateListener.onParticleSystemStarted(this, particleSystem, this.systems.size());
        }
        this.invalidate();
    }

    public final void stop(@NotNull ParticleSystem particleSystem) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)particleSystem, (String)"particleSystem");
            this.systems.remove(particleSystem);
            OnParticleSystemUpdateListener onParticleSystemUpdateListener = this.onParticleSystemUpdateListener;
            if (onParticleSystemUpdateListener == null) break block0;
            onParticleSystemUpdateListener.onParticleSystemEnded(this, particleSystem, this.systems.size());
        }
    }

    public final void reset() {
        this.systems.clear();
    }

    public final void stopGracefully() {
        Iterable $this$forEach$iv = this.systems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticleSystem it = (ParticleSystem)element$iv;
            boolean bl = false;
            it.getRenderSystem$konfetti_release().setEnabled(false);
        }
    }

    public KonfettiView(@Nullable Context context) {
        super(context);
        boolean bl = false;
        this.systems = new ArrayList();
        this.timer = new TimerIntegration();
    }

    public KonfettiView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        boolean bl = false;
        this.systems = new ArrayList();
        this.timer = new TimerIntegration();
    }

    public KonfettiView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        boolean bl = false;
        this.systems = new ArrayList();
        this.timer = new TimerIntegration();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnl/dionsegijn/konfetti/KonfettiView$TimerIntegration;", "", "()V", "previousTime", "", "getDeltaTime", "", "getTotalTimeRunning", "startTime", "reset", "", "konfetti_release"})
    public static final class TimerIntegration {
        private long previousTime = -1L;

        public final void reset() {
            this.previousTime = -1L;
        }

        public final float getDeltaTime() {
            if (this.previousTime == -1L) {
                this.previousTime = System.nanoTime();
            }
            long currentTime = System.nanoTime();
            float dt = (float)(currentTime - this.previousTime) / 1000000.0f;
            this.previousTime = currentTime;
            return dt / (float)1000;
        }

        public final long getTotalTimeRunning(long startTime) {
            long currentTime = System.currentTimeMillis();
            return currentTime - startTime;
        }
    }
}

