/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import nl.dionsegijn.konfetti.models.Shape;
import nl.dionsegijn.konfetti.models.Size;
import nl.dionsegijn.konfetti.models.Vector;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\r\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0015J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0003J\u0010\u00109\u001a\u0002072\u0006\u0010:\u001a\u00020;H\u0002J\b\u00100\u001a\u00020\u0013H\u0002J\u0006\u0010<\u001a\u00020\rJ\u0016\u0010=\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010>\u001a\u00020\u0013J\u0010\u0010?\u001a\u0002072\u0006\u0010>\u001a\u00020\u0013H\u0002J\u0010\u0010@\u001a\u0002072\u0006\u0010>\u001a\u00020\u0013H\u0002R\u0011\u0010\u0011\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0017R\u000e\u0010*\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010&R\u000e\u0010-\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010!\"\u0004\b4\u0010#R\u000e\u00105\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lnl/dionsegijn/konfetti/Confetti;", "", "location", "Lnl/dionsegijn/konfetti/models/Vector;", "color", "", "size", "Lnl/dionsegijn/konfetti/models/Size;", "shape", "Lnl/dionsegijn/konfetti/models/Shape;", "lifespan", "", "fadeOut", "", "acceleration", "velocity", "rotate", "accelerate", "maxAcceleration", "", "rotationSpeedMultiplier", "(Lnl/dionsegijn/konfetti/models/Vector;ILnl/dionsegijn/konfetti/models/Size;Lnl/dionsegijn/konfetti/models/Shape;JZLnl/dionsegijn/konfetti/models/Vector;Lnl/dionsegijn/konfetti/models/Vector;ZZFF)V", "getAccelerate", "()Z", "alpha", "getColor", "()I", "getFadeOut", "getLifespan", "()J", "setLifespan", "(J)V", "getLocation", "()Lnl/dionsegijn/konfetti/models/Vector;", "setLocation", "(Lnl/dionsegijn/konfetti/models/Vector;)V", "mass", "getMaxAcceleration", "()F", "paint", "Landroid/graphics/Paint;", "getRotate", "rotation", "rotationSpeed", "getRotationSpeedMultiplier", "rotationWidth", "getShape", "()Lnl/dionsegijn/konfetti/models/Shape;", "getSize", "()Lnl/dionsegijn/konfetti/models/Size;", "speedF", "getVelocity", "setVelocity", "width", "applyForce", "", "force", "display", "canvas", "Landroid/graphics/Canvas;", "isDead", "render", "deltaTime", "update", "updateAlpha", "konfetti_release"})
public final class Confetti {
    private final float mass;
    private float width;
    private final Paint paint;
    private float rotationSpeed;
    private float rotation;
    private float rotationWidth;
    private float speedF;
    private int alpha;
    @NotNull
    private Vector location;
    private final int color;
    @NotNull
    private final Size size;
    @NotNull
    private final Shape shape;
    private long lifespan;
    private final boolean fadeOut;
    private Vector acceleration;
    @NotNull
    private Vector velocity;
    private final boolean rotate;
    private final boolean accelerate;
    private final float maxAcceleration;
    private final float rotationSpeedMultiplier;

    private final float getSize() {
        return this.width;
    }

    public final boolean isDead() {
        return this.alpha <= 0;
    }

    public final void applyForce(@NotNull Vector force) {
        Intrinsics.checkNotNullParameter((Object)force, (String)"force");
        this.acceleration.addScaled(force, 1.0f / this.mass);
    }

    public final void render(@NotNull Canvas canvas, float deltaTime) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.update(deltaTime);
        this.display(canvas);
    }

    private final void update(float deltaTime) {
        if (this.accelerate && (this.acceleration.getY() < this.maxAcceleration || this.maxAcceleration == -1.0f)) {
            this.velocity.add(this.acceleration);
        }
        this.location.addScaled(this.velocity, deltaTime * this.speedF);
        if (this.lifespan <= 0L) {
            this.updateAlpha(deltaTime);
        } else {
            this.lifespan -= (long)(deltaTime * (float)1000);
        }
        float rSpeed = this.rotationSpeed * deltaTime * this.speedF;
        this.rotation += rSpeed;
        if (this.rotation >= (float)360) {
            this.rotation = 0.0f;
        }
        this.rotationWidth -= rSpeed;
        if (this.rotationWidth < 0.0f) {
            this.rotationWidth = this.width;
        }
    }

    private final void updateAlpha(float deltaTime) {
        int n;
        if (this.fadeOut) {
            float interval = (float)5 * deltaTime * this.speedF;
            n = RangesKt.coerceAtLeast((int)(this.alpha - (int)interval), (int)0);
        } else {
            n = 0;
        }
        this.alpha = n;
    }

    private final void display(Canvas canvas) {
        if (this.location.getY() > (float)canvas.getHeight()) {
            this.lifespan = 0L;
            return;
        }
        if (this.location.getX() > (float)canvas.getWidth() || this.location.getX() + this.getSize() < 0.0f || this.location.getY() + this.getSize() < 0.0f) {
            return;
        }
        this.paint.setColor(this.alpha << 24 | this.color & 0xFFFFFF);
        float f = this.rotationWidth / this.width - 0.5f;
        boolean bl = false;
        float scaleX = Math.abs(f) * (float)2;
        float centerX = scaleX * this.width / (float)2;
        int saveCount = canvas.save();
        canvas.translate(this.location.getX() - centerX, this.location.getY());
        canvas.rotate(this.rotation, centerX, this.width / (float)2);
        canvas.scale(scaleX, 1.0f);
        this.shape.draw(canvas, this.paint, this.width);
        canvas.restoreToCount(saveCount);
    }

    @NotNull
    public final Vector getLocation() {
        return this.location;
    }

    public final void setLocation(@NotNull Vector vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"<set-?>");
        this.location = vector;
    }

    public final int getColor() {
        return this.color;
    }

    @NotNull
    public final Size getSize() {
        return this.size;
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    public final long getLifespan() {
        return this.lifespan;
    }

    public final void setLifespan(long l) {
        this.lifespan = l;
    }

    public final boolean getFadeOut() {
        return this.fadeOut;
    }

    @NotNull
    public final Vector getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vector vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"<set-?>");
        this.velocity = vector;
    }

    public final boolean getRotate() {
        return this.rotate;
    }

    public final boolean getAccelerate() {
        return this.accelerate;
    }

    public final float getMaxAcceleration() {
        return this.maxAcceleration;
    }

    public final float getRotationSpeedMultiplier() {
        return this.rotationSpeedMultiplier;
    }

    public Confetti(@NotNull Vector location, int color, @NotNull Size size, @NotNull Shape shape, long lifespan, boolean fadeOut, @NotNull Vector acceleration, @NotNull Vector velocity, boolean rotate, boolean accelerate, float maxAcceleration, float rotationSpeedMultiplier) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)acceleration, (String)"acceleration");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        this.location = location;
        this.color = color;
        this.size = size;
        this.shape = shape;
        this.lifespan = lifespan;
        this.fadeOut = fadeOut;
        this.acceleration = acceleration;
        this.velocity = velocity;
        this.rotate = rotate;
        this.accelerate = accelerate;
        this.maxAcceleration = maxAcceleration;
        this.rotationSpeedMultiplier = rotationSpeedMultiplier;
        this.mass = this.size.getMass();
        this.width = this.size.getSizeInPx$konfetti_release();
        this.paint = new Paint();
        this.rotationWidth = this.width;
        this.speedF = 60.0f;
        this.alpha = 255;
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        float minRotationSpeed = 0.29f * resources.getDisplayMetrics().density;
        float maxRotationSpeed = minRotationSpeed * (float)3;
        if (this.rotate) {
            this.rotationSpeed = (maxRotationSpeed * Random.Default.nextFloat() + minRotationSpeed) * this.rotationSpeedMultiplier;
        }
        this.paint.setColor(this.color);
    }

    public /* synthetic */ Confetti(Vector vector, int n, Size size, Shape shape, long l, boolean bl, Vector vector2, Vector vector3, boolean bl2, boolean bl3, float f, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            l = -1L;
        }
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        if ((n2 & 0x40) != 0) {
            vector2 = new Vector(0.0f, 0.0f);
        }
        if ((n2 & 0x80) != 0) {
            vector3 = new Vector(0.0f, 0.0f, 3, null);
        }
        if ((n2 & 0x100) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x200) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x400) != 0) {
            f = -1.0f;
        }
        if ((n2 & 0x800) != 0) {
            f2 = 1.0f;
        }
        this(vector, n, size, shape, l, bl, vector2, vector3, bl2, bl3, f, f2);
    }
}

