/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import nl.sascom.backplanepublic.common.EndPointId;
import nl.sascom.backplanepublic.common.JsonUpdate;
import nl.sascom.backplanepublic.common.NodeHttpAsyncTransport;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.UpdateInterface;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.eclipse.jetty.websocket.api.annotations.WebSocket(maxIdleTime=3600000, maxBinaryMessageSize=0x20000000)
public class WebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocket.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private NodeHttpAsyncTransport nodeHttpAsyncTransport;

    public WebSocket(NodeHttpAsyncTransport nodeHttpAsyncTransport) {
        this.nodeHttpAsyncTransport = nodeHttpAsyncTransport;
    }

    @OnWebSocketConnect
    public void onOpen(Session session) {
        this.nodeHttpAsyncTransport.setSession(session);
    }

    @OnWebSocketMessage
    public void onBinary(byte[] byArray, int n, int n2) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2).order(ByteOrder.LITTLE_ENDIAN);
            int n3 = byteBuffer.getInt();
            byte[] byArray2 = new byte[n3];
            byteBuffer.get(byArray2);
            String string = new String(byArray2, StandardCharsets.UTF_8);
            ResponseType responseType = ResponseType.fromId(byteBuffer.get());
            int n4 = byteBuffer.getInt();
            byte[] byArray3 = new byte[n4];
            byteBuffer.get(byArray3);
            this.nodeHttpAsyncTransport.newData(string, responseType, byArray3);
        }
        catch (Throwable throwable) {
            LOGGER.error("", throwable);
        }
    }

    @OnWebSocketError
    public void onError(Throwable throwable) {
        if (throwable instanceof CloseException) {
            CloseException closeException = (CloseException)throwable;
            if (!(closeException.getCause() instanceof TimeoutException)) {
                LOGGER.error("", throwable);
            }
        } else {
            LOGGER.error("", throwable);
        }
    }

    @OnWebSocketMessage
    public void onText(String string) {
        try {
            ObjectNode objectNode = (ObjectNode)OBJECT_MAPPER.readValue(string, ObjectNode.class);
            if (objectNode.has("endPointId")) {
                this.nodeHttpAsyncTransport.endPointId = EndPointId.fromString(objectNode.get("endPointId").asText());
                this.nodeHttpAsyncTransport.endPointIdLatch.countDown();
            } else {
                UpdateInterface updateInterface = JsonUpdate.create(objectNode);
                this.nodeHttpAsyncTransport.newData(updateInterface.getId(), updateInterface.getResponseType(), updateInterface.toMessageBytes());
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("", throwable);
        }
    }

    @OnWebSocketClose
    public void onClose(int n, String string) {
        if (n == 1001 || n == 1006) {
            this.nodeHttpAsyncTransport.onCloseReconnect();
        } else if (n != 1000) {
            LOGGER.error(n + " " + string);
        }
    }

    public void send(ObjectNode objectNode) {
        this.nodeHttpAsyncTransport.sendMessage(objectNode.toString());
    }
}

