/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.node.ObjectNode;
import nl.sascom.backplanepublic.common.Response;

public class TaskIdentifier {
    private String repositoryName;
    private String fullRepositoryName;
    private String branchName;
    private String projectName;
    private String fullProjectName;
    private String version;
    private String taskName;

    public TaskIdentifier() {
    }

    public TaskIdentifier(String string, String string2, String string3, String string4, String string5) {
        this.fullRepositoryName = string;
        this.branchName = string2;
        this.fullProjectName = string3;
        this.version = string4;
        this.taskName = string5;
    }

    public TaskIdentifier(String string) {
        this.taskName = string;
    }

    public static TaskIdentifier from(ObjectNode objectNode) {
        TaskIdentifier taskIdentifier = new TaskIdentifier();
        if (!objectNode.has("taskName")) {
            throw new RuntimeException("Invalid task identifier: " + objectNode);
        }
        taskIdentifier.taskName = objectNode.get("taskName").asText();
        if (objectNode.has("fullRepositoryName")) {
            taskIdentifier.fullRepositoryName = objectNode.get("fullRepositoryName").asText();
        }
        if (objectNode.has("repositoryName")) {
            taskIdentifier.repositoryName = objectNode.get("repositoryName").asText();
        }
        if (objectNode.has("branchName")) {
            taskIdentifier.branchName = objectNode.get("branchName").asText();
        }
        if (objectNode.has("fullProjectName")) {
            taskIdentifier.fullProjectName = objectNode.get("fullProjectName").asText();
        }
        if (objectNode.has("projectName")) {
            taskIdentifier.projectName = objectNode.get("projectName").asText();
        }
        if (objectNode.has("version")) {
            taskIdentifier.version = objectNode.get("version").asText();
        }
        return taskIdentifier;
    }

    public ObjectNode toJson() {
        ObjectNode objectNode = Response.createObject();
        if (this.fullRepositoryName != null) {
            objectNode.put("fullRepositoryName", this.fullRepositoryName);
        }
        if (this.repositoryName != null) {
            objectNode.put("repositoryName", this.repositoryName);
        }
        if (this.branchName != null) {
            objectNode.put("branchName", this.branchName);
        }
        if (this.fullProjectName != null) {
            objectNode.put("fullProjectName", this.fullProjectName);
        }
        if (this.projectName != null) {
            objectNode.put("projectName", this.projectName);
        }
        if (this.version != null) {
            objectNode.put("version", this.version);
        }
        objectNode.put("taskName", this.taskName);
        return objectNode;
    }

    public String getFullRepositoryName() {
        return this.fullRepositoryName;
    }

    public void setFullRepositoryName(String string) {
        this.fullRepositoryName = string;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String string) {
        this.branchName = string;
    }

    public String getFullProjectName() {
        return this.fullProjectName;
    }

    public void setFullProjectName(String string) {
        this.fullProjectName = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String string) {
        this.taskName = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fullRepositoryName != null) {
            stringBuilder.append("Full repo name: " + this.fullRepositoryName + ", ");
        }
        if (this.repositoryName != null) {
            stringBuilder.append("Repo name " + this.repositoryName + ", ");
        }
        if (this.branchName != null) {
            stringBuilder.append("Branch: " + this.branchName + ", ");
        }
        if (this.fullProjectName != null) {
            stringBuilder.append("Full project name: " + this.fullProjectName + ", ");
        }
        if (this.projectName != null) {
            stringBuilder.append("Project name: " + this.projectName + ", ");
        }
        if (this.version != null) {
            stringBuilder.append("Version: " + this.version + ", ");
        }
        stringBuilder.append("Task: " + this.taskName);
        return stringBuilder.toString();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String string) {
        this.repositoryName = string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.branchName == null ? 0 : this.branchName.hashCode());
        n = 31 * n + (this.fullProjectName == null ? 0 : this.fullProjectName.hashCode());
        n = 31 * n + (this.fullRepositoryName == null ? 0 : this.fullRepositoryName.hashCode());
        n = 31 * n + (this.projectName == null ? 0 : this.projectName.hashCode());
        n = 31 * n + (this.repositoryName == null ? 0 : this.repositoryName.hashCode());
        n = 31 * n + (this.taskName == null ? 0 : this.taskName.hashCode());
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TaskIdentifier taskIdentifier = (TaskIdentifier)object;
        if (this.branchName == null ? taskIdentifier.branchName != null : !this.branchName.equals(taskIdentifier.branchName)) {
            return false;
        }
        if (this.fullProjectName == null ? taskIdentifier.fullProjectName != null : !this.fullProjectName.equals(taskIdentifier.fullProjectName)) {
            return false;
        }
        if (this.fullRepositoryName == null ? taskIdentifier.fullRepositoryName != null : !this.fullRepositoryName.equals(taskIdentifier.fullRepositoryName)) {
            return false;
        }
        if (this.projectName == null ? taskIdentifier.projectName != null : !this.projectName.equals(taskIdentifier.projectName)) {
            return false;
        }
        if (this.repositoryName == null ? taskIdentifier.repositoryName != null : !this.repositoryName.equals(taskIdentifier.repositoryName)) {
            return false;
        }
        if (this.taskName == null ? taskIdentifier.taskName != null : !this.taskName.equals(taskIdentifier.taskName)) {
            return false;
        }
        return !(this.version == null ? taskIdentifier.version != null : !this.version.equals(taskIdentifier.version));
    }
}

