/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import nl.sascom.backplanepublic.common.StreamSource;

public class StreamReadingByteSource
extends ByteSource {
    private StreamSource streamSource;

    public StreamReadingByteSource(StreamSource streamSource) {
        this.streamSource = streamSource;
    }

    public InputStream openStream() throws IOException {
        return new InputStream(){
            private long readPosition;

            @Override
            public int read() throws IOException {
                return 0;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = (int)(StreamReadingByteSource.this.streamSource.getWritePosition() - this.readPosition);
                int n4 = Math.min(n2, n3);
                while (n4 <= 0) {
                    if (StreamReadingByteSource.this.streamSource.writingIsDone()) {
                        return -1;
                    }
                    try {
                        CountDownLatch countDownLatch = new CountDownLatch(1);
                        StreamReadingByteSource.this.streamSource.registerWriteLatch(countDownLatch);
                        countDownLatch.await();
                        StreamReadingByteSource.this.streamSource.unregisterWriteLatch(countDownLatch);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    n3 = (int)(StreamReadingByteSource.this.streamSource.getWritePosition() - this.readPosition);
                    n4 = Math.min(n2, n3);
                }
                int n5 = StreamReadingByteSource.this.streamSource.read(this.readPosition, byArray, n, n4);
                if (n5 == -1) {
                    if (StreamReadingByteSource.this.streamSource.writingIsDone()) {
                        return -1;
                    }
                    throw new IOException("Got -1, but not done yet");
                }
                this.readPosition += (long)n5;
                return n5;
            }
        };
    }
}

