/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import java.nio.ByteBuffer;
import nl.sascom.backplanepublic.common.BinaryUpdate;
import nl.sascom.backplanepublic.common.ResponseType;

public class BinaryDataPush
extends BinaryUpdate {
    private ByteBuffer byteBuffer;

    public BinaryDataPush(String string, ByteBuffer byteBuffer) {
        super(string);
        this.byteBuffer = byteBuffer;
    }

    public BinaryDataPush(byte[] byArray) {
        super(byArray);
    }

    public BinaryDataPush(String string, String string2, ByteBuffer byteBuffer) {
        super(string, string2);
        this.byteBuffer = byteBuffer;
    }

    @Override
    public ResponseType getResponseType() {
        return ResponseType.BINARY_DATA_PUSH;
    }

    @Override
    public byte[] getBytes() {
        return this.byteBuffer.array();
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void setData(byte[] byArray) {
        this.byteBuffer = ByteBuffer.wrap(byArray);
    }

    public String toString() {
        return "BinaryDataPush: " + this.byteBuffer.capacity() + " bytes";
    }

    @Override
    public void writeBytes(ByteBuffer byteBuffer) {
        this.byteBuffer.position(0);
        byteBuffer.putInt(this.byteBuffer.capacity());
        byteBuffer.put(this.byteBuffer);
    }

    @Override
    public int getInternalSize() {
        return this.byteBuffer.capacity();
    }
}

