/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.timing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.sascom.backplanepublic.common.processinginfo.ConsoleTable;

public class Timing {
    private String name;
    private Timing parent;
    private Timing currentChild;
    private Map<String, Timing> children;
    private long currentStartNanos;
    private long totalNanos;
    private int level;
    private String[] columns;

    public Timing(Timing timing, String string) {
        this.parent = timing;
        this.name = string;
        this.currentStartNanos = System.nanoTime();
        this.level = timing == null ? 0 : timing.getLevel() + 1;
    }

    private int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        ConsoleTable consoleTable = new ConsoleTable();
        this.dump(consoleTable);
        return consoleTable.toString();
    }

    private void dump(ConsoleTable consoleTable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.level; ++i) {
            stringBuilder.append("  ");
        }
        stringBuilder.append(this.name);
        String[] stringArray = new String[2 + (this.columns == null ? 0 : this.columns.length)];
        stringArray[0] = stringBuilder.toString();
        stringArray[1] = this.getTotalMillis() + " ms";
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                stringArray[2 + i] = this.columns[i];
            }
        }
        consoleTable.add(stringArray);
        if (this.children != null) {
            for (Timing timing : this.children.values()) {
                timing.dump(consoleTable);
            }
        }
    }

    public long getTotalMillis() {
        return this.totalNanos / 1000000L;
    }

    public Timing start(String string) {
        if (this.currentChild == null) {
            Timing timing;
            if (this.children == null) {
                this.children = new LinkedHashMap<String, Timing>();
            }
            if ((timing = this.children.get(string)) == null) {
                this.currentChild = new Timing(this, string);
                this.children.put(string, this.currentChild);
            } else {
                this.currentChild = timing;
                this.currentChild.reset();
            }
            return this.currentChild;
        }
        return this.currentChild.start(string);
    }

    private void reset() {
        this.currentStartNanos = System.nanoTime();
    }

    public Timing getParent() {
        return this.parent;
    }

    public Timing getCurrentChild() {
        return this.currentChild;
    }

    public void stop(String string, String ... stringArray) {
        if (this.currentChild != null) {
            this.currentChild.columns = stringArray;
        }
        this.stop(string);
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void stop(String string) {
        if (this.currentChild == null) {
            if (!this.name.equals(string)) {
                throw new RuntimeException("Expected " + this.name + ", got " + string);
            }
            this.totalNanos = System.nanoTime() - this.currentStartNanos;
            if (this.parent != null) {
                this.parent.clearCurrent();
            }
        } else {
            this.currentChild.stop(string);
        }
    }

    private void clearCurrent() {
        this.currentChild = null;
    }

    public static Timing read(Timing timing, DataInputStream dataInputStream) throws IOException {
        Timing timing2 = new Timing(timing, dataInputStream.readUTF());
        timing2.totalNanos = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        if (n > 0) {
            timing2.children = new LinkedHashMap<String, Timing>();
            for (int i = 0; i < n; ++i) {
                Timing timing3 = Timing.read(timing2, dataInputStream);
                String string = timing3.getName();
                timing2.children.put(string, timing3);
            }
        }
        return timing2;
    }

    public static Timing read(DataInputStream dataInputStream) throws IOException {
        return Timing.read(null, dataInputStream);
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeLong(this.totalNanos);
        if (this.children == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.children.size());
            for (Timing timing : this.children.values()) {
                timing.writeTo(dataOutputStream);
            }
        }
    }

    public Timing get(String string) {
        if (string.contains(".")) {
            String string2 = string.substring(0, string.indexOf("."));
            String string3 = string.substring(string.indexOf(".") + 1);
            if (this.children != null && this.children.containsKey(string2)) {
                return this.children.get(string2).get(string3);
            }
            return null;
        }
        return this;
    }

    public void setData(String ... stringArray) {
        this.columns = stringArray;
    }
}

