/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.nativeprocess;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import nl.sascom.backplanepublic.common.NativeProcessManagerInterface;
import nl.sascom.backplanepublic.common.QuickProcessRunner;
import nl.sascom.backplanepublic.common.nativeprocess.NativeProcessOptions;
import nl.sascom.backplanepublic.common.nativeprocess.NativeProcessTiming;
import nl.sascom.backplanepublic.common.nativeprocess.ProcessException;
import nl.sascom.backplanepublic.common.nativeprocess.ProcessWrapper;
import nl.sascom.backplanepublic.common.nativeprocess.RealtimeStatistis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingProcessWrapper
implements Runnable,
ProcessWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingProcessWrapper.class);
    private Process process;
    private long id;
    private NativeProcessManagerInterface nativeProcessManager;
    private NativeProcessOptions options;
    private NativeProcessTiming nativeProcessTiming;
    private RealtimeStatistis realtimeStatistics;
    private ProcessBuilder processBuilder;
    private CountDownLatch waitForExit = new CountDownLatch(1);
    private Path fileForErrors;
    private CountDownLatch processWaiter = new CountDownLatch(1);

    public BlockingProcessWrapper(NativeProcessManagerInterface nativeProcessManagerInterface, ProcessBuilder processBuilder, long l, NativeProcessOptions nativeProcessOptions) {
        this.nativeProcessManager = nativeProcessManagerInterface;
        this.processBuilder = processBuilder;
        this.id = l;
        this.fileForErrors = nativeProcessManagerInterface.getFileFor(this);
        this.processBuilder.redirectError(ProcessBuilder.Redirect.appendTo(this.fileForErrors.toFile()));
        this.options = nativeProcessOptions;
        if (nativeProcessOptions.isMonitorProcess()) {
            this.realtimeStatistics = new RealtimeStatistis();
        }
    }

    @Override
    public void waitForExit() throws InterruptedException {
        this.waitForExit.await();
    }

    @Override
    public NativeProcessOptions getOptions() {
        return this.options;
    }

    public Process waitForProcess() throws InterruptedException, ProcessException {
        this.processWaiter.await(4L, TimeUnit.HOURS);
        if (this.process == null) {
            throw new ProcessException("Could not acquire a process");
        }
        return this.process;
    }

    @Override
    public void run() {
        try {
            try {
                this.process = this.processBuilder.start();
            }
            catch (IOException iOException) {
                LOGGER.error("", (Throwable)iOException);
            }
            this.processWaiter.countDown();
            this.process.onExit().get();
            if (this.options.isTimeProcess()) {
                try {
                    this.nativeProcessTiming = new NativeProcessTiming(Files.readString(this.fileForErrors));
                }
                catch (IOException iOException) {
                    LOGGER.error("", (Throwable)iOException);
                }
            }
            this.nativeProcessManager.done(this);
            this.waitForExit.countDown();
        }
        catch (Throwable throwable) {
            LOGGER.error("", throwable);
            this.processWaiter.countDown();
        }
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public boolean update() {
        if (this.process.isAlive()) {
            if (System.getProperty("os.name").contains("windows")) {
                return true;
            }
            Map<String, String> map = QuickProcessRunner.getProcessStatuses(QuickProcessRunner.run("cat", "/proc/" + this.process.pid() + "/status"), "VmPeak", "VmSize");
            String string = map.get("VmPeak");
            if (string != null) {
                long l = Long.parseLong(string.substring(0, string.indexOf(" ")));
                this.realtimeStatistics.updateVmPeakKb(l);
            }
            return true;
        }
        return false;
    }

    @Override
    public NativeProcessTiming getNativeProcessTiming() {
        return this.nativeProcessTiming;
    }

    public static void main(String[] stringArray) {
        Map<String, String> map = QuickProcessRunner.getProcessStatuses(QuickProcessRunner.run("cat", "/proc/6642/status"), "VmPeak", "VmSize");
        for (String string : map.keySet()) {
            System.out.println(string + ": " + map.get(string));
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void destroy() {
        this.process.destroy();
    }
}

