/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import nl.sascom.backplane.ByteBufferHolder;
import nl.sascom.backplanepublic.client.CommunicationWebSocket;
import nl.sascom.backplanepublic.client.CountdownCompletableFuture;
import nl.sascom.backplanepublic.client.HttpHost;
import nl.sascom.backplanepublic.common.AsyncCallback;
import nl.sascom.backplanepublic.common.EndPointId;
import nl.sascom.backplanepublic.common.Heartbeat;
import nl.sascom.backplanepublic.common.NodeTransport;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.StreamAlreadyRegisteredException;
import nl.sascom.backplanepublic.common.StreamSendException;
import nl.sascom.backplanepublic.common.TransportException;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketNodeTransport
implements NodeTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketNodeTransport.class);
    private String name;
    private HttpHost target;
    private CountDownLatch endPointIdLatch;
    private volatile boolean running;
    private Heartbeat heartbeat;
    private WebSocketClient client;
    private CommunicationWebSocket webSocket;
    private EndPointId endPointId;
    private EndPointId endPointId2;
    private String dest;
    private AsyncCallback asyncCallback;

    public WebSocketNodeTransport(String string, String string2, int n, String string3) throws InterruptedException, ExecutionException, TimeoutException {
        LOGGER.info("New transport " + string + "://" + string2 + ":" + n + " (" + string3 + ")");
        this.name = string3;
        this.target = new HttpHost(string, string2, n);
        this.dest = (this.target.getSchema().equals("https") ? "wss" : "ws") + "://";
        this.dest = this.dest + this.target.getHost();
        if (!(this.target.getSchema().equals("https") && n == 443 || this.target.getSchema().equals("http") && n == 80)) {
            this.dest = this.dest + ":" + n;
        }
        this.dest = this.dest + "/wsuc";
        this.connect();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public Future<Void> connect() throws InterruptedException, ExecutionException, TimeoutException {
        this.endPointIdLatch = new CountDownLatch(1);
        this.endPointId = null;
        if (this.client != null) {
            try {
                this.client.stop();
                if (this.heartbeat != null) {
                    this.heartbeat.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOGGER.info("Creating new WebSocketClient for " + this.dest);
        this.client = new WebSocketClient();
        this.webSocket = new CommunicationWebSocket(this);
        try {
            this.client.start();
            ClientUpgradeRequest clientUpgradeRequest = new ClientUpgradeRequest();
            Future future = this.client.connect((Object)this.webSocket, URI.create(this.dest), clientUpgradeRequest);
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage());
        }
        this.running = true;
        return new CountdownCompletableFuture(this.endPointIdLatch);
    }

    @Override
    public ByteBufferHolder execute(byte[] byArray) throws IOException, InterruptedException, ExecutionException, TransportException {
        this.webSocket.send(byArray);
        return null;
    }

    @Override
    public void setAsyncCallback(AsyncCallback asyncCallback) {
        this.asyncCallback = asyncCallback;
    }

    @Override
    public void connectAsync(ObjectNode objectNode) {
    }

    @Override
    public void sendStream(String string, ByteSource byteSource) throws StreamAlreadyRegisteredException, StreamSendException, ExecutionException {
    }

    @Override
    public EndPointId getOwnEndpointId() {
        return this.endPointId;
    }

    @Override
    public Future<Void> receiveStream(String string, OutputStream outputStream) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public void setNodeClient(Object object) {
    }

    public void onOpen() {
    }

    public void newData(String string, ResponseType responseType, byte[] byArray) {
        this.asyncCallback.newData(string, responseType, byArray);
    }

    public void setEndPointId(EndPointId endPointId) {
        this.endPointId = endPointId;
        this.endPointIdLatch.countDown();
    }

    public void onCloseReconnect() {
        LOGGER.error("TODO");
    }
}

