/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import nl.sascom.backplanepublic.client.AbstractHttpAsyncTransport;
import nl.sascom.backplanepublic.client.ConnectionFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionMonitor
extends Thread {
    private volatile boolean running = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionMonitor.class);
    private AbstractHttpAsyncTransport httpAsyncTransport;
    private ConnectionFuture connectionFuture;
    private CountDownLatch startLatch = new CountDownLatch(1);

    public ConnectionMonitor(AbstractHttpAsyncTransport abstractHttpAsyncTransport) {
        this.httpAsyncTransport = abstractHttpAsyncTransport;
    }

    public void waitForStart() throws InterruptedException {
        this.startLatch.await();
    }

    @Override
    public void run() {
        this.setName("ConnectionMonitor");
        while (this.running) {
            if (!this.httpAsyncTransport.isConnected()) {
                this.connectionFuture = new ConnectionFuture();
                long l = System.currentTimeMillis();
                this.startLatch.countDown();
                try {
                    this.httpAsyncTransport.connectInternal();
                    this.connectionFuture.connected();
                }
                catch (Exception exception) {
                    this.connectionFuture.exception(exception);
                    try {
                        long l2 = 5000L - (System.currentTimeMillis() - l);
                        if (l2 <= 0L) continue;
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.running) break;
                        LOGGER.error("", (Throwable)interruptedException);
                    }
                }
                continue;
            }
            try {
                this.httpAsyncTransport.ping();
            }
            catch (Exception exception) {
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                if (!this.running) continue;
                LOGGER.error("", (Throwable)interruptedException);
            }
        }
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
    }

    public Future<Void> getFuture() {
        if (this.httpAsyncTransport.isConnected()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.connectionFuture;
    }
}

