/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import nl.sascom.backplane.ByteBufferHolder;
import nl.sascom.backplanepublic.client.ClientErrorCode;
import nl.sascom.backplanepublic.common.BinaryDataListener;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.DataPushListener;
import nl.sascom.backplanepublic.common.ErrorCode;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.LightContainerInterface;
import nl.sascom.backplanepublic.common.Listener;
import nl.sascom.backplanepublic.common.LogListener;
import nl.sascom.backplanepublic.common.MetricListener;
import nl.sascom.backplanepublic.common.NodeTransport;
import nl.sascom.backplanepublic.common.ProgressListener;
import nl.sascom.backplanepublic.common.Registration;
import nl.sascom.backplanepublic.common.RegistrationItem;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.ResponseListener;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.TaskInfoListener;
import nl.sascom.backplanepublic.common.TaskTimeoutException;
import nl.sascom.backplanepublic.common.TransportException;
import nl.sascom.backplanepublic.common.UpdateInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTask
extends Response
implements Runnable,
ClientTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTask.class);
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private volatile Response response;
    private final Request request;
    private final NodeTransport nodeTransport;
    private final LightContainerInterface node;
    private volatile boolean running;
    private final Map<ResponseType, Map<String, Set<Listener>>> listeners = new HashMap<ResponseType, Map<String, Set<Listener>>>();
    private volatile boolean executedOrExecuting;

    public AsyncTask(LightContainerInterface lightContainerInterface, NodeTransport nodeTransport, Request request) {
        this.setId(request.getId());
        this.node = lightContainerInterface;
        this.nodeTransport = nodeTransport;
        this.request = request;
        ObjectNode objectNode = AsyncTask.createObject();
        objectNode.put("id", request.getId());
        this.setOutput((JsonNode)objectNode);
    }

    @Override
    public synchronized Response await(long l, TimeUnit timeUnit) throws InterruptedException, ExecuteException {
        if (this.countDownLatch.await(l, timeUnit)) {
            if (this.response == null) {
                throw new ExecuteException((ErrorCode)ClientErrorCode.NO_RESPONSE, "No response (" + this.request.getTaskIdentifier().getTaskName() + ")");
            }
            if (this.response.hasError()) {
                throw new ExecuteException(this.response.getErrorNode());
            }
            return this.response;
        }
        throw new TaskTimeoutException("No response, timeout exceeded (" + this.request.getTaskIdentifier().getTaskName() + ")", l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(UpdateInterface updateInterface) {
        Map<String, Set<Listener>> map = this.listeners.get((Object)updateInterface.getResponseType());
        if (updateInterface.getClass() == Response.class) {
            this.response = (Response)updateInterface;
            this.countDownLatch.countDown();
        }
        if (map == null) {
            return;
        }
        if (updateInterface.getSubType() == null) {
            for (String string : map.keySet()) {
                Set<Listener> set = map.get(string);
                if (set == null) continue;
                Set<Listener> set2 = set;
                synchronized (set2) {
                    for (Listener listener : set) {
                        listener.process(updateInterface);
                    }
                }
            }
        } else {
            Set<Listener> set = map.get(updateInterface.getSubType());
            if (set != null) {
                for (Listener listener : set) {
                    listener.process(updateInterface);
                }
            }
            if ((set = map.get("[ALL]")) == null) {
                return;
            }
            for (Listener listener : set) {
                listener.process(updateInterface);
            }
        }
    }

    @Override
    public AsyncTask exec() throws ExecuteException {
        String string2;
        this.executedOrExecuting = true;
        if (this.request.getNodeUuid() == null || !this.request.getNodeUuid().equals(this.node.getNodeUuid())) {
            for (String string2 : this.request.getAttachedStreams()) {
                try {
                    this.nodeTransport.sendStream(string2, this.node.getSource(string2));
                }
                catch (Exception exception) {
                    LOGGER.error("", (Throwable)exception);
                }
            }
        }
        boolean bl = this.request.isSync();
        string2 = this.request.getTaskIdentifier().getTaskName();
        if (string2.equals("LoginWithUsernamePassword")) {
            this.request.setSync(true);
            bl = true;
        }
        if (this.request.getAutoRegisterResponseTypes() == null) {
            this.request.setAutoRegisterResponseTypes(new Registration(ResponseType.RESPONSE));
        } else {
            this.request.getAutoRegisterResponseTypes().add(new RegistrationItem(ResponseType.RESPONSE));
        }
        if (!(this.nodeTransport.getOwnEndpointId() != null || string2.equals("LoginWithUsernamePassword") || string2.equals("LoginWithToken") || string2.equals("LoginWithApiToken") || string2.equals("Login"))) {
            LOGGER.error("NodeTransport does not have an endPointId " + this.nodeTransport);
        }
        this.request.setEndPointId(this.nodeTransport.getOwnEndpointId());
        if (this.request.getSubmitMillis() == -1L) {
            this.request.setSubmitMillis(System.currentTimeMillis());
        }
        ObjectNode objectNode = this.request.toJson();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray;
            OBJECT_MAPPER.writeValue((OutputStream)byteArrayOutputStream, (Object)objectNode);
            ByteBufferHolder byteBufferHolder = this.nodeTransport.execute(byteArrayOutputStream.toByteArray());
            if (byteBufferHolder != null && bl && (byArray = byteBufferHolder.get(this.request.getTimeOut(), this.request.getTimeUnit())) != null) {
                Response response = Response.fromBytes(byArray);
                this.running = true;
                if (response != null && response.getClass() == Response.class && bl) {
                    this.update(response);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
            this.countDownLatch.countDown();
        }
        catch (ExecutionException executionException) {
            LOGGER.error("", (Throwable)executionException);
            this.countDownLatch.countDown();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("", (Throwable)interruptedException);
            this.countDownLatch.countDown();
        }
        catch (TransportException transportException) {
            Response response = new Response(this.request.getId());
            ObjectNode objectNode2 = Response.createObject();
            objectNode2.put("message", transportException.getMessage());
            response.setError((JsonNode)objectNode2);
            this.update(response);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.error("", (Throwable)timeoutException);
            this.countDownLatch.countDown();
        }
        return this;
    }

    public Map<ResponseType, Set<String>> getRegisteredResponseTypesMap() {
        HashMap<ResponseType, Set<String>> hashMap = new HashMap<ResponseType, Set<String>>();
        for (ResponseType responseType : ResponseType.values()) {
            Map<String, Set<Listener>> map = this.getListenerSet(responseType, false);
            if (map.isEmpty()) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashMap.put(responseType, hashSet);
            for (String string : map.keySet()) {
                hashSet.add(string);
            }
        }
        return hashMap;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode objectNode = super.toJson();
        objectNode.put("type", ResponseType.ASYNC_RESPONSE.name());
        return objectNode;
    }

    @Override
    public AsyncTask addResponseListener(ResponseListener responseListener) {
        this.addListener(ResponseType.RESPONSE, null, responseListener);
        return this;
    }

    @Override
    public AsyncTask addLogListener(Set<String> set, LogListener logListener) {
        this.addListener(ResponseType.LOG, set, logListener);
        return this;
    }

    @Override
    public AsyncTask addTaskInfoListener(TaskInfoListener taskInfoListener) {
        this.addListener(ResponseType.TASK_INFO, null, taskInfoListener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addListener(ResponseType responseType, Set<String> set, Listener listener) {
        Object object2;
        Map<String, Set<Listener>> map = this.listeners.get((Object)responseType);
        boolean bl = false;
        if (map == null) {
            map = new HashMap<String, Set<Listener>>();
            this.listeners.put(responseType, map);
        }
        if (set == null) {
            void var7_9;
            object2 = "[ALL]";
            Set<Listener> object3 = map.get(object2);
            if (object3 == null) {
                HashSet hashSet = new HashSet();
                map.put((String)object2, hashSet);
            } else {
                bl = true;
            }
            void var8_14 = var7_9;
            synchronized (var8_14) {
                var7_9.add(listener);
            }
        } else {
            for (String string : set) {
                void var8_15;
                Set<Listener> set2 = map.get(string);
                if (set2 == null) {
                    HashSet hashSet = new HashSet();
                    map.put(string, hashSet);
                } else {
                    bl = true;
                }
                var8_15.add(listener);
            }
        }
        if (this.executedOrExecuting) {
            if (!bl) {
                object2 = new Registration(responseType, set);
                Request request = new Request();
                request.setEndPointId(this.nodeTransport.getOwnEndpointId());
                request.setTaskName("RegisterTaskListener");
                request.auth(this.request.getAuth());
                request.getObjectInput().put("id", this.getId());
                request.getObjectInput().set("responseTypes", ((Registration)object2).toJson());
                try {
                    this.nodeTransport.execute(request.toBytes()).get();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (TransportException transportException) {
                    transportException.printStackTrace();
                }
            }
        } else {
            object2 = this.request.getAutoRegisterResponseTypes();
            if (object2 == null) {
                object2 = new Registration();
                this.request.setAutoRegisterResponseTypes((Registration)object2);
            }
            if (set != null) {
                for (String string : set) {
                    RegistrationItem registrationItem = new RegistrationItem(responseType, string);
                    ((Registration)object2).add(registrationItem);
                }
            } else {
                ((Registration)object2).add(new RegistrationItem(responseType));
            }
        }
    }

    private <T extends Listener> Map<String, Set<Listener>> getListenerSet(ResponseType responseType, boolean bl) {
        Map<String, Set<Listener>> map = this.listeners.get((Object)responseType);
        if (map == null) {
            if (bl) {
                map = new HashMap<String, Set<Listener>>();
                this.listeners.put(responseType, map);
            } else {
                return Collections.EMPTY_MAP;
            }
        }
        return map;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        try {
            this.exec();
        }
        catch (Throwable throwable) {
            LOGGER.error("", throwable);
        }
    }

    @Override
    public AsyncTask addBinaryDataListener(Set<String> set, BinaryDataListener binaryDataListener) {
        this.addListener(ResponseType.BINARY_DATA_PUSH, set, binaryDataListener);
        return this;
    }

    @Override
    public AsyncTask addDataListener(Set<String> set, DataPushListener dataPushListener) {
        this.addListener(ResponseType.DATA_PUSH, set, dataPushListener);
        return this;
    }

    @Override
    public ClientTask addProgressListener(ProgressListener progressListener) {
        this.addListener(ResponseType.PROGRESS, null, progressListener);
        return this;
    }

    @Override
    public ClientTask addMetricListener(MetricListener metricListener) {
        this.addListener(ResponseType.METRIC_UPDATE, null, metricListener);
        return this;
    }

    @Override
    public void cleanup() {
    }

    public void setExecutedOrExecuting(boolean bl) {
        this.executedOrExecuting = bl;
    }

    @Override
    public void send(String string, JsonNode jsonNode) {
        Request request = new Request();
        request.setTaskName("SendToTopic");
        request.auth(this.request.getAuth());
        ObjectNode objectNode = request.createObject();
        objectNode.put("taskId", this.getId());
        objectNode.put("topicId", string);
        request.setEndPointId(this.nodeTransport.getOwnEndpointId());
        objectNode.set("message", jsonNode);
        request.setInput((JsonNode)objectNode);
        try {
            this.nodeTransport.execute(request.toBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (TransportException transportException) {
            transportException.printStackTrace();
        }
    }

    @Override
    public boolean isDone() {
        return !this.running;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public Response await() throws InterruptedException, ExecuteException {
        return this.await(this.request.getTimeOut(), this.request.getTimeUnit());
    }
}

