/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane.appbase.common;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import nl.sascom.backplanepublic.common.listeners.Listener;
import nl.sascom.backplanepublic.common.listeners.ListenerHandle;
import nl.sascom.backplanepublic.common.listeners.ListenerManager;

public class CodeGenerator {
    private final Map<Class<?>, Class<?>> interfaceToImplementation = new ConcurrentHashMap();
    private final Map<Class<?>, Class<?>> asyncInterfaceToImplementation = new ConcurrentHashMap();
    private final ClassPool classPool = ClassPool.getDefault();
    private final Set<ClassLoader> alreadyAddedClassLoaders = new HashSet<ClassLoader>();

    public Class<?> generateImplementation(Class<?> clazz) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        if (!this.alreadyAddedClassLoaders.contains(clazz.getClassLoader())) {
            this.alreadyAddedClassLoaders.add(clazz.getClassLoader());
            this.classPool.appendClassPath((ClassPath)new LoaderClassPath(clazz.getClassLoader()));
        }
        CtClass ctClass = this.classPool.makeClass(clazz.getName() + "Impl");
        CtClass ctClass2 = this.classPool.get(clazz.getName());
        ctClass.addInterface(ctClass2);
        CtClass ctClass3 = this.classPool.get(ListenerManager.class.getName());
        CtField ctField = new CtField(ctClass3, "listenerManager", ctClass);
        ctClass.addField(ctField);
        CtMethod[] ctMethodArray = new CtConstructor(new CtClass[]{ctClass3}, ctClass);
        StringBuilder stringBuilder = new StringBuilder();
        ctClass.addConstructor((CtConstructor)ctMethodArray);
        stringBuilder.append("{");
        stringBuilder.append("this.listenerManager = $1;");
        stringBuilder.append("}");
        ctMethodArray.setBody(stringBuilder.toString());
        for (CtMethod ctMethod : ctClass2.getMethods()) {
            if (ctMethod.getDeclaringClass() != ctClass2) continue;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("{\n");
            stringBuilder2.append("\tjava.util.Iterator iterator = this.listenerManager.listenerIterator(" + ctClass2.getName() + ".class);\n");
            stringBuilder2.append("\tif (iterator == null) return;\n");
            stringBuilder2.append("\twhile (iterator.hasNext()) {\n");
            stringBuilder2.append("\t\t" + ListenerHandle.class.getName() + " listenerHandle = (" + ListenerHandle.class.getName() + ")iterator.next();\n");
            stringBuilder2.append("\t\tif (listenerHandle.filter(" + this.generateDollars(ctMethod, true) + ")){\n");
            stringBuilder2.append("\t\t" + ctClass2.getName() + " listener = (" + ctClass2.getName() + ")listenerHandle.getListener();\n");
            stringBuilder2.append("\t\tlistener." + ctMethod.getName() + "(");
            stringBuilder2.append(this.generateDollars(ctMethod, false));
            stringBuilder2.append(");\n");
            stringBuilder2.append("\t\t\n}");
            stringBuilder2.append("\t}\n");
            stringBuilder2.append("}");
            CtMethod ctMethod2 = new CtMethod(ctMethod.getReturnType(), ctMethod.getName(), ctMethod.getParameterTypes(), ctClass);
            ctMethod2.setBody(stringBuilder2.toString());
            ctClass.addMethod(ctMethod2);
        }
        return this.classPool.toClass(ctClass, clazz, this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
    }

    public Class<?> generateAsyncImplementation(Class<?> clazz) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        if (!this.alreadyAddedClassLoaders.contains(clazz.getClassLoader())) {
            this.alreadyAddedClassLoaders.add(clazz.getClassLoader());
            this.classPool.appendClassPath((ClassPath)new LoaderClassPath(clazz.getClassLoader()));
        }
        CtClass ctClass = this.classPool.makeClass(clazz.getName() + "AsyncImpl");
        CtClass ctClass2 = this.classPool.get(clazz.getName());
        ctClass.addInterface(ctClass2);
        CtClass ctClass3 = this.classPool.get(ListenerManager.class.getName());
        CtField ctField = new CtField(ctClass3, "listenerManager", ctClass);
        ctClass.addField(ctField);
        CtMethod[] ctMethodArray = new CtConstructor(new CtClass[]{ctClass3}, ctClass);
        StringBuilder stringBuilder = new StringBuilder();
        ctClass.addConstructor((CtConstructor)ctMethodArray);
        stringBuilder.append("{");
        stringBuilder.append("this.listenerManager = $1;");
        stringBuilder.append("}");
        ctMethodArray.setBody(stringBuilder.toString());
        for (CtMethod ctMethod : ctClass2.getMethods()) {
            if (ctMethod.getDeclaringClass() != ctClass2) continue;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("{\n");
            stringBuilder2.append("\tjava.util.Iterator iterator = this.listenerManager.listenerIterator(" + ctClass2.getName() + ".class);\n");
            stringBuilder2.append("\tif (iterator == null) return;\n");
            stringBuilder2.append("\twhile (iterator.hasNext()) {\n");
            stringBuilder2.append("\t\t" + ListenerHandle.class.getName() + " listenerHandle = (" + ListenerHandle.class.getName() + ")iterator.next();\n");
            stringBuilder2.append("\t\tif (listenerHandle.filter(" + this.generateDollars(ctMethod, true) + ")){\n");
            stringBuilder2.append("\t\t\t" + ctClass2.getName() + " listener = (" + ctClass2.getName() + ")listenerHandle.getListener();\n");
            stringBuilder2.append("\t\t\tthis.listenerManager.dispatch(new Runnable(){ public void run(){\n");
            stringBuilder2.append("\t\t\t\tlistener." + ctMethod.getName() + "(");
            stringBuilder2.append(this.generateDollars(ctMethod, false));
            stringBuilder2.append(");\n");
            stringBuilder2.append("\t\t\t}\n");
            stringBuilder2.append("\t\t});\n");
            stringBuilder2.append("\t\t\n}");
            stringBuilder2.append("\t}\n");
            stringBuilder2.append("}");
            System.out.println(stringBuilder2.toString());
            CtMethod ctMethod2 = new CtMethod(ctMethod.getReturnType(), ctMethod.getName(), ctMethod.getParameterTypes(), ctClass);
            ctMethod2.setBody(stringBuilder2.toString());
            ctClass.addMethod(ctMethod2);
        }
        return this.classPool.toClass(ctClass, clazz, this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
    }

    private String generateDollars(CtMethod ctMethod, boolean bl) throws NotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= ctMethod.getParameterTypes().length; ++i) {
            CtClass ctClass = ctMethod.getParameterTypes()[i - 1];
            if (ctClass.isPrimitive() && bl) {
                if (ctClass.getName().equals("long")) {
                    stringBuilder.append("Long.valueOf($" + i + ")");
                } else if (ctClass.getName().equals("boolean")) {
                    stringBuilder.append("Boolean.valueOf($" + i + ")");
                } else if (ctClass.getName().equals("int")) {
                    stringBuilder.append("Integer.valueOf($" + i + ")");
                } else {
                    stringBuilder.append("$" + i);
                }
            } else {
                stringBuilder.append("$" + i);
            }
            if (i == ctMethod.getParameterTypes().length) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Listener> T createImplementation(ListenerManager listenerManager, Class<T> clazz) throws ClassNotFoundException, NotFoundException, CannotCompileException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> clazz2 = this.interfaceToImplementation.get(clazz);
        if (clazz2 == null) {
            CodeGenerator codeGenerator = this;
            synchronized (codeGenerator) {
                clazz2 = this.interfaceToImplementation.get(clazz);
                if (clazz2 == null) {
                    clazz2 = this.generateImplementation(clazz);
                    this.interfaceToImplementation.put(clazz, clazz2);
                }
            }
        }
        return (T)((Listener)clazz2.getConstructor(ListenerManager.class).newInstance(listenerManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Listener> T createAsyncImplementation(ListenerManager listenerManager, Class<T> clazz) throws ClassNotFoundException, NotFoundException, CannotCompileException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> clazz2 = this.asyncInterfaceToImplementation.get(clazz);
        if (clazz2 == null) {
            CodeGenerator codeGenerator = this;
            synchronized (codeGenerator) {
                clazz2 = this.asyncInterfaceToImplementation.get(clazz);
                if (clazz2 == null) {
                    clazz2 = this.generateAsyncImplementation(clazz);
                    this.asyncInterfaceToImplementation.put(clazz, clazz2);
                }
            }
        }
        return (T)((Listener)clazz2.getConstructor(ListenerManager.class).newInstance(listenerManager));
    }
}

