/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import nl.sascom.backplane.Resource;
import nl.sascom.backplane.ResourceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggingResourceTracker
implements ResourceTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggingResourceTracker.class);
    private final Map<Class<?>, Map<Resource, StackTraceElement[]>> map = new HashMap();

    public DebuggingResourceTracker() {
        new Timer().scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<Class<?>, Map<Resource, StackTraceElement[]>> map = DebuggingResourceTracker.this.map;
                synchronized (map) {
                    for (Map.Entry<Class<?>, Map<Resource, StackTraceElement[]>> entry : DebuggingResourceTracker.this.map.entrySet()) {
                        Map<Resource, StackTraceElement[]> map2 = entry.getValue();
                        for (Map.Entry<Resource, StackTraceElement[]> entry2 : map2.entrySet()) {
                            Resource resource = entry2.getKey();
                            LOGGER.info(resource.getInterfaceClass().getName() + ", " + resource.getObject().getClass().getName());
                            for (StackTraceElement stackTraceElement : entry2.getValue()) {
                                LOGGER.info("\tat " + stackTraceElement);
                            }
                        }
                    }
                }
            }
        }, 0L, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void track(Resource resource) {
        Map<Class<?>, Map<Resource, StackTraceElement[]>> map = this.map;
        synchronized (map) {
            Map<Resource, StackTraceElement[]> map2 = this.map.get(resource.getInterfaceClass());
            if (map2 == null) {
                map2 = new HashMap<Resource, StackTraceElement[]>();
                this.map.put(resource.getInterfaceClass(), map2);
            }
            map2.put(resource, new Exception().getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void untrack(Resource resource) {
        Map<Class<?>, Map<Resource, StackTraceElement[]>> map = this.map;
        synchronized (map) {
            Map<Resource, StackTraceElement[]> map2 = this.map.get(resource.getInterfaceClass());
            map2.remove(resource);
        }
    }
}

