package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;

import nl.sascom.backplanepublic.common.Response;

public class CalculatedValueQuery implements Comparable<CalculatedValueQuery>, CompareQuery {

	private String[] path;
	private Operator operator;
	private JsonNode value;

	public CalculatedValueQuery(String[] path, Operator operator, JsonNode value) {
		this.path = path;
		this.operator = operator;
		this.value = value;
	}

	public CalculatedValueQuery(String[] path) {
		this.path = path;
		this.operator = Operator.EXISTS;
	}
	
	public String[] getPath() {
		return path;
	}
	
	public ObjectNode toJson() {
		ObjectNode objectNode = Response.createObject();
		objectNode.put("name", Joiner.on(".").join(path));
		objectNode.set("operator", operator.toJson());
		if (value != null) {
			objectNode.set("value", value);
		}
		return objectNode;
	}
	
	public Operator getOperator() {
		return operator;
	}
	
	@Override
	public JsonNode getValue() {
		return value;
	}

	public String getName() {
		return Joiner.on(".").join(path);
	}
	
	@Override
	public int compareTo(CalculatedValueQuery o) {
		// TODO must be perfect
		return this.getName().compareTo(o.getName());
	}

	public String getFullFieldName() {
		return Joiner.on(".").join(path);
	}
}