/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.timing;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.sascom.backplanepublic.common.processinginfo.Alignment;
import nl.sascom.backplanepublic.common.processinginfo.ConsoleTable;
import nl.sascom.backplanepublic.common.utils.Formatters;
import org.slf4j.Logger;

public class NewTiming {
    private final String name;
    private final NewTiming parent;
    private final int level;
    private LocalDateTime start;
    private LocalDateTime end;
    private Map<String, NewTiming> children;
    private String[] columns;

    public NewTiming(String string) {
        this(null, string);
    }

    public NewTiming(NewTiming newTiming, String string) {
        this.parent = newTiming;
        this.name = string;
        this.level = newTiming == null ? 0 : newTiming.getLevel() + 1;
    }

    public void start() {
        this.start = LocalDateTime.now(ZoneOffset.UTC);
    }

    public void end(String ... stringArray) {
        this.end = LocalDateTime.now(ZoneOffset.UTC);
        if (this.columns != null) {
            int n;
            String[] stringArray2 = this.columns;
            this.columns = new String[stringArray2.length + stringArray.length];
            for (n = 0; n < stringArray2.length; ++n) {
                this.columns[n] = stringArray2[n];
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.columns[stringArray2.length + n] = stringArray[n];
            }
        } else {
            this.columns = stringArray;
        }
    }

    public String toString() {
        ConsoleTable consoleTable = new ConsoleTable();
        consoleTable.setAlignment(1, Alignment.RIGHT);
        this.dump(consoleTable);
        return consoleTable.toString();
    }

    private void dump(ConsoleTable consoleTable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.level; ++i) {
            stringBuilder.append("  ");
        }
        stringBuilder.append(this.name);
        String[] stringArray = new String[2 + (this.columns == null ? 0 : this.columns.length)];
        stringArray[0] = stringBuilder.toString();
        stringArray[1] = Formatters.formatThousands(this.getTotalMillis()) + " ms";
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                stringArray[2 + i] = this.columns[i];
            }
        }
        consoleTable.add(stringArray);
        if (this.children != null) {
            for (NewTiming newTiming : this.children.values()) {
                newTiming.dump(consoleTable);
            }
        }
    }

    public long getTotalMillis() {
        if (this.end == null) {
            return -1L;
        }
        return ChronoUnit.MILLIS.between(this.start, this.end);
    }

    public void dumpTo(Logger logger) {
        logger.debug("\n" + this.toString());
    }

    public NewTiming getParent() {
        return this.parent;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public synchronized NewTiming createAndStartChild(String string) {
        NewTiming newTiming = new NewTiming(this, string);
        if (this.children == null) {
            this.children = new LinkedHashMap<String, NewTiming>();
        }
        this.children.put(string, newTiming);
        newTiming.start();
        return newTiming;
    }

    public void setData(String ... stringArray) {
        this.columns = stringArray;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }
}

