/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.utils;

import com.google.common.base.Charsets;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class BinaryUtils {
    public static String readString(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray, Charsets.UTF_8);
    }

    public static ByteBuffer toByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public static int readInt(SeekableByteChannel seekableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        BinaryUtils.readFully(seekableByteChannel, byteBuffer);
        return byteBuffer.getInt(0);
    }

    public static void readFully(SeekableByteChannel seekableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n = seekableByteChannel.read(byteBuffer);
        while (n != -1 && byteBuffer.position() < byteBuffer.limit()) {
            n = seekableByteChannel.read(byteBuffer);
        }
    }

    public static void readFully(FileChannel fileChannel, long l, ByteBuffer byteBuffer) throws IOException {
        int n = fileChannel.read(byteBuffer, l);
        while (n != -1 && byteBuffer.position() < byteBuffer.limit()) {
            n = fileChannel.read(byteBuffer, l + (long)byteBuffer.position());
        }
    }

    public static void writeInt(SeekableByteChannel seekableByteChannel, int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        byteBuffer.position(0);
        int n2 = seekableByteChannel.write(byteBuffer);
        while (n2 != -1 && byteBuffer.position() < byteBuffer.limit()) {
            seekableByteChannel.write(byteBuffer);
        }
    }

    public static void writeFully(SeekableByteChannel seekableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n = seekableByteChannel.write(byteBuffer);
        while (n != -1 && byteBuffer.position() < byteBuffer.limit()) {
            n = seekableByteChannel.write(byteBuffer);
        }
    }

    public static int putString(ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        return byArray.length + 4;
    }

    public static int putStringShort(ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuffer.putShort((short)byArray.length);
        byteBuffer.put(byArray);
        return byArray.length + 2;
    }

    public static int putStringWithoutSize(ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuffer.put(byArray);
        return byArray.length;
    }

    public static long getLong(SeekableByteChannel seekableByteChannel, long l) throws IOException {
        seekableByteChannel.position(l);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        BinaryUtils.readFully(seekableByteChannel, byteBuffer);
        return byteBuffer.getLong(0);
    }

    public static long getLong(SeekableByteChannel seekableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        BinaryUtils.readFully(seekableByteChannel, byteBuffer);
        return byteBuffer.getLong(0);
    }

    public static int getInt(FileChannel fileChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        BinaryUtils.readFully(fileChannel, byteBuffer);
        return byteBuffer.getInt(0);
    }

    public static int readInt(SeekableByteChannel seekableByteChannel, int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        seekableByteChannel.position(n);
        BinaryUtils.readFully(seekableByteChannel, byteBuffer);
        return byteBuffer.getInt(0);
    }

    public static void writeXBytes(ByteBuffer byteBuffer, int n, byte by) {
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            byteBuffer.put(UnsignedBytes.checkedCast((long)(n >> by2 * 8 & 0xFF)));
        }
    }

    public static void writeXBytes(byte[] byArray, int n, int n2, byte by) {
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            byArray[n + by2] = UnsignedBytes.checkedCast((long)(n2 >> by2 * 8 & 0xFF));
        }
    }

    public static void putUuid(UUID uUID, ByteBuffer byteBuffer) {
        byteBuffer.putLong(uUID.getMostSignificantBits());
        byteBuffer.putLong(uUID.getLeastSignificantBits());
    }

    public static UUID getUuid(ByteBuffer byteBuffer) {
        return new UUID(byteBuffer.getLong(), byteBuffer.getLong());
    }

    public static int putStringWithoutSize(int n, ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuffer.position(n);
        byteBuffer.put(byArray);
        return byArray.length;
    }

    public static ByteBuffer copyDirectBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.limit()).order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        byteBuffer2.put(byArray);
        byteBuffer2.position(0);
        return byteBuffer2;
    }

    public static long writeFully(ByteBuffer byteBuffer, Path path) throws IOException {
        byteBuffer.position(0);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            fileChannel.write(byteBuffer);
        }
        return byteBuffer.limit();
    }

    public static void writeString(SeekableByteChannel seekableByteChannel, String string) throws IOException {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        int n = seekableByteChannel.write(byteBuffer);
        while (n != -1 && byteBuffer.position() != byteBuffer.limit()) {
            seekableByteChannel.write(byteBuffer);
        }
    }

    public static String readString(SeekableByteChannel seekableByteChannel) throws IOException {
        int n = BinaryUtils.readInt(seekableByteChannel);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        BinaryUtils.readFully(seekableByteChannel, byteBuffer);
        return new String(byteBuffer.array(), Charsets.UTF_8);
    }

    public static ByteBuffer toByteBuffer(String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public static ByteBuffer toByteBufferAligned4(String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        return byteBuffer.position(0);
    }

    public static ByteBuffer toDirectBuffer(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray);
        return byteBuffer;
    }

    public static ByteBuffer slice(ByteBuffer byteBuffer, int n, int n2) {
        return byteBuffer.duplicate().limit(n + n2).position(n).slice().order(ByteOrder.LITTLE_ENDIAN);
    }

    public static void writeFully(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        if (byteBuffer.hasArray()) {
            outputStream.write(byteBuffer.array());
        } else {
            byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
            byteBuffer.get(byArray);
            outputStream.write(byArray);
        }
    }

    public static void putInt(int n, SeekableByteChannel seekableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        byteBuffer.position(0);
        seekableByteChannel.write(byteBuffer);
    }

    public static int getInt(SeekableByteChannel seekableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        int n = seekableByteChannel.read(byteBuffer);
        while (n != -1 && byteBuffer.position() != byteBuffer.limit()) {
            n = seekableByteChannel.read(byteBuffer);
        }
        return byteBuffer.position(0).getInt();
    }

    public static ByteBuffer toDirectBuffer(long l, InputStream inputStream) throws IOException {
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("2GB limit exceeded with " + l);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)l);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        IOUtils.readFully((ReadableByteChannel)readableByteChannel, (ByteBuffer)byteBuffer);
        return byteBuffer;
    }

    public static boolean equals(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer.limit() - byteBuffer.position() != byteBuffer2.limit() - byteBuffer2.position()) {
            return false;
        }
        int n = byteBuffer.limit() - byteBuffer.position();
        for (int i = 0; i < n; ++i) {
            byte by;
            byte by2 = byteBuffer.get();
            if (by2 == (by = byteBuffer2.get())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            byte by;
            byte by2 = byteBuffer.get(i);
            if (by2 == (by = byteBuffer2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void fillWithRandom(ByteBuffer byteBuffer) {
        Random random = new Random();
        for (int i = byteBuffer.position(); i < byteBuffer.limit(); ++i) {
            byteBuffer.put((byte)random.nextInt());
        }
    }

    public static byte[] intToBytes(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        return byteBuffer.array();
    }

    public static ByteBuffer randomByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            byteBuffer.put((byte)random.nextInt());
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    public static int bytesToInt(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt();
    }
}

