/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.io.ByteSource;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import nl.sascom.backplanepublic.common.Stream;
import nl.sascom.backplanepublic.common.StreamManager;
import nl.sascom.backplanepublic.common.StreamMetaData;
import nl.sascom.backplanepublic.common.StreamReadingByteSource;
import nl.sascom.backplanepublic.common.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketStream
implements Stream,
Closeable,
StreamSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketStream.class);
    private long start;
    private RandomAccessFile randomAccessFile;
    private volatile long writePosition = 0L;
    private volatile int lastWriteSequence = -1;
    private volatile long totalBytes;
    private volatile boolean writingDone;
    private Path path;
    private String key;
    private StreamMetaData streamMetaData;
    private final Set<CountDownLatch> writeLatches = new HashSet<CountDownLatch>();
    private volatile boolean isOpen = true;
    private static volatile int closed;

    public WebSocketStream(StreamManager streamManager, String string, StreamMetaData streamMetaData) {
        this.key = string;
        this.streamMetaData = streamMetaData;
        this.path = streamManager.getPath().resolve(this.getKey());
        try {
            this.randomAccessFile = new RandomAccessFile(this.path.toFile(), "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        this.start = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n, ByteBuffer byteBuffer, int n2, int n3) {
        try {
            if (n != this.lastWriteSequence + 1) {
                throw new IOException("Unexpected sequence ID (got " + n + ", expected " + (this.lastWriteSequence + 1) + ")");
            }
            WebSocketStream webSocketStream = this;
            synchronized (webSocketStream) {
                this.randomAccessFile.seek(this.writePosition);
                this.randomAccessFile.write(byteBuffer.array(), n2, n3);
                this.writePosition += (long)n3;
                if (n3 > 0) {
                    Set<CountDownLatch> set = this.writeLatches;
                    synchronized (set) {
                        for (CountDownLatch countDownLatch : this.writeLatches) {
                            countDownLatch.countDown();
                        }
                    }
                }
            }
            ++this.lastWriteSequence;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public ByteSource getByteSource() {
        return new StreamReadingByteSource(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        LOGGER.info("Closed WSS: " + ++closed);
        this.isOpen = false;
        Set<CountDownLatch> set = this.writeLatches;
        synchronized (set) {
            for (CountDownLatch countDownLatch : this.writeLatches) {
                countDownLatch.countDown();
            }
        }
        this.randomAccessFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writingDone(int n) throws IOException {
        this.totalBytes = this.writePosition;
        this.writingDone = true;
        Object object = this;
        synchronized (object) {
            this.randomAccessFile.close();
            this.randomAccessFile = new RandomAccessFile(this.path.toFile(), "r");
        }
        if (n != this.lastWriteSequence + 1) {
            throw new IOException("Unexpected sequence ID (got " + n + ", expected " + (this.lastWriteSequence + 1) + ")");
        }
        object = this.writeLatches;
        synchronized (object) {
            for (CountDownLatch countDownLatch : this.writeLatches) {
                countDownLatch.countDown();
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public StreamMetaData getStreamMetaData() {
        return this.streamMetaData;
    }

    public void writeNull(int n) {
        ++this.lastWriteSequence;
    }

    @Override
    public long getWritePosition() {
        return this.writePosition;
    }

    @Override
    public boolean writingIsDone() {
        return this.writingDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWriteLatch(CountDownLatch countDownLatch, long l) {
        if (!this.isOpen) {
            countDownLatch.countDown();
            return;
        }
        Set<CountDownLatch> set = this.writeLatches;
        synchronized (set) {
            this.writeLatches.add(countDownLatch);
        }
        if (l != this.writePosition || this.writingDone) {
            countDownLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterWriteLatch(CountDownLatch countDownLatch) {
        Set<CountDownLatch> set = this.writeLatches;
        synchronized (set) {
            this.writeLatches.remove(countDownLatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long l, byte[] byArray, int n, int n2) throws IOException {
        WebSocketStream webSocketStream = this;
        synchronized (webSocketStream) {
            this.randomAccessFile.seek(l);
            return this.randomAccessFile.read(byArray, n, n2);
        }
    }
}

