/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import nl.sascom.backplanepublic.common.LocalStreamDescriptor;
import nl.sascom.backplanepublic.common.PresignedMinioStreamDescriptor;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.Stream;

public abstract class StreamDescriptor
implements Stream {
    private String key;
    private LocalDateTime validUntil;

    public StreamDescriptor(String string) {
        this.key = string;
        this.validUntil = LocalDateTime.now(ZoneOffset.UTC).plus(1L, ChronoUnit.MONTHS);
    }

    public StreamDescriptor(String string, LocalDateTime localDateTime) {
        this.key = string;
        this.validUntil = localDateTime;
    }

    public LocalDateTime getValidUntil() {
        return this.validUntil;
    }

    public ObjectNode toJson() {
        ObjectNode objectNode = Response.createObject();
        objectNode.put("key", this.key);
        return objectNode;
    }

    public static StreamDescriptor fromJson(ObjectNode objectNode) {
        String string = objectNode.get("type").asText();
        String string2 = objectNode.get("key").asText();
        if (string.equals("local")) {
            return LocalStreamDescriptor.fromJson(objectNode);
        }
        if (string.equals("minio")) {
            return new PresignedMinioStreamDescriptor(string2, objectNode.get("url").asText(), objectNode.get("expiresSeconds").asInt());
        }
        return null;
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

