/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import nl.sascom.backplanepublic.common.CommonErrorCode;
import nl.sascom.backplanepublic.common.EndPointId;
import nl.sascom.backplanepublic.common.ErrorCode;
import nl.sascom.backplanepublic.common.InvalidFieldValueException;
import nl.sascom.backplanepublic.common.MissingFieldException;
import nl.sascom.backplanepublic.common.Registration;
import nl.sascom.backplanepublic.common.RequestValidationException;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.Session;
import nl.sascom.backplanepublic.common.TaskIdentifier;
import nl.sascom.backplanepublic.common.Validation;
import nl.sascom.backplanepublic.common.library.InvalidEndPointException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request {
    private static final Logger LOGGER = LoggerFactory.getLogger(Request.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private TaskIdentifier taskIdentifier = new TaskIdentifier();
    private String username;
    private String requestTemplateId;
    private String id;
    private ObjectNode auth;
    private JsonNode input;
    private long submitMillis = -1L;
    private boolean sync;
    private String remoteAddr;
    private Set<String> attachedStreams = new HashSet<String>();
    private Registration autoRegisterResponseTypes;
    private String groupId;
    private long timeOut = 10L;
    private TimeUnit timeUnit = TimeUnit.MINUTES;
    private String virtualHost;
    private EndPointId endPointId;
    private boolean debug;
    private Object httpRequest;
    private UUID nodeUuid;

    public Request() {
        this.id = UUID.randomUUID().toString();
    }

    public Request(JsonNode jsonNode) {
        this.initFromJson(jsonNode);
    }

    private void initFromJson(JsonNode jsonNode) {
        ObjectNode objectNode;
        ObjectNode objectNode2 = (ObjectNode)jsonNode.get("payload");
        this.taskIdentifier = TaskIdentifier.from((ObjectNode)objectNode2.get("task"));
        if (jsonNode.has("id")) {
            this.id = jsonNode.get("id").asText();
        }
        if (jsonNode.has("endPointId")) {
            try {
                this.endPointId = EndPointId.fromString(jsonNode.get("endPointId").asText());
            }
            catch (InvalidEndPointException invalidEndPointException) {
                LOGGER.info("", (Throwable)invalidEndPointException);
            }
        }
        if (jsonNode.has("auth")) {
            this.auth = (ObjectNode)jsonNode.get("auth");
            if (this.auth.has("input") && this.auth.get("input").has("payload") && this.auth.get("input").get("payload").has("username")) {
                this.username = this.auth.get("input").get("payload").get("username").asText();
            }
        }
        if (jsonNode.has("autoRegisterResponseTypes") && (objectNode = (ObjectNode)jsonNode.get("autoRegisterResponseTypes")).size() > 0) {
            this.autoRegisterResponseTypes = new Registration(objectNode);
        }
        if (jsonNode.has("virtualHost")) {
            this.virtualHost = jsonNode.get("virtualHost").asText();
        }
        if (objectNode2.has("input")) {
            this.input = objectNode2.get("input");
        }
        if (jsonNode.has("requestTemplateId")) {
            this.requestTemplateId = jsonNode.get("requestTemplateId").asText();
        }
        if (jsonNode.has("submitMillis")) {
            this.submitMillis = jsonNode.get("submitMillis").asLong();
        }
        if (jsonNode.has("timeOut")) {
            this.timeOut = jsonNode.get("timeOut").asLong();
        }
        if (jsonNode.has("timeUnit")) {
            this.timeUnit = TimeUnit.valueOf(jsonNode.get("timeUnit").asText());
        }
        if (jsonNode.has("remoteAddr")) {
            this.remoteAddr = jsonNode.get("remoteAddr").asText();
        }
        if (jsonNode.has("streams")) {
            objectNode = (ArrayNode)jsonNode.get("streams");
            for (JsonNode jsonNode2 : objectNode) {
                this.attachedStreams.add(jsonNode2.asText());
            }
        }
        boolean bl = this.sync = jsonNode.has("sync") && jsonNode.get("sync").asBoolean();
        if (jsonNode.has("nodeUuid")) {
            this.nodeUuid = UUID.fromString(jsonNode.get("nodeUuid").asText());
        }
        if (jsonNode.has("groupId")) {
            this.groupId = jsonNode.get("groupId").asText();
        }
    }

    public Request(String string) {
        this.taskIdentifier = new TaskIdentifier(string);
        this.id = UUID.randomUUID().toString();
    }

    public static Request fromId(String string) {
        Request request = new Request();
        request.setId(string);
        return request;
    }

    public Request(byte[] byArray) {
        try {
            ObjectNode objectNode = (ObjectNode)OBJECT_MAPPER.readValue(byArray, ObjectNode.class);
            this.initFromJson((JsonNode)objectNode);
        }
        catch (JsonParseException jsonParseException) {
            LOGGER.error("", (Throwable)jsonParseException);
        }
        catch (JsonMappingException jsonMappingException) {
            LOGGER.error("", (Throwable)jsonMappingException);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
    }

    public Request(String string, String string2) {
        this.taskIdentifier = new TaskIdentifier(string2);
        this.taskIdentifier.setProjectName(string);
    }

    public ObjectNode toJson() {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        ObjectNode objectNode2 = OBJECT_MAPPER.createObjectNode();
        objectNode.set("payload", (JsonNode)objectNode2);
        objectNode2.set("task", (JsonNode)this.taskIdentifier.toJson());
        if (this.requestTemplateId != null) {
            objectNode.put("requestTemplateId", this.requestTemplateId);
        }
        objectNode2.set("input", this.input);
        objectNode.put("sync", this.sync);
        objectNode.put("id", this.id);
        objectNode.put("remoteAddr", this.remoteAddr);
        if (this.timeUnit != null) {
            objectNode.put("timeOut", this.timeOut);
            objectNode.put("timeUnit", this.timeUnit.name());
        }
        objectNode.put("submitMillis", this.submitMillis);
        if (this.auth != null) {
            objectNode.set("auth", (JsonNode)this.auth);
        }
        if (this.endPointId != null) {
            objectNode.put("endPointId", this.endPointId.getSpecifiedId());
        }
        if (!this.attachedStreams.isEmpty()) {
            ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
            objectNode.set("streams", (JsonNode)arrayNode);
            for (String string : this.attachedStreams) {
                arrayNode.add(string);
            }
        }
        if (this.autoRegisterResponseTypes != null) {
            objectNode.set("autoRegisterResponseTypes", this.autoRegisterResponseTypes.toJson());
        }
        if (this.nodeUuid != null) {
            objectNode.put("nodeUuid", this.nodeUuid.toString());
        }
        if (this.virtualHost != null) {
            objectNode.put("virtualHost", this.virtualHost);
        }
        if (this.groupId != null) {
            objectNode.put("groupId", this.groupId);
        }
        return objectNode;
    }

    public String getId() {
        return this.id;
    }

    public String getShortId() {
        return this.id.substring(0, this.id.indexOf("-"));
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getToken() {
        return this.hasAuth() && this.getAuth().hasNonNull("hmac") ? this.getAuth().get("hmac").asText() : null;
    }

    public Session getSession() {
        String string = "unknown";
        if (this.getAuth() != null && this.getAuth().get("input") != null && this.getAuth().get("input").get("username") != null) {
            string = this.getAuth().get("input").get("username").asText();
        }
        return new Session(this.getToken(), string);
    }

    public UUID getNodeUuid() {
        return this.nodeUuid;
    }

    public Request setNodeUuid(UUID uUID) {
        this.nodeUuid = uUID;
        return this;
    }

    public JsonNode getInput() {
        if (this.input == null) {
            this.input = this.createObject();
        }
        return this.input;
    }

    public ObjectNode getObjectInput() {
        if (this.input instanceof ObjectNode) {
            return (ObjectNode)this.input;
        }
        this.input = OBJECT_MAPPER.createObjectNode();
        return (ObjectNode)this.input;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Request request = (Request)object;
        return !(this.id == null ? request.id != null : !this.id.equals(request.id));
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public ObjectNode getAuth() {
        return this.auth;
    }

    public void setSync(boolean bl) {
        this.sync = bl;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void generateId() {
        this.id = UUID.randomUUID().toString();
    }

    public Request auth(ObjectNode objectNode) {
        this.auth = objectNode;
        return this;
    }

    public ObjectNode createObject() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public void setInput(JsonNode jsonNode) {
        this.input = jsonNode;
    }

    public String getRequestTemplateId() {
        return this.requestTemplateId;
    }

    public void setRequestTemplateId(String string) {
        this.requestTemplateId = string;
    }

    public void setRemoteAddress(String string) {
        this.remoteAddr = string;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public ArrayNode createArray() {
        return OBJECT_MAPPER.createArrayNode();
    }

    public Request attachStream(String string) {
        this.attachedStreams.add(string);
        return this;
    }

    public Set<String> getAttachedStreams() {
        return this.attachedStreams;
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }

    public String getGroupdId() {
        return this.groupId;
    }

    public Request setTimeOut(long l, TimeUnit timeUnit) {
        this.timeOut = l;
        this.timeUnit = timeUnit;
        return this;
    }

    public void setSubmitMillis(long l) {
        this.submitMillis = l;
    }

    public long getSubmitMillis() {
        return this.submitMillis;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Request setTaskName(String string) {
        this.taskIdentifier.setTaskName(string);
        return this;
    }

    public Request setProject(String string) {
        this.taskIdentifier.setProjectName(string);
        return this;
    }

    public Request setBranch(String string) {
        this.taskIdentifier.setBranchName(string);
        return this;
    }

    public <T> T validateInput(String string, Validation validation) throws RequestValidationException {
        return this.validateInput(string, validation, true);
    }

    public <T extends Enum<T>> T validateEnum(String string, Class<T> clazz) throws RequestValidationException {
        if (!clazz.isEnum()) {
            throw new RequestValidationException((ErrorCode)CommonErrorCode.WRONG_ENUM, "Implementation error, wrong enum");
        }
        String string2 = this.getInput().get(string).asText();
        try {
            T t = Enum.valueOf(clazz, string2);
            return t;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RequestValidationException((ErrorCode)CommonErrorCode.INVALID_FIELD_VALUE, "Invalid value for " + clazz.getSimpleName());
        }
    }

    public <T> T validateInput(String string, Validation validation, boolean bl) throws RequestValidationException {
        ObjectNode objectNode = this.getObjectInput();
        if (bl && !objectNode.hasNonNull(string)) {
            throw new MissingFieldException(string);
        }
        if (!bl && objectNode.get(string).isNull()) {
            return null;
        }
        JsonNode jsonNode = objectNode.get(string);
        if (jsonNode.getNodeType() != validation.getNodeType()) {
            throw new InvalidFieldValueException(string, "Wrong node type, expected " + validation.getNodeType() + " but got " + jsonNode.getNodeType());
        }
        return (T)validation.validate(string, jsonNode);
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String string) {
        this.virtualHost = string;
    }

    public Registration getAutoRegisterResponseTypes() {
        return this.autoRegisterResponseTypes;
    }

    public String toString() {
        return "Request: " + this.taskIdentifier.toString();
    }

    public void setAutoRegisterResponseTypes(Registration registration) {
        this.autoRegisterResponseTypes = registration;
    }

    public static ObjectNode createObjectNode() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public void setEndPointId(EndPointId endPointId) {
        this.endPointId = endPointId;
    }

    public EndPointId getEndPointId() {
        return this.endPointId;
    }

    public byte[] toBytes() {
        ObjectNode objectNode = this.toJson();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            OBJECT_MAPPER.writeValue((OutputStream)byteArrayOutputStream, (Object)objectNode);
        }
        catch (JsonGenerationException jsonGenerationException) {
            jsonGenerationException.printStackTrace();
        }
        catch (JsonMappingException jsonMappingException) {
            jsonMappingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Request put(String string, String string2) {
        this.getObjectInput().put(string, string2);
        return this;
    }

    public Request put(String string, UUID uUID) {
        this.getObjectInput().put(string, uUID.toString());
        return this;
    }

    public Request put(String string, Long l) {
        this.getObjectInput().put(string, l);
        return this;
    }

    public <T extends Enum<T>> T validateEnum(Class<T> clazz) throws RequestValidationException {
        if (!clazz.isEnum()) {
            throw new RequestValidationException((ErrorCode)CommonErrorCode.WRONG_ENUM, "Implementation error, wrong enum");
        }
        String string = this.getInput().asText();
        try {
            T t = Enum.valueOf(clazz, string);
            return t;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RequestValidationException((ErrorCode)CommonErrorCode.INVALID_FIELD_VALUE, "Invalid value for " + clazz.getSimpleName());
        }
    }

    public boolean hasInput() {
        return this.input != null;
    }

    public void set(String string, JsonNode jsonNode) {
        this.getObjectInput().set(string, jsonNode);
    }

    public boolean getBoolean(String string) {
        return this.getObjectInput().has(string) && this.getObjectInput().get(string).asBoolean();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setAuth(ObjectNode objectNode) {
        this.auth = objectNode;
    }

    public Request put(String string, boolean bl) {
        this.getObjectInput().put(string, bl);
        return this;
    }

    public TaskIdentifier getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public void setHttpServletRequest(Object object) {
        this.httpRequest = object;
    }

    public Object getHttpRequest() {
        return this.httpRequest;
    }

    public ObjectNode getPayload() {
        ObjectNode objectNode = Response.createObject();
        objectNode.set("task", (JsonNode)this.taskIdentifier.toJson());
        objectNode.set("input", this.getInput());
        return objectNode;
    }

    public UUID validateUuid(String string) throws RequestValidationException {
        if (this.getObjectInput().hasNonNull(string)) {
            return UUID.fromString(this.getObjectInput().get(string).asText());
        }
        throw new RequestValidationException((ErrorCode)CommonErrorCode.MISSING_FIELD, "Missing field " + string);
    }

    public void setTask(ObjectNode objectNode) {
        this.taskIdentifier = TaskIdentifier.from(objectNode);
    }

    public long validateLong(String string) throws RequestValidationException {
        JsonNode jsonNode = this.getObjectInput().get(string);
        if (jsonNode == null) {
            throw new RequestValidationException((ErrorCode)CommonErrorCode.MISSING_FIELD, "Missing field " + string);
        }
        return jsonNode.asLong();
    }

    public int validateInt(String string) throws RequestValidationException {
        JsonNode jsonNode = this.getObjectInput().get(string);
        if (jsonNode == null) {
            throw new RequestValidationException((ErrorCode)CommonErrorCode.MISSING_FIELD, "Missing field " + string);
        }
        return jsonNode.asInt();
    }

    public <T> T validateObject(String string, Class<T> clazz) throws RequestValidationException {
        ObjectNode objectNode = (ObjectNode)this.getObjectInput().get(string);
        if (objectNode == null || objectNode.isNull()) {
            throw new RequestValidationException((ErrorCode)CommonErrorCode.MISSING_FIELD, "Missing field " + string);
        }
        Object object = Response.OBJECT_MAPPER.convertValue((Object)objectNode, clazz);
        return (T)object;
    }

    public <T> T getInput(Class<T> clazz) {
        return (T)Response.OBJECT_MAPPER.convertValue((Object)this.getInput(), clazz);
    }
}

