/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nl.sascom.backplanepublic.common.CommonErrorCode;
import nl.sascom.backplanepublic.common.ErrorCode;
import nl.sascom.backplanepublic.common.GenericErrorCode;

public class ExecuteException
extends Exception {
    private static final long serialVersionUID = -1831510535956075829L;
    private String responseMessage;
    private ErrorCode errorCode;
    private String userSafeMessage;

    public ExecuteException(ObjectNode objectNode) {
        super(objectNode.get("message").asText());
        if (objectNode.has("domain_full")) {
            int n = objectNode.get("code").asInt();
            String string = objectNode.get("message").asText();
            try {
                String string2 = objectNode.get("domain_full").asText();
                Class<?> clazz = Class.forName(string2);
                Method method = clazz.getMethod("fromCode", Integer.TYPE);
                this.setErrorCode((ErrorCode)method.invoke(null, n));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.setErrorCode(new GenericErrorCode(n, string));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        } else {
            this.setErrorCode(CommonErrorCode.UNIMPLEMENTED_ERROR_CODE);
        }
        if (objectNode.has("userSafeMessage")) {
            this.userSafeMessage = objectNode.get("userSafeMessage").asText();
        }
    }

    public ExecuteException(ErrorCode errorCode) {
        super(errorCode.getMessage());
        this.setErrorCode(errorCode);
    }

    public ExecuteException(ErrorCode errorCode, Throwable throwable) {
        super(errorCode.getMessage(), throwable);
        throwable.printStackTrace();
        this.setErrorCode(errorCode);
    }

    public ExecuteException(ErrorCode errorCode, String string) {
        super(string);
        this.setErrorCode(errorCode);
        this.userSafeMessage = string;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    private void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String toString() {
        return super.toString() + (String)(this.responseMessage != null ? "\n" + this.responseMessage : "");
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getUserSafeMessage() {
        return this.userSafeMessage;
    }
}

