/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import nl.sascom.backplanepublic.client.AsyncTask;
import nl.sascom.backplanepublic.client.ClientErrorCode;
import nl.sascom.backplanepublic.client.HttpAsyncTransportHighLevel;
import nl.sascom.backplanepublic.client.auth.Auth;
import nl.sascom.backplanepublic.common.AsyncCallback;
import nl.sascom.backplanepublic.common.ClientNodeInterface;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.CommonErrorCode;
import nl.sascom.backplanepublic.common.ErrorCode;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.InputStreamStreamDescriptor;
import nl.sascom.backplanepublic.common.JsonUpdate;
import nl.sascom.backplanepublic.common.LightContainerInterface;
import nl.sascom.backplanepublic.common.NodeClientException;
import nl.sascom.backplanepublic.common.NodeTransport;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.RequestFactory;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.ResponseListener;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.RoutingException;
import nl.sascom.backplanepublic.common.StreamAlreadyRegisteredException;
import nl.sascom.backplanepublic.common.StreamDescriptor;
import nl.sascom.backplanepublic.common.StreamManager;
import nl.sascom.backplanepublic.common.UpdateInterface;
import nl.sascom.backplanepublic.common.UrlStreamDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeClient
implements AutoCloseable,
AsyncCallback,
RequestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeClient.class);
    private final Map<String, AsyncTask> asyncCalls = Collections.synchronizedMap(new HashMap());
    private NodeTransport nodeTransport;
    private LightContainerInterface node;
    private ObjectNode auth;
    private final LinkedBlockingQueue<Runnable> notificationQueue = new LinkedBlockingQueue();
    private volatile boolean closed = false;
    private final UUID nodeUuid;
    private Thread notificationProcessorThread;

    public NodeClient(UUID uUID) {
        this.nodeUuid = uUID;
    }

    public NodeClient(NodeTransport nodeTransport, UUID uUID, StreamManager streamManager) throws IOException {
        this(uUID);
        this.nodeTransport = nodeTransport;
        this.node = new ClientNodeInterface(streamManager){};
        nodeTransport.setAsyncCallback(this);
        this.start();
    }

    private void start() {
        this.notificationProcessorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (!NodeClient.this.closed) {
                            Runnable runnable = NodeClient.this.notificationQueue.take();
                            try {
                                runnable.run();
                                continue block4;
                            }
                            catch (Throwable throwable) {
                                LOGGER.error("", throwable);
                            }
                        }
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        if (NodeClient.this.closed) break;
                        LOGGER.error("", (Throwable)interruptedException);
                        break;
                    }
                }
            }
        });
        this.notificationProcessorThread.setName("NodeClient notification processor");
        this.notificationProcessorThread.start();
    }

    public NodeClient(NodeTransport nodeTransport, UUID uUID) throws IOException {
        this(uUID);
        this.nodeTransport = nodeTransport;
        this.node = new ClientNodeInterface(new StreamManager(Paths.get("streams", new String[0]))){};
        nodeTransport.setAsyncCallback(this);
        this.start();
    }

    public NodeClient(NodeTransport nodeTransport) throws IOException {
        this(nodeTransport, (UUID)null);
    }

    public NodeClient(NodeTransport nodeTransport, LightContainerInterface lightContainerInterface) throws IOException {
        this(lightContainerInterface.getNodeUuid());
        this.nodeTransport = nodeTransport;
        this.node = lightContainerInterface;
        nodeTransport.setAsyncCallback(this);
        this.start();
    }

    public NodeClient(String string) throws Exception {
        this(string, null, "unknown");
    }

    public ObjectNode getThisNodeInfo() throws ExecuteException {
        Request request = this.createRequest();
        request.setTaskName("GetThisNodeInfo");
        request.setTimeOut(10L, TimeUnit.SECONDS);
        ClientTask clientTask = this.createAsyncTask(request);
        clientTask.exec();
        try {
            Response response = clientTask.await(1L, TimeUnit.MINUTES);
            return response.getObjectOutput();
        }
        catch (InterruptedException interruptedException) {
            throw new ExecuteException(ClientErrorCode.INTERRUPTED);
        }
    }

    public NodeClient(String string, UUID uUID, String string2) throws Exception {
        this(uUID);
        this.node = new ClientNodeInterface(new StreamManager(Paths.get("streams", new String[0]))){};
        URI uRI = URI.create(string);
        HttpAsyncTransportHighLevel httpAsyncTransportHighLevel = new HttpAsyncTransportHighLevel(uRI.getScheme(), uRI.getHost(), uRI.getPort(), string2);
        this.nodeTransport = httpAsyncTransportHighLevel;
        httpAsyncTransportHighLevel.setAsyncCallback(this);
        httpAsyncTransportHighLevel.connect().get(5L, TimeUnit.SECONDS);
        this.start();
    }

    public NodeClient(LightContainerInterface lightContainerInterface, NodeTransport nodeTransport, UUID uUID) throws IOException {
        this.node = lightContainerInterface;
        this.nodeTransport = nodeTransport;
        this.nodeUuid = uUID;
        nodeTransport.setAsyncCallback(this);
        this.start();
    }

    @Override
    public void close() throws InterruptedException {
        this.closed = true;
        try {
            this.nodeTransport.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.notificationProcessorThread != null) {
            this.notificationProcessorThread.interrupt();
        }
        if (this.node instanceof ClientNodeInterface) {
            ((ClientNodeInterface)this.node).close();
        }
    }

    public Response executeSync(Request request) throws IOException, ExecuteException {
        return this.executeSync(request, 60L, TimeUnit.MINUTES);
    }

    public Response executeSync(Request request, long l, TimeUnit timeUnit) throws IOException, ExecuteException {
        request.setSync(true);
        request.setTimeOut(l, timeUnit);
        ClientTask clientTask = this.createAsyncTask(request);
        try {
            clientTask.addResponseListener(new ResponseListener(){

                @Override
                public void response(Response response) {
                }
            });
            clientTask.exec();
            Response response = clientTask.await(l, timeUnit);
            if (response.getErrorNode() != null) {
                throw new ExecuteException(response.getErrorNode());
            }
            return response;
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("", (Throwable)interruptedException);
            throw new ExecuteException((ErrorCode)CommonErrorCode.INTERRUPTED, (Throwable)interruptedException);
        }
    }

    public ClientTask createAsyncTask(Request request) {
        if (request.getTimeUnit() != null) {
            return this.createAsyncTask(request, request.getTimeOut(), request.getTimeUnit());
        }
        return this.createAsyncTask(request, 10L, TimeUnit.MINUTES);
    }

    public ClientTask createAsyncTask(Request request, long l, TimeUnit timeUnit) {
        request.setTimeOut(l, timeUnit);
        AsyncTask asyncTask = new AsyncTask(this.node, this.nodeTransport, request);
        this.asyncCalls.put(asyncTask.getId(), asyncTask);
        return asyncTask;
    }

    @Override
    public void newData(String string, ResponseType responseType, byte[] byArray) {
        UpdateInterface updateInterface = JsonUpdate.create(responseType, byArray);
        this.newData(updateInterface);
    }

    @Override
    public Request createRequest(ObjectNode objectNode) {
        Request request = new Request();
        request.setNodeUuid(this.nodeUuid);
        request.generateId();
        request.auth(objectNode);
        if (this.nodeTransport != null) {
            request.setEndPointId(this.nodeTransport.getOwnEndpointId());
        }
        return request;
    }

    @Override
    public Request newRequest() {
        Request request = new Request();
        request.setNodeUuid(this.nodeUuid);
        request.generateId();
        request.auth(this.auth);
        if (this.nodeTransport != null) {
            request.setEndPointId(this.nodeTransport.getOwnEndpointId());
        }
        return request;
    }

    @Override
    public Request newRequest(String string) {
        Request request = new Request();
        request.setNodeUuid(this.nodeUuid);
        request.setTaskName(string);
        request.generateId();
        request.auth(this.auth);
        if (this.nodeTransport != null) {
            request.setEndPointId(this.nodeTransport.getOwnEndpointId());
        }
        return request;
    }

    @Override
    public Request newRequest(String string, String string2) {
        Request request = new Request();
        request.setNodeUuid(this.nodeUuid);
        request.setProject(string);
        request.setTaskName(string2);
        request.generateId();
        request.auth(this.auth);
        if (this.nodeTransport != null) {
            request.setEndPointId(this.nodeTransport.getOwnEndpointId());
        }
        return request;
    }

    @Override
    public ClientTask create(Request request) throws RoutingException {
        return null;
    }

    public void autenticate(Auth auth) throws NodeClientException {
        auth.authenticate(this);
    }

    public void login(String string) throws NodeClientException {
        Request request = this.createRequest();
        request.setProject("Auth");
        request.setTaskName("LoginWithToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("token", string);
        request.setInput((JsonNode)objectNode);
        try {
            ObjectNode objectNode2;
            Response response = this.executeSync(request, 10L, TimeUnit.SECONDS);
            if (response.getOutput() == null || !response.getOutput().has("auth")) {
                throw new NodeClientException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
            }
            this.auth = objectNode2 = (ObjectNode)response.getOutput().get("auth");
            this.nodeTransport.connectAsync(objectNode2);
            LOGGER.info("Login successfull");
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
        catch (ExecuteException executeException) {
            throw new NodeClientException(executeException);
        }
    }

    public ObjectNode login(String string, String string2) throws NodeClientException {
        Request request = this.createRequest();
        request.setProject("BackplaneServer");
        request.setTaskName("Login");
        ObjectNode objectNode = request.createObject();
        objectNode.put("username", string);
        objectNode.put("password", string2);
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.executeSync(request, 10L, TimeUnit.SECONDS);
            if (response.getOutput() != null && response.getOutput().has("auth")) {
                ObjectNode objectNode2;
                this.auth = objectNode2 = (ObjectNode)response.getOutput().get("auth");
                this.nodeTransport.connectAsync(objectNode2);
                return this.auth;
            }
            throw new NodeClientException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
            return null;
        }
        catch (ExecuteException executeException) {
            throw new NodeClientException(executeException);
        }
    }

    public ObjectNode loginApp(String string, String string2) throws NodeClientException {
        Request request = this.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("LoginWithUsernamePassword");
        ObjectNode objectNode = request.createObject();
        objectNode.put("username", string);
        objectNode.put("password", string2);
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.executeSync(request, 10L, TimeUnit.SECONDS);
            if (response.getOutput() != null && response.getOutput().has("auth")) {
                ObjectNode objectNode2;
                this.auth = objectNode2 = (ObjectNode)response.getOutput().get("auth");
                this.nodeTransport.connectAsync(objectNode2);
                return this.auth;
            }
            throw new NodeClientException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
            return null;
        }
        catch (ExecuteException executeException) {
            throw new NodeClientException(executeException);
        }
    }

    public void setAuth(ObjectNode objectNode) {
        this.auth = objectNode;
    }

    public Request createRequest() {
        return this.createRequest(this.auth);
    }

    public void connectAsync(ObjectNode objectNode) {
        this.nodeTransport.connectAsync(objectNode);
    }

    public void registerStream(String string, ByteSource byteSource) throws IOException, StreamAlreadyRegisteredException {
        this.node.getStreamManager().registerStream(string, byteSource, null);
    }

    public String registerStream(ByteSource byteSource) throws IOException, StreamAlreadyRegisteredException {
        String string = UUID.randomUUID().toString();
        this.node.getStreamManager().registerStream(string, byteSource, null);
        return string;
    }

    public String registerStream(Path path) throws StreamAlreadyRegisteredException {
        String string = UUID.randomUUID().toString();
        this.node.getStreamManager().registerStream(string, path, null);
        return string;
    }

    public UUID getNodeUuid() {
        return this.nodeUuid;
    }

    public void newData(final UpdateInterface updateInterface) {
        if (this.closed) {
            return;
        }
        if (this.asyncCalls.containsKey(updateInterface.getId())) {
            this.notificationQueue.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        NodeClient.this.asyncCalls.get(updateInterface.getId()).update(updateInterface);
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("", throwable);
                    }
                }
            });
        } else {
            LOGGER.info("No request found with id " + updateInterface.getId());
        }
    }

    public String registerStream(ByteBuffer byteBuffer) throws IOException, StreamAlreadyRegisteredException {
        return this.registerStream(ByteSource.wrap((byte[])byteBuffer.array()));
    }

    public ClientTask get(String string) {
        if (this.asyncCalls.containsKey(string)) {
            return this.asyncCalls.get(string);
        }
        Request request = Request.fromId(string);
        request.auth(this.auth);
        AsyncTask asyncTask = new AsyncTask(this.node, this.nodeTransport, request);
        asyncTask.setExecutedOrExecuting(true);
        this.asyncCalls.put(asyncTask.getId(), asyncTask);
        return asyncTask;
    }

    public Future<Void> getStream(String string, OutputStream outputStream) {
        return this.nodeTransport.receiveStream(string, outputStream);
    }

    public Future<Void> getStream(StreamDescriptor streamDescriptor, OutputStream outputStream) {
        return this.nodeTransport.receiveStream(streamDescriptor.getKey(), outputStream);
    }

    public LightContainerInterface getNode() {
        return this.node;
    }

    public ObjectNode getAuth() {
        return this.auth;
    }

    public String getUsername() {
        return this.auth.get("input").get("username").asText();
    }

    public String registerStream(String string, String string2, String string3, long l) throws MalformedURLException, StreamAlreadyRegisteredException {
        String string4 = UUID.randomUUID().toString();
        this.node.getStreamManager().putStream(new UrlStreamDescriptor(string4, string2, string, new URL(string3), l));
        return string4;
    }

    public NodeTransport getNodeTransport() {
        return this.nodeTransport;
    }

    public String registerStream(String string, long l, String string2, InputStream inputStream) throws StreamAlreadyRegisteredException {
        String string3 = UUID.randomUUID().toString();
        this.node.getStreamManager().putStream(new InputStreamStreamDescriptor(string3, string, l, string2, inputStream));
        return string3;
    }
}

