/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane.conf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.sascom.backplane.conf.HttpsNetworkConfiguration;
import nl.sascom.backplane.conf.NetworkConfiguration;

public class NetworkingConfiguration {
    @JsonProperty(value="bind")
    private List<NetworkConfiguration> binds = new ArrayList<NetworkConfiguration>();
    @JsonProperty(value="private")
    private List<NetworkConfiguration> privateNetworks = new ArrayList<NetworkConfiguration>();
    @JsonProperty(value="public")
    private List<NetworkConfiguration> publicNetworks = new ArrayList<NetworkConfiguration>();

    public List<NetworkConfiguration> getBinds() {
        return this.binds;
    }

    public void setBinds(List<NetworkConfiguration> list) {
        this.binds = list;
    }

    public List<NetworkConfiguration> getPrivateNetworks() {
        return this.privateNetworks;
    }

    public void setPrivateNetworks(List<NetworkConfiguration> list) {
        this.privateNetworks = list;
    }

    public List<NetworkConfiguration> getPublicNetworks() {
        return this.publicNetworks;
    }

    public void setPublicNetworks(List<NetworkConfiguration> list) {
        this.publicNetworks = list;
    }

    @JsonIgnore
    public String getDefaultPublicUrl() {
        for (NetworkConfiguration networkConfiguration : this.publicNetworks) {
            if (networkConfiguration.getDns() != null) {
                return networkConfiguration.getProtocol() + "://" + networkConfiguration.getDns() + ":" + networkConfiguration.getPort();
            }
            if (networkConfiguration.getIp() == null) continue;
            return networkConfiguration.getProtocol() + "://" + networkConfiguration.getIp() + ":" + networkConfiguration.getPort();
        }
        return null;
    }

    @JsonIgnore
    public String getDefaultVirtualHost() {
        for (NetworkConfiguration networkConfiguration : this.publicNetworks) {
            if (networkConfiguration.getDns() != null) {
                return networkConfiguration.getDns();
            }
            if (networkConfiguration.getIp() == null) continue;
            return networkConfiguration.getIp();
        }
        return null;
    }

    public static NetworkingConfiguration quick(String string, int n, String string2) {
        NetworkingConfiguration networkingConfiguration = new NetworkingConfiguration();
        HttpsNetworkConfiguration httpsNetworkConfiguration = new HttpsNetworkConfiguration();
        httpsNetworkConfiguration.setIp(string);
        httpsNetworkConfiguration.setPort(n);
        networkingConfiguration.getBinds().add(httpsNetworkConfiguration);
        HttpsNetworkConfiguration httpsNetworkConfiguration2 = new HttpsNetworkConfiguration();
        httpsNetworkConfiguration2.setDns(string2);
        httpsNetworkConfiguration2.setPort(n);
        networkingConfiguration.getPublicNetworks().add(httpsNetworkConfiguration2);
        return networkingConfiguration;
    }

    @JsonIgnore
    public NetworkConfiguration getBestPrivateNetwork() {
        Iterator<NetworkConfiguration> iterator = this.privateNetworks.iterator();
        if (iterator.hasNext()) {
            NetworkConfiguration networkConfiguration = iterator.next();
            return networkConfiguration;
        }
        iterator = this.publicNetworks.iterator();
        if (iterator.hasNext()) {
            NetworkConfiguration networkConfiguration = iterator.next();
            return networkConfiguration;
        }
        return null;
    }

    @JsonIgnore
    public NetworkConfiguration getFirstPublicNetwork() {
        return this.publicNetworks.iterator().next();
    }
}

