/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import nl.bimbase.bimworks.client.BimWorksClient;
import nl.bimbase.bimworks.client.BimWorksException;
import nl.bimbase.bimworks.client.NodeAlreadyExistsException;
import nl.bimbase.bimworks.client.UploadModelResponse;
import nl.bimbase.bimworks.client.UploadOption;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.CommonErrorCode;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.StreamAlreadyRegisteredException;
import nl.sascom.backplanepublic.common.utils.HashingUtils;

public class UploadApi {
    private final BimWorksClient bimWorksClient;

    public UploadApi(BimWorksClient bimWorksClient) {
        this.bimWorksClient = bimWorksClient;
    }

    public UploadModelResponse uploadModel(UUID uUID, String string, long l, InputStream inputStream) throws IOException, InterruptedException, BimWorksException, StreamAlreadyRegisteredException, NodeAlreadyExistsException {
        return this.uploadModel(uUID, string, l, inputStream, null);
    }

    public UploadModelResponse uploadModel(UUID uUID, String string, long l, InputStream inputStream, UploadOption uploadOption) throws IOException, InterruptedException, BimWorksException, StreamAlreadyRegisteredException, NodeAlreadyExistsException {
        Request request = this.bimWorksClient.createRequest();
        request.setTaskName("UploadModelToTree");
        request.put("filename", string);
        request.put("filesize", l);
        String string2 = "application/ifc";
        request.put("contentType", string2);
        request.put("node_uuid", uUID.toString());
        ObjectNode objectNode = Response.createObject();
        if (uploadOption != null) {
            objectNode.put("force", uploadOption.name());
        }
        request.set("options", (JsonNode)objectNode);
        ObjectNode objectNode2 = Response.createObject();
        request.set("hash", (JsonNode)objectNode2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(32768);
        objectNode2.put("partial_sha256", HashingUtils.extractPartialSha256(bufferedInputStream));
        bufferedInputStream.reset();
        request.setTimeOut(4L, TimeUnit.HOURS);
        String string3 = this.bimWorksClient.registerStream(string, l, string2, bufferedInputStream);
        request.attachStream(string3);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(4L, TimeUnit.HOURS);
            return new UploadModelResponse(response.getObjectOutput());
        }
        catch (ExecuteException executeException) {
            if (executeException.getErrorCode().name().equals("DefaultErrorCode") && executeException.getErrorCode().getCode() == 29) {
                throw new NodeAlreadyExistsException(executeException.getUserSafeMessage());
            }
            throw new BimWorksException(executeException);
        }
    }

    public UploadModelResponse uploadModel(UUID uUID, Path path) throws IOException, InterruptedException, BimWorksException, StreamAlreadyRegisteredException, NodeAlreadyExistsException {
        return this.uploadModel(uUID, path, null);
    }

    public UploadModelResponse uploadModel(UUID uUID, Path path, UploadOption uploadOption) throws IOException, InterruptedException, BimWorksException, StreamAlreadyRegisteredException, NodeAlreadyExistsException {
        Request request = this.bimWorksClient.createRequest();
        request.setTaskName("UploadModelToTree");
        request.put("filename", path.getFileName().toString());
        request.put("filesize", Files.size(path));
        request.put("contentType", "application/ifc");
        request.put("node_uuid", uUID.toString());
        ObjectNode objectNode = Response.createObject();
        if (uploadOption != null) {
            objectNode.put("force", uploadOption.name());
        }
        request.set("options", (JsonNode)objectNode);
        ObjectNode objectNode2 = Response.createObject();
        request.set("hash", (JsonNode)objectNode2);
        try (Object object = Files.newInputStream(path, new OpenOption[0]);){
            objectNode2.put("partial_sha256", HashingUtils.extractPartialSha256((InputStream)object));
        }
        request.setTimeOut(4L, TimeUnit.HOURS);
        object = this.bimWorksClient.registerStream(path);
        request.attachStream((String)object);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(4L, TimeUnit.HOURS);
            return new UploadModelResponse(response.getObjectOutput());
        }
        catch (ExecuteException executeException) {
            if (executeException.getErrorCode().name().equals("DefaultErrorCode") && executeException.getErrorCode().getCode() == 29) {
                throw new NodeAlreadyExistsException(executeException.getUserSafeMessage());
            }
            throw new BimWorksException(executeException);
        }
    }

    public UploadModelResponse uploadModel(UUID uUID, String string, String string2, String string3, long l) throws IOException, InterruptedException, BimWorksException, StreamAlreadyRegisteredException, NodeAlreadyExistsException {
        Request request = this.bimWorksClient.createRequest();
        request.setTaskName("UploadModelToTree");
        request.put("filename", string);
        request.put("filesize", l);
        request.put("contentType", "application/ifc");
        request.put("node_uuid", uUID.toString());
        request.setTimeOut(4L, TimeUnit.HOURS);
        String string4 = this.bimWorksClient.registerStream(string, string2, string3, l);
        request.attachStream(string4);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(4L, TimeUnit.HOURS);
            if (response.getObjectOutput() == null) {
                throw new ExecuteException(CommonErrorCode.NO_OUTPUT_IN_RESPONSE);
            }
            return new UploadModelResponse(response.getObjectOutput());
        }
        catch (ExecuteException executeException) {
            if (executeException.getErrorCode().name().equals("DefaultErrorCode") && executeException.getErrorCode().getCode() == 29) {
                throw new NodeAlreadyExistsException(executeException.getUserSafeMessage());
            }
            throw new BimWorksException(executeException);
        }
    }
}

