/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import nl.bimbase.bimworks.client.BimWorksClient;
import nl.bimbase.bimworks.client.BimWorksException;
import nl.sascom.backplane.appbase.library.DefaultErrorCode;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class TokensApi {
    private final BimWorksClient bimWorksClient;

    public TokensApi(BimWorksClient bimWorksClient) {
        this.bimWorksClient = bimWorksClient;
    }

    public ObjectNode createVersionsToken(Set<UUID> set, Duration duration) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setTaskName("CreateVersionsToken");
        ArrayNode arrayNode = Response.createArray();
        for (UUID object : set) {
            arrayNode.add(object.toString());
        }
        request.getObjectInput().put("expires_seconds", duration.getSeconds());
        request.getObjectInput().set("version_uuids", (JsonNode)arrayNode);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response executeException = clientTask.await(30L, TimeUnit.SECONDS);
            return (ObjectNode)executeException.getObjectOutput().get("auth");
        }
        catch (ExecuteException interruptedException) {
            throw new BimWorksException(interruptedException);
        }
        catch (InterruptedException interruptedException) {
            throw new BimWorksException(DefaultErrorCode.INTERRUPTED);
        }
    }

    public ObjectNode createNodesToken(Set<UUID> set, Duration duration) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setTaskName("CreateNodesToken");
        ArrayNode arrayNode = Response.createArray();
        for (UUID object : set) {
            arrayNode.add(object.toString());
        }
        request.getObjectInput().put("expires_seconds", duration.getSeconds());
        request.getObjectInput().set("node_uuids", (JsonNode)arrayNode);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response executeException = clientTask.await(30L, TimeUnit.SECONDS);
            return (ObjectNode)executeException.getObjectOutput().get("auth");
        }
        catch (ExecuteException interruptedException) {
            throw new BimWorksException(interruptedException);
        }
        catch (InterruptedException interruptedException) {
            throw new BimWorksException(DefaultErrorCode.INTERRUPTED);
        }
    }
}

