/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import nl.bimbase.bimworks.actions.Discipline;
import nl.bimbase.bimworks.client.BimQueryValidationException;
import nl.bimbase.bimworks.client.CalculatedValueQuery;
import nl.bimbase.bimworks.client.FieldQuery;
import nl.bimbase.bimworks.client.Operator;
import nl.bimbase.bimworks.client.PropertyQuery;
import nl.bimbase.bimworks.client.Qid;
import nl.bimbase.bimworks.client.QuantityValueQuery;
import nl.bimbase.bimworks.client.UnsupportedBimQueryVersion;

public class BimQuery {
    public static final BimQuery ALL = new BimQuery();
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int VERSION = 1;
    private int version = 1;
    private Set<String> types;
    private Set<Integer> buildingStoreyLevels;
    private Set<String> buildingStoreyNames;
    private Set<Qid> buildingStoreyQids;
    private Set<Qid> qids;
    private Map<String, FieldQuery> fields;
    private Map<String, Map<String, PropertyQuery>> properties;
    private Set<CalculatedValueQuery> calculatedValues;
    private Set<QuantityValueQuery> quantities;
    private Set<Discipline> disciplines;
    private Set<String> layers;
    private Set<String> classifications;
    private Set<String> materialNames;
    private Set<String> guids;
    private Set<String> propertySets;
    private Set<String> zones;
    private Map<String, String> modelInfo;
    private Set<String> groupFeatures;

    public boolean isEmpty() {
        return this.types == null && this.buildingStoreyLevels == null && this.qids == null && this.fields == null && this.properties == null && this.calculatedValues == null && this.quantities == null && this.disciplines == null && this.layers == null && this.classifications == null && this.materialNames == null && this.buildingStoreyNames == null && this.guids == null && this.propertySets == null && this.zones == null && this.buildingStoreyQids == null && this.modelInfo == null;
    }

    public BimQuery addType(String ... stringArray) {
        if (this.types == null) {
            this.types = new TreeSet<String>();
        }
        for (String string : stringArray) {
            this.types.add(string);
        }
        return this;
    }

    public BimQuery addBuildingStoreyLevel(int n) {
        if (this.buildingStoreyLevels == null) {
            this.buildingStoreyLevels = new HashSet<Integer>();
        }
        this.buildingStoreyLevels.add(n);
        return this;
    }

    public ObjectNode toJson() {
        Object object;
        ArrayNode arrayNode;
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("version", this.version);
        if (this.types != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.types) {
                arrayNode.add(string);
            }
            objectNode.set("types", (JsonNode)arrayNode);
        }
        if (this.modelInfo != null) {
            arrayNode = OBJECT_MAPPER.createObjectNode();
            for (String string : this.modelInfo.keySet()) {
                arrayNode.put(string, this.modelInfo.get(string));
            }
        }
        if (this.buildingStoreyLevels != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            Iterator<Object> iterator = this.buildingStoreyLevels.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                arrayNode.add(n);
            }
            objectNode.set("buildingStoreyLevels", (JsonNode)arrayNode);
        }
        if (this.buildingStoreyQids != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (Qid qid : this.buildingStoreyQids) {
                arrayNode.add(qid.toString());
            }
            objectNode.set("buildingStoreyQids", (JsonNode)arrayNode);
        }
        if (this.buildingStoreyNames != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.buildingStoreyNames) {
                arrayNode.add(string);
            }
            objectNode.set("buildingStoreys", (JsonNode)arrayNode);
        }
        if (this.layers != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.layers) {
                arrayNode.add(string);
            }
            objectNode.set("layers", (JsonNode)arrayNode);
        }
        if (this.zones != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.zones) {
                arrayNode.add(string);
            }
            objectNode.set("zones", (JsonNode)arrayNode);
        }
        if (this.materialNames != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.materialNames) {
                arrayNode.add(string);
            }
            objectNode.set("materialNames", (JsonNode)arrayNode);
        }
        if (this.quantities != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (QuantityValueQuery quantityValueQuery : this.quantities) {
                arrayNode.add((JsonNode)quantityValueQuery.toJson());
            }
            objectNode.set("quantities", (JsonNode)arrayNode);
        }
        if (this.classifications != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.classifications) {
                arrayNode.add(string);
            }
            objectNode.set("classifications", (JsonNode)arrayNode);
        }
        if (this.qids != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (Qid qid : this.qids) {
                arrayNode.add(qid.toString());
            }
            objectNode.set("qids", (JsonNode)arrayNode);
        }
        if (this.disciplines != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (Discipline discipline : this.disciplines) {
                arrayNode.add(discipline.name());
            }
            objectNode.set("disciplines", (JsonNode)arrayNode);
        }
        if (this.guids != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.guids) {
                arrayNode.add(string);
            }
            objectNode.set("guids", (JsonNode)arrayNode);
        }
        if (this.fields != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.fields.keySet()) {
                object = this.fields.get(string);
                arrayNode.add((JsonNode)((FieldQuery)object).toJson());
            }
            objectNode.set("fields", (JsonNode)arrayNode);
        }
        if (this.properties != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.properties.keySet()) {
                object = this.properties.get(string);
                for (String string2 : object.keySet()) {
                    arrayNode.add((JsonNode)((PropertyQuery)object.get(string2)).toJson());
                }
            }
            objectNode.set("properties", (JsonNode)arrayNode);
        }
        if (this.propertySets != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.propertySets) {
                arrayNode.add(string);
            }
            objectNode.set("propertySets", (JsonNode)arrayNode);
        }
        if (this.calculatedValues != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (CalculatedValueQuery calculatedValueQuery : this.calculatedValues) {
                arrayNode.add((JsonNode)calculatedValueQuery.toJson());
            }
            objectNode.set("calculated", (JsonNode)arrayNode);
        }
        if (this.groupFeatures != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.groupFeatures) {
                arrayNode.add(string);
            }
            objectNode.set("group", (JsonNode)arrayNode);
        }
        return objectNode;
    }

    public BimQuery addProperty(String string, String string2, Operator operator, JsonNode jsonNode) {
        Map<String, PropertyQuery> map;
        if (this.properties == null) {
            this.properties = new HashMap<String, Map<String, PropertyQuery>>();
        }
        if ((map = this.properties.get(string)) == null) {
            map = new HashMap<String, PropertyQuery>();
            this.properties.put(string, map);
        }
        map.put(string2, new PropertyQuery(string, string2, operator, jsonNode));
        return this;
    }

    public static BimQuery of(ObjectNode objectNode) throws UnsupportedBimQueryVersion, BimQueryValidationException {
        Operator operator;
        JsonNode jsonNode;
        Object object;
        Iterator iterator;
        Object object2;
        if (objectNode == null) {
            return ALL;
        }
        BimQuery bimQuery = new BimQuery();
        if (!(objectNode = objectNode.deepCopy()).has("version")) {
            throw new BimQueryValidationException("version field is required");
        }
        bimQuery.version = objectNode.get("version").asInt();
        objectNode.remove("version");
        if (bimQuery.version != 1) {
            throw new UnsupportedBimQueryVersion(bimQuery.version, 1);
        }
        if (objectNode.has("propertySets")) {
            object2 = (ArrayNode)objectNode.get("propertySets");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addPropertySet(object.asText());
            }
            objectNode.remove("propertySets");
        }
        if (objectNode.hasNonNull("modelInfo")) {
            object2 = (ArrayNode)objectNode.get("modelInfo");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
            }
            objectNode.remove("modelInfo");
        }
        if (objectNode.has("types")) {
            object2 = (ArrayNode)objectNode.get("types");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addType(object.asText());
            }
            objectNode.remove("types");
        }
        if (objectNode.has("zones")) {
            object2 = (ArrayNode)objectNode.get("zones");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addZone(object.asText());
            }
            objectNode.remove("zones");
        }
        if (objectNode.has("guids")) {
            object2 = (ArrayNode)objectNode.get("guids");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addGuid(object.asText());
            }
            objectNode.remove("guids");
        }
        if (objectNode.has("buildingStoreyLevels")) {
            object2 = (ArrayNode)objectNode.get("buildingStoreyLevels");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addBuildingStoreyLevel(object.asInt());
            }
            objectNode.remove("buildingStoreyLevels");
        }
        if (objectNode.hasNonNull("buildingStoreyQids")) {
            object2 = (ArrayNode)objectNode.get("buildingStoreyQids");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addBuildingStoreyQid(Qid.of(object.asText()));
            }
            objectNode.remove("buildingStoreyQids");
        }
        if (objectNode.has("buildingStoreyNames")) {
            object2 = (ArrayNode)objectNode.get("buildingStoreyNames");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addBuildingStoreyName(object.asText());
            }
            objectNode.remove("buildingStoreyNames");
        }
        if (objectNode.has("qids")) {
            object2 = (ArrayNode)objectNode.get("qids");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addQid(Qid.of(object.asText()));
            }
            objectNode.remove("qids");
        }
        if (objectNode.has("classifications")) {
            object2 = (ArrayNode)objectNode.get("classifications");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addClassification(object.asText());
            }
            objectNode.remove("classifications");
        }
        if (objectNode.has("materialNames")) {
            object2 = (ArrayNode)objectNode.get("materialNames");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addMaterialName(object.asText());
            }
            objectNode.remove("materialNames");
        }
        if (objectNode.has("fields")) {
            object2 = (ArrayNode)objectNode.get("fields");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                jsonNode = object.get("name").asText();
                operator = Operator.EXISTS;
                if (object.has("operator")) {
                    operator = Operator.bySymbol(object.get("operator").asText());
                }
                bimQuery.addField((String)jsonNode, operator, object.get("value"));
            }
            objectNode.remove("fields");
        }
        if (objectNode.has("quantities")) {
            object2 = (ArrayNode)objectNode.get("quantities");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addQuantity(QuantityValueQuery.of((JsonNode)object));
            }
            objectNode.remove("quantities");
        }
        if (objectNode.has("layers")) {
            object2 = (ArrayNode)objectNode.get("layers");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addLayer(object.asText());
            }
            objectNode.remove("layers");
        }
        if (objectNode.has("disciplines")) {
            object2 = (ArrayNode)objectNode.get("disciplines");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                bimQuery.addDiscipline(Discipline.valueOf(object.asText().toLowerCase()));
            }
            objectNode.remove("disciplines");
        }
        if (objectNode.has("properties")) {
            object2 = (ArrayNode)objectNode.get("properties");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                String string = jsonNode = object.has("propertySetName") ? object.get("propertySetName").asText() : null;
                if (object.has("value")) {
                    bimQuery.addProperty((String)jsonNode, object.get("name").asText(), Operator.bySymbol(object.get("operator").asText()), object.get("value"));
                    continue;
                }
                bimQuery.addProperty((String)jsonNode, object.get("name").asText());
            }
            objectNode.remove("properties");
        }
        if (objectNode.has("calculated")) {
            object2 = (ArrayNode)objectNode.get("calculated");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (JsonNode)iterator.next();
                if (!object.has("name")) continue;
                jsonNode = object.get("name").asText().split("\\.");
                operator = Operator.EQUALS;
                if (object.hasNonNull("operator")) {
                    operator = Operator.bySymbol(object.get("operator").asText());
                }
                bimQuery.addCalculatedValue(new CalculatedValueQuery((String[])jsonNode, operator, object.get("value")));
            }
            objectNode.remove("calculated");
        }
        if (objectNode.hasNonNull("group")) {
            object2 = objectNode.get("group");
            if (object2 instanceof ObjectNode) {
                iterator = (ObjectNode)object2;
                bimQuery.addGroup(iterator.asText());
            } else if (object2 instanceof ArrayNode) {
                iterator = (ArrayNode)object2;
                object = iterator.iterator();
                while (object.hasNext()) {
                    jsonNode = (JsonNode)object.next();
                    bimQuery.addGroup(jsonNode.asText());
                }
            }
            objectNode.remove("group");
        }
        if (objectNode.has("features")) {
            objectNode.remove("features");
        }
        if ((object2 = objectNode.fieldNames()).hasNext()) {
            throw new BimQueryValidationException("Unexpected field: " + (String)object2.next());
        }
        return bimQuery;
    }

    public BimQuery addGroup(String string) {
        if (this.groupFeatures == null) {
            this.groupFeatures = new LinkedHashSet<String>();
        }
        this.groupFeatures.add(string);
        return this;
    }

    public void addBuildingStoreyQid(Qid qid) {
        if (this.buildingStoreyQids == null) {
            this.buildingStoreyQids = new HashSet<Qid>();
        }
        this.buildingStoreyQids.add(qid);
    }

    public void addModelInfo(String string, String string2) {
        if (this.modelInfo == null) {
            this.modelInfo = new HashMap<String, String>();
        }
        this.modelInfo.put(string, string2);
    }

    public BimQuery addGuid(String string) {
        if (this.guids == null) {
            this.guids = new HashSet<String>();
        }
        this.guids.add(string);
        return this;
    }

    private void addBuildingStoreyName(String string) {
        if (this.buildingStoreyNames == null) {
            this.buildingStoreyNames = new HashSet<String>();
        }
        this.buildingStoreyNames.add(string);
    }

    public BimQuery addLayer(String string) {
        if (this.layers == null) {
            this.layers = new HashSet<String>();
        }
        this.layers.add(string);
        return this;
    }

    public void addDiscipline(Discipline discipline) {
        if (this.disciplines == null) {
            this.disciplines = new HashSet<Discipline>();
        }
        this.disciplines.add(discipline);
    }

    public String toString() {
        return this.toJson().toString();
    }

    private void addQid(Qid qid) {
        if (this.qids == null) {
            this.qids = new TreeSet<Qid>();
        }
        this.qids.add(qid);
    }

    public BimQuery addField(String string, Operator operator, JsonNode jsonNode) {
        if (this.fields == null) {
            this.fields = new TreeMap<String, FieldQuery>();
        }
        this.fields.put(string, new FieldQuery(string, operator, jsonNode));
        return this;
    }

    public BimQuery addField(String string) {
        if (this.fields == null) {
            this.fields = new TreeMap<String, FieldQuery>();
        }
        this.fields.put(string, new FieldQuery(string, Operator.EXISTS, null));
        return this;
    }

    public void addField(String string, Operator operator, double d) {
        if (this.fields == null) {
            this.fields = new TreeMap<String, FieldQuery>();
        }
        this.fields.put(string, new FieldQuery(string, operator, (JsonNode)DoubleNode.valueOf((double)d)));
    }

    public BimQuery addProperty(String string, String string2) {
        Map<String, PropertyQuery> map;
        if (this.properties == null) {
            this.properties = new TreeMap<String, Map<String, PropertyQuery>>();
        }
        if (string == null) {
            string = "*";
        }
        if ((map = this.properties.get(string)) == null) {
            map = new TreeMap<String, PropertyQuery>();
            this.properties.put(string, map);
        }
        map.put(string2, new PropertyQuery(string, string2, Operator.EXISTS, null));
        return this;
    }

    public BimQuery addCalculatedValue(CalculatedValueQuery calculatedValueQuery) {
        if (this.calculatedValues == null) {
            this.calculatedValues = new TreeSet<CalculatedValueQuery>();
        }
        this.calculatedValues.add(calculatedValueQuery);
        return this;
    }

    public Set<Discipline> getDisciplines() {
        return this.disciplines;
    }

    public void addClassification(String string) {
        if (this.classifications == null) {
            this.classifications = new HashSet<String>();
        }
        this.classifications.add(string);
    }

    public BimQuery addMaterialName(String string) {
        if (this.materialNames == null) {
            this.materialNames = new HashSet<String>();
        }
        this.materialNames.add(string);
        return this;
    }

    public void addQuantity(QuantityValueQuery quantityValueQuery) {
        if (this.quantities == null) {
            this.quantities = new HashSet<QuantityValueQuery>();
        }
        this.quantities.add(quantityValueQuery);
    }

    public void addPropertySet(String string) {
        if (this.propertySets == null) {
            this.propertySets = new HashSet<String>();
        }
        this.propertySets.add(string);
    }

    public BimQuery addZone(String string) {
        if (this.zones == null) {
            this.zones = new HashSet<String>();
        }
        this.zones.add(string);
        return this;
    }

    public Set<Qid> getBuildingStoreyQids() {
        return this.buildingStoreyQids;
    }

    public void setBuildingStoreyQids(Set<Qid> set) {
        this.buildingStoreyQids = set;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public Set<String> getGuids() {
        return this.guids;
    }

    public Set<Integer> getBuildingStoreyLevels() {
        return this.buildingStoreyLevels;
    }

    public Set<String> getMaterialNames() {
        return this.materialNames;
    }

    public Set<String> getLayers() {
        return this.layers;
    }

    public Set<String> getZones() {
        return this.zones;
    }

    public Map<String, Map<String, PropertyQuery>> getProperties() {
        return this.properties;
    }

    public Set<PropertyQuery> getPropertiesQueries() {
        HashSet<PropertyQuery> hashSet = new HashSet<PropertyQuery>();
        for (Map<String, PropertyQuery> map : this.properties.values()) {
            for (PropertyQuery propertyQuery : map.values()) {
                hashSet.add(propertyQuery);
            }
        }
        return hashSet;
    }

    public Map<String, FieldQuery> getFields() {
        return this.fields;
    }

    public Set<CalculatedValueQuery> getCalculatedValues() {
        return this.calculatedValues;
    }

    public Set<String> getClassifications() {
        return this.classifications;
    }

    public Set<String> getBuildingStoreyNames() {
        return this.buildingStoreyNames;
    }

    public Set<QuantityValueQuery> getQuantities() {
        return this.quantities;
    }

    public boolean hasQids() {
        return this.qids != null && !this.qids.isEmpty();
    }

    public boolean hasTypes() {
        return this.types != null && !this.types.isEmpty();
    }

    public boolean hasBuildingStoreyNames() {
        return this.buildingStoreyNames != null && !this.buildingStoreyNames.isEmpty();
    }

    public boolean hasBuildingStoreyQids() {
        return this.buildingStoreyQids != null && !this.buildingStoreyQids.isEmpty();
    }

    public boolean hasBuildingStoreyLevels() {
        return this.buildingStoreyLevels != null && !this.buildingStoreyLevels.isEmpty();
    }

    public boolean hasMaterialNames() {
        return this.materialNames != null && !this.materialNames.isEmpty();
    }

    public boolean hasLayers() {
        return this.layers != null && !this.layers.isEmpty();
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public boolean hasClassifications() {
        return this.classifications != null && !this.classifications.isEmpty();
    }

    public Set<Qid> getQids() {
        return this.qids;
    }

    public boolean hasCalculated() {
        return this.calculatedValues != null && !this.calculatedValues.isEmpty();
    }

    public boolean hasGuids() {
        return this.guids != null && !this.guids.isEmpty();
    }

    public boolean hasFields() {
        return this.fields != null && !this.fields.isEmpty();
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean hasQuantities() {
        return this.quantities != null && !this.quantities.isEmpty();
    }

    public boolean hasAggregations() {
        return this.groupFeatures != null && !this.groupFeatures.isEmpty();
    }

    public Set<String> getGroupFeatures() {
        return this.groupFeatures;
    }

    public void setGroupFeatures(Set<String> set) {
        this.groupFeatures = set;
    }
}

