package nl.bimbase.bimworks.client;

import java.util.UUID;
import java.util.concurrent.TimeUnit;

import com.google.common.io.ByteSource;

import nl.sascom.backplane.appbase.library.DefaultErrorCode;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.NewStreamDescriptor;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class IfcApi {

	private final BimWorksClient bimWorksClient;

	public IfcApi(BimWorksClient bimWorksClient) {
		this.bimWorksClient = bimWorksClient;
	}
	
	public ByteSource downloadModel(UUID versionUuid) throws BimWorksException {
		Request request = bimWorksClient.createRequest();
		request.setTaskName("DownloadModel");
		request.put("version_uuid", versionUuid.toString());
		
		ClientTask task = this.bimWorksClient.createAsyncTask(request);
		try {
			task.exec();
			Response response = task.await(30, TimeUnit.SECONDS);
			for (NewStreamDescriptor streamDescriptor : response.getAttachedNewStreams()) {
				streamDescriptor.getAddress();
			}
		} catch (ExecuteException e) {
			throw new BimWorksException(e);
		} catch (InterruptedException e) {
			throw new BimWorksException(DefaultErrorCode.INTERRUPTED);
		}
		return null;
	}
}