/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.ges;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import nl.sascom.backplanepublic.common.ges.ExecutionGroup;
import nl.sascom.backplanepublic.common.ges.GroupExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedExecutionGroup
implements ExecutionGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedExecutionGroup.class);
    private final CountDownLatch finishLatch = new CountDownLatch(1);
    private final GroupExecutorService executorService;
    private final AtomicInteger active = new AtomicInteger();
    private final AtomicInteger idWithinGroup = new AtomicInteger();
    private final String name;
    private volatile boolean doneSubmitting = false;

    public SharedExecutionGroup(GroupExecutorService groupExecutorService, String string) {
        this.executorService = groupExecutorService;
        this.name = string;
    }

    @Override
    public void doneSubmitting() {
        this.doneSubmitting = true;
        if (this.active.get() == 0) {
            this.finishLatch.countDown();
        }
    }

    @Override
    public void await(int n, TimeUnit timeUnit) throws InterruptedException {
        this.finishLatch.await(n, timeUnit);
    }

    @Override
    public void submit(final Runnable runnable) {
        final int n = this.idWithinGroup.incrementAndGet();
        this.active.incrementAndGet();
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName(SharedExecutionGroup.this.name + " [" + n + "]");
                    runnable.run();
                }
                catch (Exception exception) {
                    LOGGER.error("", (Throwable)exception);
                }
                finally {
                    Thread.currentThread().setName("[AVAILABLE]");
                    if (SharedExecutionGroup.this.active.decrementAndGet() == 0 && SharedExecutionGroup.this.doneSubmitting) {
                        SharedExecutionGroup.this.finishLatch.countDown();
                    }
                }
            }
        });
    }
}

