/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import nl.sascom.backplanepublic.common.InvalidFieldValueException;
import nl.sascom.backplanepublic.common.RequestValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Validation {
    EMAIL(JsonNodeType.STRING),
    PASSWORD(JsonNodeType.STRING),
    VALIDATION_TOKEN(JsonNodeType.STRING),
    NON_EMPTY_STRING(JsonNodeType.STRING),
    STRING(JsonNodeType.STRING),
    URL(JsonNodeType.STRING),
    TWO_FACTOR_AUTH_CODE(JsonNodeType.NUMBER),
    MONGO_ID(JsonNodeType.STRING),
    LONG(JsonNodeType.NUMBER),
    INTEGER(JsonNodeType.NUMBER),
    UUID(JsonNodeType.STRING);

    private static final Logger LOGGER;
    private JsonNodeType jsonNodeType;

    private Validation(JsonNodeType jsonNodeType) {
        this.jsonNodeType = jsonNodeType;
    }

    public JsonNodeType getNodeType() {
        return this.jsonNodeType;
    }

    public Object validate(String string, JsonNode jsonNode) throws RequestValidationException {
        switch (this) {
            case EMAIL: {
                if (jsonNode.asText().contains("@") && jsonNode.asText().contains(".")) {
                    return jsonNode.asText();
                }
                throw new InvalidFieldValueException(string, "Invalid email address");
            }
            case PASSWORD: {
                return jsonNode.asText();
            }
            case VALIDATION_TOKEN: {
                return jsonNode.asText();
            }
            case TWO_FACTOR_AUTH_CODE: {
                return jsonNode.asInt();
            }
            case STRING: {
                return jsonNode.asText();
            }
            case INTEGER: {
                int n = jsonNode.asInt();
                return n;
            }
            case LONG: {
                long l = jsonNode.asLong();
                return l;
            }
            case NON_EMPTY_STRING: {
                String string2 = jsonNode.asText();
                if (string2.trim().equals("")) {
                    throw new InvalidFieldValueException(string, "Field cannot be empty");
                }
                return string2;
            }
            case URL: {
                String string3 = jsonNode.asText();
                try {
                    URL uRL = new URL(string3);
                    return uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new InvalidFieldValueException(string, "Invalid URL");
                }
            }
            case MONGO_ID: {
                String string4 = jsonNode.asText();
                if (string4.length() != 24) {
                    throw new InvalidFieldValueException(string, "Invalid database ID");
                }
                return string4;
            }
            case UUID: {
                return java.util.UUID.fromString(jsonNode.asText());
            }
        }
        LOGGER.error("Unimplemented: " + this);
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Validation.class);
    }
}

