/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.io.ByteSource;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import nl.sascom.backplanepublic.common.Stream;
import nl.sascom.backplanepublic.common.StreamManager;
import nl.sascom.backplanepublic.common.StreamMetaData;
import nl.sascom.backplanepublic.common.WebSocketStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeWebSocketStream
implements Stream,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketStream.class);
    private RandomAccessFile randomAccessFile;
    private int writePosition = 0;
    private int lastWriteSequence = -1;
    private volatile boolean writingDone;
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private Path path;
    private String key;
    private StreamMetaData streamMetaData;

    public SafeWebSocketStream(StreamManager streamManager, String string, StreamMetaData streamMetaData) {
        this.key = string;
        this.streamMetaData = streamMetaData;
        this.path = streamManager.getPath().resolve(this.getKey());
        try {
            this.randomAccessFile = new RandomAccessFile(this.path.toFile(), "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n, ByteBuffer byteBuffer, int n2, int n3) {
        try {
            if (n != this.lastWriteSequence + 1) {
                throw new IOException("Unexpected sequence ID (got " + n + ", expected " + (this.lastWriteSequence + 1) + ")");
            }
            SafeWebSocketStream safeWebSocketStream = this;
            synchronized (safeWebSocketStream) {
                this.randomAccessFile.seek(this.writePosition);
                this.randomAccessFile.write(byteBuffer.array(), n2, n3);
                this.writePosition += n3;
            }
            ++this.lastWriteSequence;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public ByteSource getByteSource() {
        try {
            this.countDownLatch.await(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return new InputStream(){
                    private int readPosition;

                    @Override
                    public int read() throws IOException {
                        return 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public int read(byte[] byArray, int n, int n2) throws IOException {
                        int n3 = SafeWebSocketStream.this.writePosition - this.readPosition;
                        if ((n2 = Math.min(n2, n3)) <= 0) {
                            if (SafeWebSocketStream.this.writingDone) {
                                return -1;
                            }
                            return 0;
                        }
                        int n4 = -1;
                        SafeWebSocketStream safeWebSocketStream = SafeWebSocketStream.this;
                        synchronized (safeWebSocketStream) {
                            SafeWebSocketStream.this.randomAccessFile.seek(this.readPosition);
                            n4 = SafeWebSocketStream.this.randomAccessFile.read(byArray, n, n2);
                        }
                        if (n4 == -1) {
                            if (SafeWebSocketStream.this.writingDone) {
                                return -1;
                            }
                            LOGGER.error("Got -1, but not done yet");
                            throw new IOException("Got -1, but not done yet");
                        }
                        this.readPosition += n4;
                        return n4;
                    }
                };
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writingDone(int n) throws IOException {
        this.writingDone = true;
        Class<WebSocketStream> clazz = WebSocketStream.class;
        synchronized (WebSocketStream.class) {
            this.randomAccessFile.close();
            this.randomAccessFile = new RandomAccessFile(this.path.toFile(), "r");
            this.countDownLatch.countDown();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (n != this.lastWriteSequence + 1) {
                throw new IOException("Unexpected sequence ID (got " + n + ", expected " + (this.lastWriteSequence + 1) + ")");
            }
            return;
        }
    }

    public void writeNull(int n) {
        ++this.lastWriteSequence;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public StreamMetaData getStreamMetaData() {
        return this.streamMetaData;
    }
}

