/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import java.util.UUID;
import nl.sascom.backplanepublic.common.EndPointId;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.Session;

public class RoutingRecord {
    private final ResponseType responseType;
    private final String subType;
    private final String taskId;
    private final UUID sourceNodeUuid;
    private final EndPointId targetNodeId;
    private final Session session;

    public RoutingRecord(ResponseType responseType, String string, String string2, UUID uUID, EndPointId endPointId, Session session) {
        this.responseType = responseType;
        this.subType = string;
        this.taskId = string2;
        this.sourceNodeUuid = uUID;
        this.targetNodeId = endPointId;
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public UUID getSourceNodeUuid() {
        return this.sourceNodeUuid;
    }

    public EndPointId getTargetNodeUuid() {
        return this.targetNodeId;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.responseType == null ? 0 : this.responseType.hashCode());
        n = 31 * n + (this.sourceNodeUuid == null ? 0 : this.sourceNodeUuid.hashCode());
        n = 31 * n + (this.subType == null ? 0 : this.subType.hashCode());
        n = 31 * n + (this.targetNodeId == null ? 0 : this.targetNodeId.hashCode());
        n = 31 * n + (this.taskId == null ? 0 : this.taskId.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RoutingRecord routingRecord = (RoutingRecord)object;
        if (this.responseType != routingRecord.responseType) {
            return false;
        }
        if (this.sourceNodeUuid == null ? routingRecord.sourceNodeUuid != null : !this.sourceNodeUuid.equals(routingRecord.sourceNodeUuid)) {
            return false;
        }
        if (this.subType == null ? routingRecord.subType != null : !this.subType.equals(routingRecord.subType)) {
            return false;
        }
        if (this.targetNodeId == null ? routingRecord.targetNodeId != null : !this.targetNodeId.equals(routingRecord.targetNodeId)) {
            return false;
        }
        return !(this.taskId == null ? routingRecord.taskId != null : !this.taskId.equals(routingRecord.taskId));
    }

    public String toString() {
        return this.responseType.name() + "." + this.subType + ": " + this.sourceNodeUuid + " -> " + this.targetNodeId;
    }
}

