/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.sascom.backplanepublic.common.RegistrationItem;
import nl.sascom.backplanepublic.common.ResponseType;

public class Registration {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ObjectNode objectNode;

    public Registration(ObjectNode objectNode) {
        this.objectNode = objectNode;
    }

    public Registration() {
        this.objectNode = OBJECT_MAPPER.createObjectNode();
    }

    public Registration(ResponseType responseType) {
        this.objectNode = OBJECT_MAPPER.createObjectNode();
        this.objectNode.put(responseType.name(), true);
    }

    public Registration(ResponseType responseType, String string) {
        this.objectNode = OBJECT_MAPPER.createObjectNode();
        this.add(new RegistrationItem(responseType, string));
    }

    public Registration(ResponseType responseType, Set<String> set) {
        if (set == null) {
            this.objectNode = OBJECT_MAPPER.createObjectNode();
            this.objectNode.put(responseType.name(), true);
        } else {
            this.objectNode = OBJECT_MAPPER.createObjectNode();
            for (String string : set) {
                this.add(new RegistrationItem(responseType, string));
            }
        }
    }

    public List<RegistrationItem> listRegistrationItems() {
        ArrayList<RegistrationItem> arrayList = new ArrayList<RegistrationItem>();
        Iterator iterator = this.objectNode.fieldNames();
        while (iterator.hasNext()) {
            ResponseType responseType = ResponseType.valueOf((String)iterator.next());
            JsonNode jsonNode = this.objectNode.get(responseType.name());
            if (jsonNode instanceof ArrayNode) {
                Iterator iterator2 = ((ArrayNode)this.objectNode.get(responseType.name())).iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(new RegistrationItem(responseType, ((JsonNode)iterator2.next()).asText()));
                }
                continue;
            }
            if (!jsonNode.asBoolean()) continue;
            arrayList.add(new RegistrationItem(responseType));
        }
        return arrayList;
    }

    public JsonNode toJson() {
        return this.objectNode;
    }

    public void add(RegistrationItem registrationItem) {
        JsonNode jsonNode = this.objectNode.get(registrationItem.getResponseType().name());
        if (jsonNode == null) {
            if (registrationItem.getSubType() == null || registrationItem.getSubType().equals("[ALL]")) {
                this.objectNode.put(registrationItem.getResponseType().name(), true);
            } else {
                jsonNode = OBJECT_MAPPER.createArrayNode();
                this.objectNode.set(registrationItem.getResponseType().name(), jsonNode);
                ((ArrayNode)jsonNode).add(registrationItem.getSubType());
            }
        } else if (jsonNode.isBoolean()) {
            this.objectNode.put(registrationItem.getResponseType().name(), true);
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            arrayNode.add(registrationItem.getSubType());
        }
    }

    public boolean isEmpty() {
        return this.objectNode.size() == 0;
    }

    public boolean has(ResponseType responseType) {
        return this.objectNode.has(responseType.name());
    }

    public String toString() {
        return this.objectNode.toString();
    }
}

