/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import nl.sascom.backplanepublic.common.AsyncCallback;
import nl.sascom.backplanepublic.common.AsyncTransport;
import nl.sascom.backplanepublic.common.EndPointId;
import nl.sascom.backplanepublic.common.Heartbeat;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.WebSocket;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeHttpAsyncTransport
implements AsyncTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeHttpAsyncTransport.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private CountDownLatch latch = new CountDownLatch(1);
    private Session session;
    private AsyncCallback asyncCallback;
    protected EndPointId endPointId;
    protected CountDownLatch endPointIdLatch = new CountDownLatch(1);
    private ObjectNode auth;
    private String url;
    private WebSocketClient client;
    private Heartbeat heartbeat;
    private WebSocket webSocket;
    private volatile boolean running;
    private HttpClient httpClient;

    public NodeHttpAsyncTransport(ObjectNode objectNode, AsyncCallback asyncCallback, String string, HttpClient httpClient) {
        this.auth = objectNode;
        this.asyncCallback = asyncCallback;
        this.url = string;
        this.httpClient = httpClient;
    }

    public void connect() throws InterruptedException, TimeoutException {
        this.endPointIdLatch = new CountDownLatch(1);
        this.endPointId = null;
        if (this.client != null) {
            try {
                this.client.stop();
                if (this.heartbeat != null) {
                    this.heartbeat.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOGGER.info("Creating new WebSocketClient for " + this.url);
        this.client = new WebSocketClient();
        this.webSocket = new WebSocket(this);
        try {
            this.client.start();
            ClientUpgradeRequest clientUpgradeRequest = new ClientUpgradeRequest();
            Future future = this.client.connect((Object)this.webSocket, URI.create(this.url), clientUpgradeRequest);
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage());
            return;
        }
        this.waitForEndPoint(5L, TimeUnit.SECONDS);
        this.running = true;
    }

    public EndPointId waitForEndPoint(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (!this.endPointIdLatch.await(l, timeUnit)) {
            throw new TimeoutException("No endpoint after " + l + " " + timeUnit.toString() + " for " + this.url);
        }
        return this.endPointId;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void sendMessage(String string) {
        try {
            this.session.getRemote().sendString(string);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
    }

    public void send(ByteBuffer byteBuffer) {
        try {
            this.session.getRemote().sendBytes(byteBuffer);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
    }

    private void sendAuth(ObjectNode objectNode) {
        ObjectNode objectNode2 = OBJECT_MAPPER.createObjectNode();
        objectNode2.set("auth", (JsonNode)objectNode);
        StringWriter stringWriter = new StringWriter();
        try {
            OBJECT_MAPPER.writeValue((Writer)stringWriter, (Object)objectNode2);
            this.sendMessage(stringWriter.toString());
        }
        catch (JsonGenerationException jsonGenerationException) {
            LOGGER.error("", (Throwable)jsonGenerationException);
        }
        catch (JsonMappingException jsonMappingException) {
            LOGGER.error("", (Throwable)jsonMappingException);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
    }

    public void close() {
        long l = System.nanoTime();
        this.running = false;
        if (this.heartbeat != null) {
            this.heartbeat.shutdown();
        }
        System.out.println((System.nanoTime() - l) / 1000000L + " ms to close HB");
        if (this.session != null) {
            this.session.close();
        }
        System.out.println((System.nanoTime() - l) / 1000000L + " ms to close Session");
        try {
            this.client.setStopTimeout(1000L);
            this.client.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println((System.nanoTime() - l) / 1000000L + " ms to Stop");
        this.client.destroy();
        System.out.println((System.nanoTime() - l) / 1000000L + " ms to destroy");
    }

    public EndPointId getEndPointId() {
        return this.endPointId;
    }

    public void setSession(Session session) {
        this.session = session;
        this.latch.countDown();
        this.sendAuth(this.auth);
        this.heartbeat = new Heartbeat(this.webSocket, session);
        this.heartbeat.start();
    }

    public void newData(String string, ResponseType responseType, byte[] byArray) {
        if (this.asyncCallback != null) {
            try {
                this.asyncCallback.newData(string, responseType, byArray);
            }
            catch (Throwable throwable) {
                LOGGER.error("", throwable);
            }
        } else {
            LOGGER.error("No asyncCallback for " + string);
        }
    }

    public void onCloseReconnect() {
        if (this.running) {
            LOGGER.info("WebSocket closed, reconnecting [" + this.url + "]");
            try {
                this.connect();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("", (Throwable)interruptedException);
            }
            catch (TimeoutException timeoutException) {
                LOGGER.error("", (Throwable)timeoutException);
            }
        }
    }
}

