/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryInputStream.class);
    private Path path;
    private Iterator<Path> stream;
    private InputStream currentInputStream = null;
    private Mode mode = Mode.START;
    private int count;
    private DirectoryStream<Path> newDirectoryStream;

    public DirectoryInputStream(Path path) {
        this.path = path;
        try {
            this.count = 0;
            for (Path path2 : Files.newDirectoryStream(path)) {
                ++this.count;
            }
            this.newDirectoryStream = Files.newDirectoryStream(path);
            this.stream = this.newDirectoryStream.iterator();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        this.newDirectoryStream.close();
        if (this.currentInputStream != null) {
            this.currentInputStream.close();
        }
        super.close();
    }

    @Override
    public int read() throws IOException {
        throw new RuntimeException("Not supported");
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mode == Mode.START) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putInt(0, this.count);
            byteBuffer.get(byArray, n, 4);
            this.mode = this.stream.hasNext() ? Mode.NEW_FILE : Mode.DONE;
            return 4;
        }
        if (this.mode == Mode.NEW_FILE) {
            Path path = this.stream.next();
            String string = path.getFileName().toString();
            LOGGER.info("Sending " + string);
            byte[] byArray2 = string.getBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(2 + byArray2.length + 8).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putShort((short)byArray2.length);
            byteBuffer.put(byArray2);
            byteBuffer.putLong(Files.size(path));
            byteBuffer.position(0);
            byteBuffer.get(byArray, n, byteBuffer.capacity());
            this.currentInputStream = Files.newInputStream(path, new OpenOption[0]);
            this.mode = Mode.IN_FILE;
            return byteBuffer.capacity();
        }
        if (this.mode == Mode.IN_FILE) {
            return this.performRead(byArray, n, n2);
        }
        if (this.mode == Mode.DONE) {
            return -1;
        }
        return -1;
    }

    private int performRead(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.currentInputStream.read(byArray, n, n2);
        if (n3 == -1) {
            this.currentInputStream.close();
            if (this.stream.hasNext()) {
                this.mode = Mode.NEW_FILE;
                return this.read(byArray, n, n2);
            }
            this.mode = Mode.DONE;
            this.currentInputStream = null;
        }
        return n3;
    }

    private static enum Mode {
        START,
        NEW_FILE,
        IN_FILE,
        DONE;

    }
}

