/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import nl.sascom.backplane.ByteBufferHolder;
import nl.sascom.backplanepublic.client.AbstractHttpAsyncTransport;
import nl.sascom.backplanepublic.client.HttpHost;
import nl.sascom.backplanepublic.common.AsyncCallback;
import nl.sascom.backplanepublic.common.EndPointId;
import nl.sascom.backplanepublic.common.NodeHttpAsyncTransport;
import nl.sascom.backplanepublic.common.NodeTransport;
import nl.sascom.backplanepublic.common.StreamSendException;
import nl.sascom.backplanepublic.common.TransportException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAsyncTransportHighLevel
extends AbstractHttpAsyncTransport
implements NodeTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAsyncTransportHighLevel.class);
    private NodeHttpAsyncTransport nodeHttpAsyncTransport;
    private AsyncCallback asyncCallback;
    private HTTP2Client httpClient;
    private HttpHost target;
    private SslContextFactory sslContextFactory;
    private HttpClient client;
    private String name;

    public HttpAsyncTransportHighLevel(String string, String string2, int n, String string3) throws Exception {
        LOGGER.info("New transport " + string + "://" + string2 + ":" + n + " (" + string3 + ")");
        this.name = string3;
        this.target = new HttpHost(string, string2, n);
        this.sslContextFactory = new SslContextFactory.Client(false);
        this.httpClient = new HTTP2Client();
        this.httpClient.addBean((Object)this.sslContextFactory);
        this.httpClient.setIdleTimeout(300000L);
        this.httpClient.setMaxConcurrentPushedStreams(1000);
        this.httpClient.start();
        this.client = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP2(this.httpClient), this.sslContextFactory);
        this.client.start();
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public Future<Void> connect() throws InterruptedException, ExecutionException, TimeoutException {
        return new FuturePromise(null);
    }

    @Override
    public void close() throws Exception {
        if (this.nodeHttpAsyncTransport != null) {
            this.nodeHttpAsyncTransport.close();
        }
        this.client.stop();
        this.httpClient.stop();
    }

    @Override
    public synchronized ByteBufferHolder execute(byte[] byArray) throws IOException, InterruptedException, ExecutionException, TransportException {
        final long l = System.nanoTime();
        if (!this.isConnected()) {
            throw new ExecutionException("Not connected", null);
        }
        final ByteBufferHolder byteBufferHolder = new ByteBufferHolder();
        this.client.POST(this.target.toString() + "/api").header("Content-Type", "application/json").content((ContentProvider)new ByteBufferContentProvider(new ByteBuffer[]{ByteBuffer.wrap(byArray)})).send((Response.CompleteListener)new BufferingResponseListener(){

            public void onComplete(Result result) {
                try {
                    byteBufferHolder.set(this.getContent());
                    byteBufferHolder.close();
                }
                catch (Throwable throwable) {
                    LOGGER.error("", throwable);
                }
            }

            public void onFailure(Response response, Throwable throwable) {
                LOGGER.error("", throwable);
                byteBufferHolder.exception((Exception)throwable);
                LOGGER.info((System.nanoTime() - l) / 1000000L + " ms");
            }
        });
        return byteBufferHolder;
    }

    @Override
    public void setAsyncCallback(AsyncCallback asyncCallback) {
        this.asyncCallback = asyncCallback;
    }

    @Override
    public void connectAsync(ObjectNode objectNode) {
        int n = this.target.getPort();
        String string = (this.target.getSchema().equals("https") ? "wss" : "ws") + "://";
        string = string + this.target.getHost();
        if (!(this.target.getSchema().equals("https") && n == 443 || this.target.getSchema().equals("http") && n == 80)) {
            string = string + ":" + n;
        }
        string = string + "/wsc";
        this.nodeHttpAsyncTransport = new NodeHttpAsyncTransport(objectNode, this.asyncCallback, string, this.client);
        try {
            this.nodeHttpAsyncTransport.connect();
        }
        catch (Throwable throwable) {
            LOGGER.error("", throwable);
        }
    }

    @Override
    public void sendStream(String string, ByteSource byteSource) throws StreamSendException, ExecutionException {
        if (!this.isConnected()) {
            throw new ExecutionException("Not connected", null);
        }
        Request request = this.client.POST(this.target.toString() + "/upload").header("identifier", string).header("Content-Type", "text/plain;charset=UTF-8");
        try {
            request.content((ContentProvider)new InputStreamContentProvider(byteSource.openStream()));
            request.send();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public EndPointId getOwnEndpointId() {
        if (this.nodeHttpAsyncTransport == null) {
            return null;
        }
        return this.nodeHttpAsyncTransport.getEndPointId();
    }

    @Override
    public Future<Void> receiveStream(String string, OutputStream outputStream) {
        return null;
    }

    @Override
    public void connectInternal() throws InterruptedException, ExecutionException, TimeoutException {
    }

    @Override
    public void ping() {
    }

    @Override
    public void setNodeClient(Object object) {
    }

    @Override
    public String getName() {
        return this.name;
    }
}

